# -*- coding: utf-8 -*-
# -*- coding: utf-8 -*-

__license__ = 'GPL 3'
__copyright__ = '2011, Jesse Chisholm <jesse.chisholm@gmail.com>'
__docformat__ = 'restructuredtext en'

import os, re

from common import DEBUG
from common import VERBOSE
from common import log
from common import AUDIOBOOK_KNOWN_GENRE
from common import AudioBookException
from baseWrapper import baseWrapper

###############################################################################
#
#   a convenience class to use pyaudibletags to fetch the information we need
#   and allow easy requests for information fields, whether they exist or not.
#
#   usage:
#      aw = aaWrapper(afile)
#      title = aw.get('title')                  # None returned if not available
#      author = aw.get('author', _('Unknown'))  # specify a default value
#
class aaWrapper(baseWrapper):
    # @param:afile - the open file object, or the path to a file
    # @throws: IOError if afile is not one of the above
    #
    def __init__(self, afile):
        baseWrapper.__init__(self, afile)

    def _parse_file(self, afile):
        import pyaudibletags
        if type(afile) is str:
            if VERBOSE: print("debug: aaWrapper: filename : %s" % (afile))
            if -1 != self.filename.find('://'):
                import urllib2
                f = urllib2.urlopen(self.filename)
            else:
                f = file(self.filename,'rb')
            try:
                aa = pyaudibletags.aafile(f)
                for t in aa.tags():
                    self.set(t,aa.tags()[t])
                (coverMime, coverArt) = _fetch_aa_cover(f, aa.toc())
                self.set('cover_data', (coverMime, coverArt))
            finally:
                f.close()
        elif type(afile) is file:
            if VERBOSE: print("debug: aaWrapper: file : %s" % (self.filename))
            try:
                aa = pyaudibletags.aafile(afile)
                for t in aa.tags():
                    self.set(t,aa.tags()[t])
                (coverMime, coverArt) = _fetch_aa_cover(afile, aa.toc())
                self.set('cover_data', (coverMime, coverArt))
            finally:
                pass
        else:
            print("error: unknown argument type: %s" % (type(afile)))
            log.error("unknown argument type: %s" % (type(afile)))
            raise AudioBookException("aaWrapper can't handle argument of type: %s" % (type(afile)))
        #
        # Now to 'canonicalize' it all
        #
        if VERBOSE:
            print "debug: --- begin --- aa file tag collection before 'canonicalization'"
            self.dump()
            print "debug: ---- end ---- aa file tag collection before 'canonicalization'"
        #
        apub = self.get('pubdate')
        if apub:
            from calibre.utils.date import parse_date
            apub = parse_date(apub, True, True)
        acop = self.get('copyright')
        if acop:
            acop = re.sub("\xa9","(c)", acop)
            self.set('copyright',acop)
            temp = acop and re.search("(\d+)", acop) or None
            if temp:
                # put in Feb, in case there is a GMT shift; keeps year unchanged.
                acop = "%s-02-02" % (temp.group(1))
                from calibre.utils.date import parse_date
                acop = parse_date(acop, True, True)
            else:
                acop = None
        # set pubdate to oldest date form of the two
        if apub and acop:
            if apub < acop:
                self.set('pubdate', apub)
            else:
                self.set('pubdate', acop)
        if apub and not acop: self.set('pubdate', apub)
        if not apub and acop: self.set('pubdate', acop)
        #
        #
        #   add some things we are just guessing at
        #
        self.set('tags', [AUDIOBOOK_KNOWN_GENRE[0]])
        self.set('#duration', -1)   # just don't know
        #
        # remove expected things from aa file we don't care about
        #
        for t in ['EncryptedBlocks',
                  'CPUType',
                  'HeaderKey',
                  'HeaderSeed',
                  'feedback',
                 ]:
            self.rem(t)
        #
        # and change a few tag names
        #
        author = self.get('author')
        self.rem('author')
        if author:
            if "&" in author:
                aus = author.split("&")
                for a in range(0,len(aus)): aus[a] = aus[a].strip()
                self.set('authors',aus)
            elif " and " in author:
                aus = author.split(" and ")
                for a in range(0,len(aus)): aus[a] = aus[a].strip()
                self.set('authors',aus)
            else:
                self.set('authors',[author.strip()])
        if self.has('codec'):
            self.set('mime', "audio/%s" % (self.get('codec')))
            self.rem('codec')
        else:
            self.set('mime', "audio/aa")        # TODO: there has got to be a batter assumption that this!
        cdesc = self.get('copyright')
        sdesc = self.get('short_description')
        ldesc = self.get('long_description')
        comments = []
        if cdesc: comments.append("<p>%s</p>" % (cdesc))
        if sdesc: comments.append("<p>%s</p>" % (sdesc))
        if ldesc: comments.append("<p>%s</p>" % (ldesc))
        if comments: comments = "\n".join(comments)
        if comments:
            self.set('comments', comments)
        self.rem('short_description')
        self.rem('long_description')
        self.rem('copyright')
        self.set('publisher', self.get('provider'))
        self.rem('provider')
        if (self.has('part_number')):
            self.set('series_index', self.get('part_number'))
            self.rem('part_number')
        title = self.get('title')
        if title: self.set('title_sort', title)
        title = self.get('short_title')
        if title: self.set('title', title)
        self.rem('short_title')
        #
        if self.has('title') and self.has('series_index'):
            index = float(self.get('series_index'))
            if index:   # non-zero
                self.set('title_sort', "%#03.f %s" % (index, self.get('title')))
        #
        if VERBOSE:
            print "debug: --- begin --- aa file tag collection after 'canonicalization'"
            self.dump()
            print "debug: ---- end ---- aa file tag collection after 'canonicalization'"

###############################################################################

# fetch an image from the aa file
# @param:afile - the open .aa file
# @param:toc - the toc read from that file
# @return:
#     on failure: tuple (None, None)
#     on success: tuple (None, (mimetype, imagedata))
#
def _fetch_aa_cover(afile, toc):
    mime, data = None, None
    if "Cover art" in toc:
        off, len = toc["Cover art"]
        afile.seek(off)
        data = afile.read(len)
        magic = data[:32]   # if we can't tell in the first N bytes, then we are hosed.
        if "PNG" in magic:
            mime = "image/png"
        elif "GIF" in magic:
            mime = "image/gif"
        elif "JFIF" in magic:
            mime = "image/jpeg"
        elif "BM" in magic:
            mime = "image/bmp"
        # TODO: only tested with JFIF image,
        #   but there seems to be an extra 8 bytes on the front.
        #   presumably this means something to aa and is on all formats.
        #       therefore, remove from all formats
        toss = data[:8]
        data = data[8:]
        import struct
        toss = struct.unpack('bbbbbbbb',toss)
        if VERBOSE: print "debug: tossing lead 8 bytes of image data:",toss
        log.debug("tossing lead 8 bytes of image data: %s" % (str(toss)))
    return (mime, data) # if mime still None, we hope Calibre can figure it out.

###############################################################################
