#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2012, Sebastiaan van Schaik <bas@tuxes.nl>'
__docformat__ = 'restructuredtext en'

# The class that all interface action plugins must inherit from
from calibre.gui2.actions import InterfaceAction
from calibre_plugins.prst1_notes.main import PRST1NotesDialog

class PRST1NotesPlugin(InterfaceAction):
    name = 'Sony PRS-T1 notes plugin'

    action_spec = ('Sony PRS-T1 notes', None,'Run the PRS-T1 notes plugin', 'Ctrl+Shift+F1')

    dont_add_to = frozenset(['context-menu', 'context-menu-device', 'toolbar-child', 'menubar', 'menubar-device', 'context-menu-cover-browser'])
    dont_remove_from = frozenset(['toolbar', 'toolbar-device'])

    def genesis(self):
        icon = get_icons('images/notes.png')
        
        self.qaction.setIcon(icon)
        self.qaction.triggered.connect(self.show_dialog)

    def show_dialog(self):
        # The base plugin object defined in __init__.py
        base_plugin_object = self.interface_action_base_plugin
        # Show the config dialog
        # The config dialog can also be shown from within
        # Preferences->Plugins, which is why the do_user_config
        # method is defined on the base plugin class
        do_user_config = base_plugin_object.do_user_config

        # self.gui is the main calibre GUI. It acts as the gateway to access
        # all the elements of the calibre user interface, it should also be the
        # parent of the dialog
        d = PRST1NotesDialog(self.gui, self.qaction.icon(), do_user_config)
        d.show()

