#!/usr/bin/env python
from __future__ import (unicode_literals, division, absolute_import,print_function)

__license__   = 'GPL v3'
__copyright__ = '2012, Sebastiaan van Schaik <bas@tuxes.nl>'
__docformat__ = 'restructuredtext en'

# The class that all Interface Action plugin wrappers must inherit from
from calibre.customize import InterfaceActionBase

class PRST1NotesPluginWrapper(InterfaceActionBase):
	'''
	This class is a simple wrapper that provides information about the actual
	plugin class. The actual interface plugin class is called PRST1NotesPlugin
	and is defined in the ui.py file, as specified in the actual_plugin field
	below.

	The reason for having two classes is that it allows the command line
	calibre utilities to run without needing to load the GUI libraries.
	'''
	name                = 'Sony PRS-T1 notes plugin'
	description         = 'Manages notes (handwriting) of your Sony PRS-T1 device'
	supported_platforms = ['windows', 'osx', 'linux']
	author              = 'Sebastiaan van Schaik'
	version             = (1, 0, 0)
	minimum_calibre_version = (0, 8, 34)

	#: This field defines the GUI plugin class that contains all the code
	#: that actually does something. Its format is module_path:class_name
	#: The specified class must be defined in the specified module.
	actual_plugin       = 'calibre_plugins.prst1_notes.ui:PRST1NotesPlugin'
# end class
