#!/usr/bin/env python

from PyQt4.Qt import QDialog, QTableWidget, QTableWidgetItem, QAbstractItemView, QVBoxLayout, QLabel, QCheckBox, QFrame, QHBoxLayout, QProgressBar, QFileDialog, QWidget, QMessageBox, QLayout
from PyQt4 import QtCore
import sys
import os
import subprocess
from calibre_plugins.prst1_notes.PRST1NotesMerger import *
from calibre import prints
from calibre.startup import local_open

class PRST1NotesMergeInterface (QDialog):
	def __init__(self, gui, mainPluginInterface, icon, book):
		QDialog.__init__(self, gui)
		self.setModal(True)
		self.gui = gui
		self.mainPluginInterface = mainPluginInterface
		self.book = book
		self.icon = icon

		self.merger = PRST1NotesMerger(self.mainPluginInterface,self,self.book)
		self.initialiseInterface()
		self.resize(self.sizeHint())
		
	# end def __init__

	def initialiseInterface(self):
		self.l = QHBoxLayout()
		self.setLayout(self.l)
		self.l.setSizeConstraint(QLayout.SetFixedSize)

		self.setWindowTitle('Sony PRS-T1: merge notes')
		self.setWindowIcon(self.icon)

		# Widgets on the left hand side
		leftFrame = QFrame(self)
		leftFrameLayout = QVBoxLayout()
		leftFrame.setLayout(leftFrameLayout)
		self.l.addWidget(leftFrame)

		## Preview stuff on right hand side
		## TODO: find a way to display a PDF on a QWidget
		#rightFrame = QFrame(self)
		#rightFrameLayout = QVBoxLayout()
		#rightFrame.setLayout(rightFrameLayout)
		#self.l.addWidget(rightFrame)

		## Preview frame
		#previewFrame = QGroupBox("Merge preview")
		#previewFrameLayout = QVBoxLayout()
		#previewFrame.setLayout(previewFrameLayout)
		#rightFrameLayout.addWidget(previewFrame)

		#self.previewCanvas = QWidget(self)
		#self.previewCanvas.resize(300,500)
		#previewFrameLayout.addWidget(self.previewCanvas)

		## Previous and next page buttons
		#self.nextPageButton = QPushButton(">", self)
		#self.prevPageButton = QPushButton("<", self)
		#pageButtonsFrame = QFrame(self)
		#pageButtonsFrameLayout = QHBoxLayout()
		#pageButtonsFrame.setContentsMargins(0,0,0,0)
		#pageButtonsFrame.setLayout(pageButtonsFrameLayout)
		#pageButtonsFrameLayout.addWidget(self.prevPageButton)
		#pageButtonsFrameLayout.addWidget(self.nextPageButton)
		#previewFrameLayout.addWidget(pageButtonsFrame)

		# Information and settings
		infoSettingsFrame = QGroupBox("Information and merge settings")
		infoSettingsFrameLayout = QVBoxLayout()
		infoSettingsFrame.setLayout(infoSettingsFrameLayout)
		leftFrameLayout.addWidget(infoSettingsFrame)

		# Info
		infoBox = QFrame(self)
		infoBoxLayout = QVBoxLayout()
		infoBox.setLayout(infoBoxLayout)
		infoSettingsFrameLayout.addWidget(infoBox)

		numpages = self.merger.getBookNumPages()
		infoBoxLayout.addWidget(QLabel('<b>Title</b>: ' + str(self.book['title'])))
		infoBoxLayout.addWidget(QLabel('<b>Author</b>: ' + str(self.book['author'])))
		infoBoxLayout.addWidget(QLabel('<b>Path</b>: ' + str(self.book['file_path'])))
		infoBoxLayout.addWidget(QLabel('<b>Total number of pages</b>: ' + str(numpages)))
		infoBoxLayout.addWidget(QLabel('<b>Number of pages with notes</b>: ' + str(self.book['numpageswithnotes'])))

		# Settings
		settingsBox = QFrame(self)
		settingsBoxLayout = QVBoxLayout()
		settingsBox.setLayout(settingsBoxLayout)
		self.chkOnlyNotesPages = QCheckBox('Only include pages with notes in output PDF, exclude pages without annotations')
		settingsBoxLayout.addWidget(self.chkOnlyNotesPages)
		infoSettingsFrameLayout.addWidget(settingsBox)

		# Progress bar and buttons
		processControlFrame = QGroupBox("Merge process")
		processControlFrameLayout = QVBoxLayout()
		processControlFrame.setLayout(processControlFrameLayout)
		leftFrameLayout.addWidget(processControlFrame)

		# Progress bar
		self.progressbar = QProgressBar(self)
		self.progressbar.setRange(0, numpages + 10)
		processControlFrameLayout.addWidget(self.progressbar)

		# Buttons and progress bar
		buttonFrame = QFrame()
		buttonFrameLayout = QHBoxLayout()
		buttonFrame.setContentsMargins(0,0,0,0)
		buttonFrameLayout.setContentsMargins(0,0,0,0)
		buttonFrame.setLayout(buttonFrameLayout)

		self.createpdf_button = QPushButton('Create PDF: merge book and handwriting', self)
		self.createpdf_button.clicked.connect(self.doMerge)
		buttonFrameLayout.addWidget(self.createpdf_button)

		self.close_button = QPushButton('Cancel', self)
		self.close_button.clicked.connect(self.close)
		buttonFrameLayout.addWidget(self.close_button)

		processControlFrameLayout.addWidget(buttonFrame)
	# end def initialiseInterface

	def doMerge(self):
		# Ask user for output filename
		outputPdf = QFileDialog.getSaveFileName(self, "Save output PDF", "", "PDF documents (*.pdf)")
		QCoreApplication.processEvents()
		if not outputPdf.isEmpty():
			self.createpdf_button.setEnabled(False)
			self.close_button.setEnabled(False)
			prints("Starting merge")
			QCoreApplication.processEvents()
			self.merger.doMerge(outputPdf, self.chkOnlyNotesPages.isChecked())
			self.close_button.setText("Done!")
			self.close_button.setEnabled(True)

			if os.path.isfile(outputPdf):
				# Success!
				res = QMessageBox.information(self, "Merge succesful!", "Merging was completed successfully. The resulting PDF file can be found at the following location: " + outputPdf, QMessageBox.Ok)
			else:
				# Something went wrong...
				QMessageBox.critical(self, "Merge failed", "Failed to merge handwriting with original book, please check Calibre debug messages for more details.", QMessageBox.Ok)
			# end if
			self.close()
		# else: user cancelled
	# end def
# end class
