#!/usr/bin/env python
__license__   = 'GPL v3'
__copyright__ = '2012, Sebastiaan van Schaik <bas@tuxes.nl>'
__docformat__ = 'restructuredtext en'

from PyQt4.Qt import QTableWidget, QTableWidgetItem, QAbstractItemView, QVBoxLayout
from PyQt4 import QtCore


class PRST1NotesBooksTable (QTableWidget):
	def __init__(self, parent, books):
		QTableWidget.__init__(self, parent);
		self.setSelectionBehavior(QAbstractItemView.SelectRows)
		self.books = books
		self.updateItems()
	# end def __init__


	def updateItems(self):
		column_labels = ['Book ID', 'Title', 'Author', 'Number of pages with notes']
		self.setColumnCount(4)
		self.setSortingEnabled(False)
		self.setRowCount(len(self.books))
		self.setHorizontalHeaderLabels(column_labels)
		self.setAlternatingRowColors(True)
		self.verticalHeader().setVisible(False)
		row = 0

		for book in self.books:
			item_id = QTableWidgetItem(str(book['id']))
			item_id.setFlags(item_id.flags() & ~QtCore.Qt.ItemIsEditable)
			item_title = QTableWidgetItem(str(book['title']))
			item_title.setFlags(item_title.flags() & ~QtCore.Qt.ItemIsEditable)
			item_author = QTableWidgetItem(str(book['author']))
			item_author.setFlags(item_author.flags() & ~QtCore.Qt.ItemIsEditable)
			item_filepath = QTableWidgetItem(str(book['file_path']))
			item_filepath.setFlags(item_filepath.flags() & ~QtCore.Qt.ItemIsEditable)
			item_numpageswithnotes = QTableWidgetItem(str(book['numpageswithnotes']))
			item_numpageswithnotes.setFlags(item_numpageswithnotes.flags() & ~QtCore.Qt.ItemIsEditable)
			self.setItem(row,0,item_id)
			self.setItem(row,1,item_title)
			self.setItem(row,2,item_author)
			self.setItem(row,3,item_numpageswithnotes)
			#self.setItem(row,3,item_filepath)
			row += 1
		# end for

		self.resizeColumnsToContents()
	# end def
# end class	
