#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#define SW 600
#define SH 800
#define LL 300
#define T 7
#define LOAD_IMAGE "eips -g"

int main(int argc, char *argv[]) {
  FILE *fb;
  int x,y,c;
  int x0=0,y0=0,w=0,h=0;
  unsigned char f,r;
  if (argc!=2) {
    fprintf(stderr,"Usage: gameoflife png\n");
    exit(1);
  }
  // Load image
  char cmd[strlen(LOAD_IMAGE)+strlen(argv[1])+4];
  sprintf(cmd,"%s \"%s\"",LOAD_IMAGE,argv[1]);
  system(cmd);
  // Get field position
  if ((fb=fopen("/dev/fb0","r+"))==NULL) exit(1);
  f=getc(fb)>>4; fseek(fb,0,SEEK_SET);
  for (x=0;x<SW;x+=2) {
    r=getc(fb);
    if ((r>>4)!=f) { if (x0==0) x0=x; }
    else { if (x0!=0&&w==0) w=x-x0; }
    if ((r&0x0f)!=f) { if (x0==0) x0=x+1; }
    else { if (x0!=0&&w==0) w=x+1-x0; }
  }
  for (y=1;y<SH;y++) {
    fseek(fb,y*LL,SEEK_SET);
    r=getc(fb);
    if (f!=(r&0x0f)) { if (y0==0) y0=y; }
    else { if (y0!=0&&h==0) h=y-y0; }
  }
  // Read framebuffer content
  unsigned char l[w][h];
  unsigned char n[w][h];
  for (y=0;y<h;y++) {
    fseek(fb,(y+y0)*LL+x0/2,SEEK_SET); x=0;
    if (x0%2==1) { l[x][y]=(getc(fb)&0x0f)>T; x++; }
    for (;x<w;x+=2) {
      r=getc(fb); l[x][y]=(r>>4)>T; l[x+1][y]=(r&0x0f)>T;
    }
    if (x0+w%2==1) { l[w-1][y]=(getc(fb)>>4)>T; }
  }
  while (1) {
    // Update field
    for (y=0;y<h;y++) {
      for (x=0;x<w;x++) {
        c=l[(x+w-1)%w][(y+h-1)%h]+l[x][(y+h-1)%h]\
         +l[(x+1)%w][(y+h-1)%h]+l[(x+w-1)%w][y]+l[(x+1)%w][y]\
         +l[(x+w-1)%w][(y+1)%h]+l[x][(y+1)%h]+l[(x+1)%w][(y+1)%h];
        n[x][y]=l[x][y];
        if (l[x][y]==0&&c==3) n[x][y]=1;
        else if (l[x][y]==1&&(c<2||c>3)) n[x][y]=0;
      }
    }
    // Copy last, update framebuffer
    for (y=0;y<h;y++) {
      fseek(fb,(y+y0)*LL+x0/2,SEEK_SET); x=0;
      if (x0%2==1) {
        l[x][y]=n[x][y];
        r=getc(fb); fseek(fb,(y+y0)*LL+x0/2,SEEK_SET);
        putc((r&0xf0)|(n[x][y]==1?'\x0f':'\x00'),fb); x++;
      }
      for (;x<w;x+=2) {
        l[x][y]=n[x][y]; l[x+1][y]=n[x+1][y];
        if (n[x][y]==1) {
          if (n[x+1][y]==1) putc('\xff',fb);
          else putc('\xf0',fb);
        } else {
          if (n[x+1][y]==1) putc('\x0f',fb);
          else putc('\x00',fb);
        }
      }
      if (x0+w%2==1) {
        l[w-1][y]=n[w-1][y];
        r=getc(fb); fseek(fb,(y+y0)*LL+(w-1+x0)/2,SEEK_SET);
        putc((r&0x0f)|(n[w-1][y]==1?'\xf0':'\x00'),fb);
      }
    }
    system("eips ''");
  }
  fclose(fb);
  exit(0);
}
