#!/bin/sh

THISDIR=/media/mmcblk0p1/Programs/_python26/install

cd $THISDIR

backup_firmware () {
    # Save originals ONLY if they do not exists
    if [ ! -e $THISDIR/liberutils_original ]
    then
        /bin/cp -f /usr/lib/liberutils.so.0.0.1 $THISDIR/liberutils_original
    fi
}

install_patched_files () {
    # overwrite existing files
    /bin/cp -f $THISDIR/liberutils.so.0.0.1 /usr/lib/
}

restore_original_files () {
    # Restore the original program(s)
    if [ -e $THISDIR/liberutils_original ]
    then
        /bin/cp $THISDIR/liberutils_original /usr/lib/liberutils.so.0.0.1
        /bin/rm -f $THISDIR/liberutils_original
    fi
	
	# TODO: remove schema for csv
}

install_schema_files () {
	# Adapt gconf to bind csv files with calc using the calc.schemas file
	export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
	/bin/cp -f ./calc.schemas /etc/gconf/schemas/calc.schemas
	gconftool-2 --makefile-install-rule /etc/gconf/schemas/calc.schemas

	# If the schema was already installed make sure it gets the correct value
	gconftool-2 --type list --list-type=string --set /apps/er/sys/ctb/filetypes/doc-csv/extensions "[csv]"
	gconftool-2 --type string --set /apps/er/sys/ctb/filetypes/doc-csv/icon_name "calc"
	gconftool-2 --type string --set /apps/er/sys/ctb/filetypes/doc-csv/viewer_cmd "/media/mmcblk0p1/Programs/_python26/bin/python /media/mmcblk0p1/Programs/_python26/apps/calc/python"

	# Create Backup of dr.ini
	/bin/cp -f /media/mmcblk0p1/System/dr.ini /media/mmcblk0p1/System/dr.csv.ini
	# and save the settings to disk
	/usr/bin/erconftool -e /apps/er

	# Copy the csv-filetype icons, they need to be in the usr/share/ctb directory
	/bin/cp -f ./icon-calc-medium.png /usr/share/ctb/icon-calc-medium.png
	/bin/cp -f ./icon-calc-mini.png /usr/share/ctb/icon-calc-mini.png
	/bin/cp -f ./icon-calc-small.png /usr/share/ctb/icon-calc-small.png
	/bin/chmod a-x /usr/share/ctb/icon-calc-*
}

# first backup original programs, only if they don't exist
if [ ! -f $THISDIR/liberutils_original ]; then
	echo "Backing-up original firmware files"
	backup_firmware
fi
# install schema to bind csv with calc
install_schema_files

# install patches files
# Do this as last call since overwriting a used library makes the OS instable ...
install_patched_files

# For the new version to be used, a reset is needed
# Do not show a dialog, the new libraries will crash the DR when they are used ...
/sbin/reboot
sleep 31
    