﻿$vncpassword=""
$sshuser="root"
$sshpassword=""
$hostname="192.168.2.2"

#Script path
$spath=Split-Path -parent $MyInvocation.MyCommand.Definition

#Start winvnc if not already running
if (-not($ultravnc=Get-Process winvnc -ea 0))
{
    Start-Process($spath+"\UltraVNC\winvnc.exe")
    $ultravnc=Get-Process winvnc
}

#dot source ssh_function
. ($spath+"\ssh_function.ps1")

#Create ssh session
New-SshSession -UserName $sshuser -Password $sshpassword -HostName $hostname
#Wake up the kindle
Send-Ssh("lipc-set-prop com.lab126.powerd wakeUp 1")
#Run vncviewer
Send-Ssh("/mnt/us/kindlevncviewer/kvncviewer.sh -password $vncpassword 192.168.2.1:1 &")
#Prevent sleep using kaffeine
Send-Ssh("/mnt/us/system/kaffeine")

#Wait for Enter key
Read-Host -Prompt 'Press Enter to close VNC' | Out-Null
#Kill vncviewer
Send-Ssh("killall kindlevncviewer")
#Exit kaffeine
Send-Ssh("/mnt/us/system/kaffeine 3")
#Kill winvnc
Stop-Process($ultravnc)

#Close ssh session
Remove-SshSession