package com.javese.android.lcd2einkapp;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.SystemClock;
import android.preference.PreferenceManager;
import android.provider.MediaStore.Images.Media;
import android.util.Log;
import android.view.Gravity;
import android.widget.LinearLayout;
import android.widget.Toast;
import android.net.Uri;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;

import org.vldmr.edgefb.EdgeFB;



public class LCD2EinkService extends Service {
	public static final int CAPTURE = 0;
	public static final int CHECKFB = 1;
	public static final int CAPTURE_WITH_SYSTEM_DELAY = 2;
	public static final int CAPTURE_WITH_USER_DELAY = 3;
	public static final int CAPTURE_WITH_OPTION = 4;
	public static final int INITIALIZE = 5;
    SharedPreferences prefs;
    private IBinder serviceBinder;
    // Handles the connection between the service and activity
    private ServiceConnection mConnection = new ServiceConnection() {
		 public void onServiceConnected(ComponentName className, IBinder service) {
		 // Called when the connection is made.
			 serviceBinder = service;
			 Log.i("lcd2einkservice","onServiceConnected:"+className);
		 }
		 public void onServiceDisconnected(ComponentName className) {
		 // Received when the service unexpectedly disconnects.
			 serviceBinder = null;
		 }
	};


	String appRoot = null;
	/*
	static
	{
	  try
	  {
	    System.loadLibrary("exescreen2pdf");
	  }
	  catch (Throwable localThrowable)
	  {
	    Log.e("lcd2einkservice", "failed loading native library", localThrowable);
	  }
	}
	*/

	
	@Override
	public IBinder onBind(Intent arg0) {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public void onCreate() {
	// TODO: Actions to perform when service is created.
		Log.i("lcd2einkservice", "OnCreate");
		appRoot = getApplicationContext().getFilesDir().getParent();
		prefs = PreferenceManager.getDefaultSharedPreferences(this);
	    Intent localIntent = new Intent("com.entouragesys.android.common.idl.IReaderService");
	    boolean bool = bindService(localIntent, mConnection, Context.BIND_AUTO_CREATE);
	      if(serviceBinder == null)
	      {
	    	  Log.i("lcd2einkservice", "serviceBinder is null.");
	      }

	}

	@Override
	public void onStart(Intent intent,int startId) {
	// TODO: Actions to perform when service is created.
		Log.i("lcd2einkservice", "OnStart");
		Log.i("lcd2einkservice,appRoot = ", appRoot);
        
		Process process = null;
		int toUpdate = 0;
		int mode = intent.getIntExtra("Mode", CAPTURE);
		String commandStr = "su -c "+appRoot;//
		Log.i("lcd2einkservice", "Mode = "+mode);
		
		switch(mode)
		{
			case INITIALIZE:
				return;
			case CHECKFB:
				commandStr = commandStr +"/lib/libexecheckfb.so";
				break;
			case CAPTURE_WITH_SYSTEM_DELAY:
				{
					SystemClock.sleep(300);
					Log.i("lcd2einkservice","sleep for 300 ms.");
				}
				commandStr = commandStr +"/lib/libexescreen2pdf.so";
				break;
			case CAPTURE_WITH_USER_DELAY:
			{
				int userDelay = prefs.getInt(LCD2EinkActivity.PREF_USER_DELAY, 100);
				SystemClock.sleep(userDelay);
				Log.i("lcd2einkservice","sleep for user defined delay: "+userDelay+" ms");
			}
			commandStr = commandStr +"/lib/libexescreen2pdf.so";
			break;
			case CAPTURE_WITH_OPTION:
			{
				boolean penupCaptureChecked = prefs.getBoolean(LCD2EinkActivity.PREF_PENUP_CAPTURE, false);
				if(penupCaptureChecked == false)
				{
					return;
				}
				SystemClock.sleep(300);
				Log.i("lcd2einkservice","sleep for user defined delay");
			}
			commandStr = commandStr +"/lib/libexescreen2pdf.so";
			break;
			case CAPTURE:
			default:
				commandStr = commandStr +"/lib/libexescreen2pdf.so";
				break;
		}

		DummyToast();

		try{

//		process = Runtime.getRuntime().exec("su -c "+"\""+appRoot+"/lib/libexescreen2pdf.so "+appRoot+"/files/screen.pdf"+"\"");
	
		process = Runtime.getRuntime().exec(commandStr);
	//	process = Runtime.getRuntime().exec("su -c "+appRoot+"/lib/libexescreen2pdf.so");



		toUpdate = process.waitFor();

		}catch(Exception e){

		   e.printStackTrace();

		}finally {

		   process.destroy();

		}		

		if(toUpdate == 1)
			DisplayOnEPaper();
	}
	@Override
	public void onDestroy() {
	// TODO: Actions to perform when service is created.
		Log.i("lcd2einkservice", "onDestroy");
	}
	private void DummyToast() {
		Context context = getApplicationContext();
		int duration = Toast.LENGTH_LONG;
		Toast dummyToast = Toast.makeText(context, "", duration);
		dummyToast.setGravity(Gravity.TOP, 0, 0);
		LinearLayout ll = new LinearLayout(context);
		ll.setOrientation(LinearLayout.VERTICAL);
		DummyToastView dv = new DummyToastView(context);
		int lHeight = LinearLayout.LayoutParams.FILL_PARENT;
		int lWidth = LinearLayout.LayoutParams.WRAP_CONTENT;
		ll.addView(dv, new LinearLayout.LayoutParams(lHeight, lWidth));
		dummyToast.setView(ll);
		dummyToast.show();
	}
	private void DisplayOnEPaper(){
		Log.i("lcd2einkservice", "DisplayOnEPaper");
		boolean fbModeChecked = prefs.getBoolean(LCD2EinkActivity.PREF_FB_MODE, false);
		if(fbModeChecked)
		{

	       try {
	            EdgeFB fb=new EdgeFB(2);
	  		  String str1 = "/sdcard/public/screen.bmp";
		      File localFile = new File(str1);
		      if(!localFile.exists())
		      {
		    	  str1 = "/intsdcard/public/screen.bmp";
		    	  localFile = new File(str1);
		    	  if(!localFile.exists())
		    		  return; 	  
		      }

	            Bitmap bmf=Media.getBitmap(getContentResolver(), Uri.fromFile (localFile));

	            if(bmf!=null) {
	                Bitmap bm=fb.createBitmap();
	                Canvas c = new Canvas(bm);
	                Paint paint = new Paint();
	                ColorMatrix cm = new ColorMatrix();
	                cm.setSaturation(0);
	                ColorMatrixColorFilter f = new ColorMatrixColorFilter(cm);
	                paint.setColorFilter(f);

	                int width, height;
	                float aspectRatioSrc=(float)bmf.getWidth()/(float)bmf.getHeight(); // 4/3=1.3
	                float aspectRatioDst=(float)fb.getWidth()/(float)fb.getHeight(); // 15/9=1.6

	                if(aspectRatioSrc<aspectRatioDst) {
	                    height=fb.getHeight();
	                    width=(int)((float)height*aspectRatioSrc);
	                } else {
	                    width=fb.getWidth();
	                    height=(int)((float)width/aspectRatioSrc);
	                }

	                boolean fullScreenChecked = prefs.getBoolean(LCD2EinkActivity.PREF_FULL_SCREEN, false);
	                if(fullScreenChecked)
		            	bmf = Bitmap.createScaledBitmap(bmf, fb.getWidth(), fb.getHeight(), true);
	                else
	                	bmf = Bitmap.createScaledBitmap(bmf, width, height, true);

	                int left=(fb.getWidth()-width)/2;
	                int top=(fb.getHeight()-height)/2;
	                
	                if(fullScreenChecked)
	                {
		                c.drawBitmap(bmf, (Rect)null, new Rect(0, 0, fb.getWidth(), fb.getHeight()), paint);
	                }
	                else
	                {
	                	c.drawColor(Color.WHITE);
	                	c.drawBitmap(bmf, (Rect)null, new Rect(left, top, left+width, top+height), paint);
	                }
	                bmf.recycle();
	                fb.transfer(bm, true);
	            }
	        } catch (IOException e) {
	            e.printStackTrace();
	        }		
		}
		else
		{
		
		  String str1 = "/sdcard/public/screen.pdf";
	      File localFile = new File(str1);
	      if(!localFile.exists())
	      {
	    	  str1 = "/intsdcard/public/screen.pdf";
	    	  localFile = new File(str1);
	    	  if(!localFile.exists())
	    		  return; 	  
	      }
	      if(serviceBinder == null)
	      {
	    	  Log.i("lcd2einkservice", "serviceBinder is null.");
	    	  return;
	      }
	      
	        Parcel localParcel1 = Parcel.obtain();
	        Parcel localParcel2 = Parcel.obtain();
	        try
	        {
	          localParcel1.writeInterfaceToken("com.entouragesys.android.common.idl.IReaderService");
	          localParcel1.writeString(str1);
	          localParcel1.writeString(null);
	          try {
				boolean bool = serviceBinder.transact(1, localParcel1, localParcel2, 0);
		        localParcel2.readException();
		        int i = localParcel2.readInt();

			} catch (RemoteException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
	        }
	        finally
	        {
	          localParcel2.recycle();
	          localParcel1.recycle();
	        }
		}
/*
	     

		
	    try
	    {
		  String str1 = "/sdcard/public/screen.pdf";
	      File localFile = new File(str1);
	      if(!localFile.exists())
	      {
	    	  str1 = "/intsdcard/public/screen.pdf";
	    	  localFile = new File(str1);
	    	  if(!localFile.exists())
	    		  return; 	  
	      }
	      String str3 = getString(R.string.screen_dump);
	      Intent localIntent1 = new Intent("android.intent.action.VIEW");
	      Uri localUri = Uri.parse(str1);
	      localIntent1.setDataAndType(localUri, "vnd.entourage.book/book");
	      localIntent1.putExtra("entouragesys.intent.extra.READ_ONLY", 0);
	      localIntent1.putExtra("entouragesys.intent.extra.SOURCE", 0);
	      localIntent1.putExtra("entouragesys.intent.extra.BOOK_TITLE", str3);
	      
	      sendBroadcast(localIntent1);
	      String str2 = "Web page file " + str1 + " being displayed on the E-Reader side.";
	      Log.i("WebPage2Epaper", str2);
	      return;
	    }
	    catch (Exception localException)
	    {
	      Log.e("WebPage2Epaper", "Got exception", localException);
	    }
	    */
	    /*
	      InetAddress localInetAddress;
		try {
			localInetAddress = InetAddress.getLocalHost();
		      byte[] arrayOfByte1 = {(byte)0x08,(byte)0xd1,(byte)0xbc,(byte)0x94,(byte)0x07,(byte)0x10,(byte)0x04,(byte)0x18,(byte)0x1e,(byte)0x3a,(byte)0x1b,(byte)0x0a,(byte)0x19,(byte)0x2f,(byte)0x73,(byte)0x64,(byte)0x63,(byte)0x61,(byte)0x72,(byte)0x64,(byte)0x2f,(byte)0x70,(byte)0x75,(byte)0x62,(byte)0x6c,(byte)0x69,(byte)0x63,(byte)0x2f,(byte)0x73,(byte)0x63,(byte)0x72,(byte)0x65,(byte)0x65,(byte)0x6e,(byte)0x2e,(byte)0x70,(byte)0x64,(byte)0x66};
		      DatagramPacket localDatagramPacket = new DatagramPacket(arrayOfByte1, arrayOfByte1.length, localInetAddress, 32007);
		      DatagramSocket localDatagramSocket = new DatagramSocket();

		      localDatagramSocket.send(localDatagramPacket);
		      localDatagramSocket.close();
		} catch (Exception localException) {
			// TODO Auto-generated catch block
			localException.printStackTrace();
		}
		*/
	    
	}
	
/*	private void captureScreen() {
		// TODO: Actions to perform when service is created.
			Log.i("lcd2einkservice", "captureScreen");
		    Bitmap bmp = Bitmap.createBitmap(320, 480, Config.ARGB_8888);
		    View cv = getWindow().getDecorView();
		    cv.draw(new Canvas(bmp));

		    FileOutputStream fos = null;
		    try {
		     fos = new FileOutputStream("/sdcard/screen.jpg");

		     if (fos != null) {
		      bmp.compress(Bitmap.CompressFormat.JPEG, 90, fos);

		      fos.close();
		     }
		    } catch (Exception e) {
		     e.printStackTrace();
		    }
		}
*/

}
