package com.javese.android.lcd2einkapp;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Timer;
import java.util.TimerTask;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.SystemClock;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TextView.OnEditorActionListener;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.widget.TextView;
import android.widget.EditText;
import android.view.KeyEvent;
import android.view.inputmethod.EditorInfo;


public class LCD2EinkActivity extends Activity {
    private Button captureButton = null;
    private Button RemoveNotificationButton = null; 
    private Button calibrateButton = null; 
    private Button rotateReaderButton = null; 

    private CheckBox autoModeCheckbox = null;
    private CheckBox readerKeyListenerCheckbox = null;
    private CheckBox readerPageKeyListenerCheckbox = null;
    private CheckBox readerPenListenerCheckbox = null;
    private CheckBox penupCaptureCheckbox = null;
    private CheckBox fbModeCheckbox = null;
    private CheckBox fullScreenCheckbox = null;
    private EditText autofreshIntervalEdit = null; 
    private EditText userDelayEdit = null; 
    public static final String PREF_AUTO_MODE = "PREF_AUTO_MODE";
    public static final String PREF_MONITOR_READER_KEY = "PREF_MONITOR_READER_KEY";
    public static final String PREF_MONITOR_READER_PAGE_KEY = "PREF_MONITOR_READER_PAGE_KEY";
    public static final String PREF_MONITOR_READER_PEN = "PREF_MONITOR_READER_PEN";
    public static final String PREF_AUTOFRESH_INTERVAL = "PREF_AUTOFRESH_INTERVAL";
    public static final String PREF_USER_DELAY = "PREF_USER_DELAY";
    public static final String PREF_EVKLISTENER_RUNNING = "PREF_EVKLISTENER_RUNNING";
    public static final String PREF_WACOMLISTENER_RUNNING = "PREF_WACOMLISTENER_RUNNING";
    public static final String PREF_PENUP_CAPTURE = "PREF_PENUP_CAPTURE";
    public static final String PREF_FB_MODE = "PREF_FB_MODE";
    public static final String PREF_FULL_SCREEN = "PREF_FULL_SCREEN";
    
    private Process readerKeyListener = null;
	String appRoot = null;
	String readerKeyListenerCommand = null;
	String readerPenListenerCommand = null;
  
    private IBinder serviceBinder;
    // Handles the connection between the service and activity
    private ServiceConnection mConnection = new ServiceConnection() {
		 public void onServiceConnected(ComponentName className, IBinder service) {
		 // Called when the connection is made.
			 serviceBinder = service;
			 Log.i("LCD2EinkActivity","onServiceConnected:"+className);
		 }
		 public void onServiceDisconnected(ComponentName className) {
		 // Received when the service unexpectedly disconnects.
			 serviceBinder = null;
		 }
	};
    
    SharedPreferences prefs;

    NotificationManager localNotificationManager = null;
    int notificationRef = 1;

    Timer timer = null; 
    TimerTask task = null;
    Handler handler = new Handler(){  
    	public void handleMessage(Message msg) {  
    		switch (msg.what) {      
    			case 1:      
                    Intent i = new Intent(LCD2EinkActivity.this, LCD2EinkService.class);
                    i.putExtra("Mode", LCD2EinkService.CHECKFB);

                    LCD2EinkActivity.this.startService(i);
                    prefs = PreferenceManager.getDefaultSharedPreferences(LCD2EinkActivity.this);
                    boolean autoModeChecked = prefs.getBoolean(PREF_AUTO_MODE, false);
                    int autofreshInterval = prefs.getInt(PREF_AUTOFRESH_INTERVAL, 5);
                    if(autoModeChecked)
                    {
                    	timer = new Timer();  
                    	task = new TimerTask(){  
                            public void run() {  
                           	 Message message = new Message();      
                           	 message.what = 1;      
                           	 handler.sendMessage(message);    
                            }
                    	};  
                        timer.schedule(task, autofreshInterval*1000);  
                    }
                    
                  break;      
           }      
           super.handleMessage(msg);  
         }  
    };  


	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);

        prefs = PreferenceManager.getDefaultSharedPreferences(this);

        appRoot = getApplicationContext().getFilesDir().getParent();
        readerKeyListenerCommand = "su -c "+appRoot +"/lib/libexeevklistener.so";
        readerPenListenerCommand = "su -c "+appRoot +"/lib/libexewacomlistener.so";
        
        captureButton =  (Button)findViewById(R.id.button_capture);
        RemoveNotificationButton =  (Button)findViewById(R.id.button_remove_notification); 
        rotateReaderButton =  (Button)findViewById(R.id.button_rotate_reader); 
        captureButton.setOnClickListener(new Button.OnClickListener(){   
        	public void onClick(View v)  
        	{  
        		Capture();  
        	}  
        });         
        RemoveNotificationButton.setOnClickListener(new Button.OnClickListener(){   
        	public void onClick(View v)  
        	{  
        		RemoveNotification();  
        	}  
        });        
        rotateReaderButton.setOnClickListener(new Button.OnClickListener(){   
        	public void onClick(View v)  
        	{  
        		RotateReader();  
        	}  
        });         
        calibrateButton =  (Button)findViewById(R.id.button_calibrate);
        calibrateButton.setOnClickListener(new Button.OnClickListener(){   
        	public void onClick(View v)  
        	{  
        		Calibrate();  
        	}  
        });         

        autoModeCheckbox = (CheckBox)findViewById(R.id.checkBox_automode);
        autoModeCheckbox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){
        	  public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        		     // TODO Auto-generated method stub
        		  Editor editor = prefs.edit();
        		  editor.putBoolean(PREF_AUTO_MODE, isChecked);
        		  editor.commit();
        		     if(isChecked)
        		     {
        		    	 timer = new Timer();  
        		    	 task = new TimerTask(){  
        		             public void run() {  
        		            	 Message message = new Message();      
        		            	 message.what = 1;      
        		            	 handler.sendMessage(message);    
        		             }
        		    	 };  
        		         int autofreshInterval = prefs.getInt(PREF_AUTOFRESH_INTERVAL, 5);
        		    	 
        		    	 timer.schedule(task, autofreshInterval*1000); 
        		     }

        		    }	
        });
        
        autofreshIntervalEdit = (EditText)findViewById(R.id.editText_autofresh_interval);
        autofreshIntervalEdit.setOnEditorActionListener(new TextView.OnEditorActionListener() {
              public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
            	  Log.i("lcd2einkactivity,onEditorAction", "actionId = "+actionId);
            	  if(actionId == EditorInfo.IME_ACTION_DONE || actionId == EditorInfo.IME_ACTION_UNSPECIFIED ) {
            		  Editor editor = prefs.edit();
            		  editor.putInt(PREF_AUTOFRESH_INTERVAL, Integer.parseInt(v.getText().toString()));
            		  editor.commit();
            	  }
            	  return false;
              }
        });
        int autofreshInterval = prefs.getInt(PREF_AUTOFRESH_INTERVAL, 5);
        autofreshIntervalEdit.setText(""+autofreshInterval);

        userDelayEdit = (EditText)findViewById(R.id.editText_user_delay);
        userDelayEdit.setOnEditorActionListener(new TextView.OnEditorActionListener() {
              public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
            	  Log.i("lcd2einkactivity,onEditorAction", "actionId = "+actionId);
            	  if(actionId == EditorInfo.IME_ACTION_DONE || actionId == EditorInfo.IME_ACTION_UNSPECIFIED ) {
            		  Editor editor = prefs.edit();
            		  editor.putInt(PREF_USER_DELAY, Integer.parseInt(v.getText().toString()));
            		  editor.commit();
            		  
            	  }
            	  return false;
              }
        });        
        int userDelay = prefs.getInt(PREF_USER_DELAY, 100);
        userDelayEdit.setText(""+userDelay);

        
        readerKeyListenerCheckbox = (CheckBox)findViewById(R.id.checkBox_monitorreaderkey);
        readerKeyListenerCheckbox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){
        	  public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        		     // TODO Auto-generated method stub
        		  Editor editor = prefs.edit();
        		  editor.putBoolean(PREF_MONITOR_READER_KEY, isChecked);
        		  editor.commit();
 		    	  boolean readerKeyListenerRunning = prefs.getBoolean(PREF_EVKLISTENER_RUNNING, false);
        		     if(isChecked)
        		     {
        		         if(readerKeyListenerRunning)
        		         { 
        		        	 return;
        		         }
        		         
        		    	 Log.i("lcd2einkactivity,onCheckedChanged", readerKeyListenerCommand);
        		    	 try {
        		    		 
							readerKeyListener = Runtime.getRuntime().exec(readerKeyListenerCommand);
   		        		    editor.putBoolean(PREF_EVKLISTENER_RUNNING, true);
			        		editor.commit();
						} catch (IOException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						} 
        		     }else
        		     {
        		         if(readerKeyListenerRunning)
        		         {
        		        	 destroyReaderKeyListenerProcess();
    		        		    editor.putBoolean(PREF_EVKLISTENER_RUNNING, false);
    			        		editor.commit();
        		         	readerKeyListener = null;
        		         }
        		     }
        		     

        	  }	
        });
        
        readerPageKeyListenerCheckbox = (CheckBox)findViewById(R.id.checkBox_monitorreaderpagekey);
        readerPageKeyListenerCheckbox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){
        	  public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        		     // TODO Auto-generated method stub
        		  Editor editor = prefs.edit();
        		  editor.putBoolean(PREF_MONITOR_READER_PAGE_KEY, isChecked);
        		  editor.commit();
        		  String str1 = "/sdcard/public/usepagekeys";
        	      File localFile = new File(str1);
        	      if(isChecked == true)
        	      {
	        	      if(!localFile.exists())
	        	      {
	        	    	  str1 = "/intsdcard/public/usepagekeys";
	        	    	  localFile = new File(str1);
	        	    	  if(!localFile.exists())
	        	    	  {
	        	    		  str1 = "/sdcard/public/usepagekeys";
	        	    		  localFile = new File(str1);        	    		  
	        	    		  try {
								localFile.createNewFile();
							} catch (IOException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
	        	    		  if(!localFile.exists())
	        	    		  {
	                	    	  str1 = "/intsdcard/public/usepagekeys";
	                	    	  localFile = new File(str1);
	                	    	  try {
									localFile.createNewFile();
								} catch (IOException e) {
									// TODO Auto-generated catch block
									e.printStackTrace();
								}
	        	    		  }
	        	    		  return; 	  
	        	    	  }
	        	      }
	        	  }
        	      else
        	      {
	        	      if(localFile.exists())
	        	      {
	        	    	  localFile.delete();
	        	      }
	        	      else
	        	      {
        	    		  str1 = "/intsdcard/public/usepagekeys";
        	    		  localFile = new File(str1);        	    		  
    	        	      if(localFile.exists())
    	        	      {
    	        	    	  localFile.delete();
    	        	      }	        	    	  
	        	      }
        	      }
         	  }	
        });
        
        readerPenListenerCheckbox = (CheckBox)findViewById(R.id.checkBox_monitorreaderpen);
        readerPenListenerCheckbox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){
        	  public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        		     // TODO Auto-generated method stub
        		  Editor editor = prefs.edit();
        		  editor.putBoolean(PREF_MONITOR_READER_PEN, isChecked);
        		  editor.commit();
 		    	  boolean readerPenListenerRunning = prefs.getBoolean(PREF_WACOMLISTENER_RUNNING, false);
        		     if(isChecked)
        		     {
        		         if(readerPenListenerRunning)
        		         { 
        		        	 return;
        		         }
        		         
        		    	 Log.i("lcd2einkactivity,onCheckedChanged", readerPenListenerCommand);
        		    	 try {
        		    		 
							Runtime.getRuntime().exec(readerPenListenerCommand);
   		        		    editor.putBoolean(PREF_WACOMLISTENER_RUNNING, true);
			        		editor.commit();
						} catch (IOException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						} 
        		     }else
        		     {
        		         if(readerPenListenerRunning)
        		         {
        		        	 destroyReaderPenListenerProcess();
    		        		    editor.putBoolean(PREF_WACOMLISTENER_RUNNING, false);
    			        		editor.commit();
        		         	
        		         }
        		     }
        		     

        	  }	
        });
        
        penupCaptureCheckbox = (CheckBox)findViewById(R.id.checkBox_penupcapture);
        penupCaptureCheckbox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){
        	  public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        		     // TODO Auto-generated method stub
        		  Editor editor = prefs.edit();
        		  editor.putBoolean(PREF_PENUP_CAPTURE, isChecked);
        		  editor.commit();
        	  }	
        });        

        fbModeCheckbox = (CheckBox)findViewById(R.id.checkBox_fbmode);
        fbModeCheckbox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){
        	  public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        		     // TODO Auto-generated method stub
        		  Editor editor = prefs.edit();
        		  editor.putBoolean(PREF_FB_MODE, isChecked);
        		  editor.commit();
        	  }	
        });        

        fullScreenCheckbox = (CheckBox)findViewById(R.id.checkBox_fullscreen);
        fullScreenCheckbox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){
        	  public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        		     // TODO Auto-generated method stub
        		  Editor editor = prefs.edit();
        		  editor.putBoolean(PREF_FULL_SCREEN, isChecked);
        		  editor.commit();
        	  }	
        });        
        
        TextView author_version_text  = (TextView)findViewById(R.id.textView_author_version);
        String authorVersionText = getString(R.string.author)+": javese\n"+getString(R.string.version)+": 0.1.12fb\n";
        author_version_text.setText(authorVersionText);
 

        localNotificationManager = (NotificationManager)getSystemService("notification");
        String str1 = getString(R.string.capture_now);
        long l = System.currentTimeMillis();
        Notification localNotification = new Notification(R.drawable.icon, str1, l);
        localNotification.flags = localNotification.flags | Notification.FLAG_ONGOING_EVENT;
        Intent localIntent1 = new Intent(this, LCD2EinkService.class);
        localIntent1.putExtra("Mode", LCD2EinkService.CAPTURE_WITH_SYSTEM_DELAY);
        PendingIntent localPendingIntent = PendingIntent.getService(this, 0, localIntent1, PendingIntent.FLAG_UPDATE_CURRENT);
        
        localNotification.contentIntent = localPendingIntent;
        String strAppName = getString(R.string.app_name);
    
        localNotification.setLatestEventInfo(this, strAppName, str1, localPendingIntent);
        localNotificationManager.notify(notificationRef, localNotification);
        
        autofreshInterval = prefs.getInt(PREF_AUTOFRESH_INTERVAL, 5);
        boolean autoModeChecked = prefs.getBoolean(PREF_AUTO_MODE, false);
        if(autoModeChecked)
        {
        	autoModeCheckbox.setChecked(true);
        	timer = new Timer();  
        	task = new TimerTask(){  
                public void run() {  
               	 Message message = new Message();      
               	 message.what = 1;      
               	 handler.sendMessage(message);    
                }
        	};  
            timer.schedule(task, autofreshInterval*1000);  
        }
        else
        {
        	autoModeCheckbox.setChecked(false);
        }
        

        boolean readerKeyListenerChecked = prefs.getBoolean(PREF_MONITOR_READER_KEY, false);
        if(readerKeyListenerChecked)
        {
        	readerKeyListenerCheckbox.setChecked(true);
/*	    	 Log.i("lcd2einkactivity,onCreate", readerKeyListenerCommand);
	    	 try {
				readerKeyListener = Runtime.getRuntime().exec(readerKeyListenerCommand);
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} 
			*/
        }
        else
        {
        	readerKeyListenerCheckbox.setChecked(false);
        }
        
        boolean readerPageKeyListenerChecked = prefs.getBoolean(PREF_MONITOR_READER_PAGE_KEY, false);
        if(readerPageKeyListenerChecked)
        {
        	readerPageKeyListenerCheckbox.setChecked(true);
        }
        else
        {
        	readerPageKeyListenerCheckbox.setChecked(false);
        }        
        boolean readerPenListenerChecked = prefs.getBoolean(PREF_MONITOR_READER_PEN, false);
        if(readerPenListenerChecked)
        {
        	SystemClock.sleep(500);
        	readerPenListenerCheckbox.setChecked(true);
/*	    	 Log.i("lcd2einkactivity,onCreate", readerKeyListenerCommand);
	    	 try {
				readerKeyListener = Runtime.getRuntime().exec(readerKeyListenerCommand);
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} 
			*/
        }
        else
        {
        	readerPenListenerCheckbox.setChecked(false);
        }
        
        boolean penupCaptureChecked = prefs.getBoolean(PREF_PENUP_CAPTURE, false);
        if(penupCaptureChecked)
        {
        	penupCaptureCheckbox.setChecked(true);
        }
        else
        {
        	penupCaptureCheckbox.setChecked(false);
        }

        boolean fbModeChecked = prefs.getBoolean(PREF_FB_MODE, false);
        if(fbModeChecked)
        {
        	fbModeCheckbox.setChecked(true);
        }
        else
        {
        	fbModeCheckbox.setChecked(false);
        }
        
        boolean fullScreenChecked = prefs.getBoolean(PREF_FULL_SCREEN, false);
        if(fullScreenChecked)
        {
        	fullScreenCheckbox.setChecked(true);
        }
        else
        {
        	fullScreenCheckbox.setChecked(false);
        }
        
        Intent ii = new Intent(this, LCD2EinkService.class);
   //     bindService(ii, mConnection, Context.BIND_AUTO_CREATE);
        ii.putExtra("Mode", LCD2EinkService.INITIALIZE);
        this.startService(ii);
        return;     
    }
    

    public void Capture() { 
    	finish();
    	Log.e("lcd2einkactivity", "capture");
    	// do something useful here 
        Intent i = new Intent(this, LCD2EinkService.class);
        i.putExtra("Mode", LCD2EinkService.CAPTURE_WITH_SYSTEM_DELAY);
        this.startService(i);
    	
    	
    } 
    public void RemoveNotification() { 
    	finish();
        localNotificationManager.cancel(notificationRef);
        
        Intent i = new Intent(this, LCD2EinkService.class);
        this.stopService(i);

        prefs = PreferenceManager.getDefaultSharedPreferences(this);
        boolean autoModeChecked = prefs.getBoolean(PREF_AUTO_MODE, false);
        boolean readerKeyListenerRunning = prefs.getBoolean(PREF_EVKLISTENER_RUNNING, false);
        boolean readerPenListenerRunning = prefs.getBoolean(PREF_WACOMLISTENER_RUNNING, false);
        if(autoModeChecked)
        {
        	timer.cancel();
        }
        if(readerKeyListenerRunning)
        {
			destroyReaderKeyListenerProcess();
        	readerKeyListener = null;
        }
        SystemClock.sleep(500);
        if(readerPenListenerRunning)
        {
			destroyReaderPenListenerProcess();
        }
        android.os.Process.killProcess(android.os.Process.myPid());

        

    	
    	// do something useful here 
   } 
    private void destroyReaderKeyListenerProcess()
    {
   	 try {
			Runtime.getRuntime().exec("su -c "+appRoot +"/lib/libexekillevklistener.so");
			Editor editor = prefs.edit();
		    editor.putBoolean(PREF_EVKLISTENER_RUNNING, false);
    		editor.commit();

   	 } catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} 

     }
    private void destroyReaderPenListenerProcess()
    {
   	 try {
			Runtime.getRuntime().exec("su -c "+appRoot +"/lib/libexekillwacomlistener.so");
			Editor editor = prefs.edit();
		    editor.putBoolean(PREF_WACOMLISTENER_RUNNING, false);
    		editor.commit();

   	 } catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} 

     }
    
    private void Calibrate() { 
    	Log.e("lcd2einkactivity", "Calibrate");
    	// do something useful here 
      	 try {
 			Runtime.getRuntime().exec("su -c "+appRoot +"/lib/libexecalibration.so");
    	 } catch (IOException e) {
 			// TODO Auto-generated catch block
 			e.printStackTrace();
 		} 
    } 
    
    private void RotateReader() { 
    	Log.e("lcd2einkactivity", "RotateReader");
    	// do something useful here 
      	 try {
 			Runtime.getRuntime().exec("su -c "+appRoot +"/lib/libexerotatereader.so");
    	 } catch (IOException e) {
 			// TODO Auto-generated catch block
 			e.printStackTrace();
 		} 
    } 

    @Override  
    protected void onStart() {  
        super.onStart();  
        Log.e("LCD2EinkActivity", "start onStart~~~");  
    }  
       
    @Override  
    protected void onRestart() {  
        super.onRestart();  
        Log.e("LCD2EinkActivity", "start onRestart~~~");  
    }  
       
    @Override  
    protected void onResume() {  
        super.onResume();  
        Log.e("LCD2EinkActivity", "start onResume~~~");  
    }  
       
    @Override  
    protected void onPause() {  
        super.onPause();  
        Log.e("LCD2EinkActivity", "start onPause~~~");  
    }  
       
    @Override  
    protected void onStop() {  
        super.onStop();  
        Log.e("LCD2EinkActivity", "start onStop~~~");  
    }  
       
    @Override  
    protected void onDestroy() {  
        super.onDestroy();  
        Log.e("LCD2EinkActivity", "start onDestroy~~~");  
    }    
}