package com.javese.android.lcd2einkapp;


import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.SystemClock;
import android.util.Log;


import android.content.Context;
import android.graphics.*;
import android.graphics.drawable.*;
import android.view.*;
import android.util.AttributeSet;
import android.content.res.Resources;
public class CalibrationView extends View {
	private int calibrationStep = CalibrationActivity.CALIBRATION_DONE;
	public CalibrationView(Context context) {
		super(context);
		}
	
	public CalibrationView(Context context, AttributeSet attrs) {
		super(context, attrs);
		}
	
	public CalibrationView(Context context,
		AttributeSet ats,
		int defaultStyle) {
		super(context, ats, defaultStyle);
		}
		
	public void SetStep(int step)
	{
		calibrationStep = step;
	}
	@Override
	protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
	// The compass is a circle that fills as much space as possible.
	// Set the measured dimensions by figuring out the shortest boundary,
	// height or width.
	int measuredWidth = measure(widthMeasureSpec);
	int measuredHeight = measure(heightMeasureSpec);
	
	setMeasuredDimension(measuredWidth, measuredHeight);
	}
	
	private int measure(int measureSpec) {
		int result = 0;
		// Decode the measurement specifications.
		int specMode = MeasureSpec.getMode(measureSpec);
		int specSize = MeasureSpec.getSize(measureSpec);
		if (specMode == MeasureSpec.UNSPECIFIED) {
		// Return a default size of 200 if no bounds are specified.
		result = 200;
		} else {
		// As you want to fill the available space
		// always return the full available bounds.
		result = specSize;
		}
		return result;
	}
	
	@Override
	protected void onDraw(Canvas canvas) {
		Paint arrowPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
		arrowPaint.setColor(Color.WHITE);
		arrowPaint.setStrokeWidth(1);
		arrowPaint.setStyle(Paint.Style.FILL);
		canvas.drawRect(0,0,getMeasuredWidth(),getMeasuredHeight(), arrowPaint);
		
		switch(calibrationStep)
		{
		case CalibrationActivity.CALIBRATION_TABLET_LEFT_TOP:
			arrowPaint.setColor(Color.BLACK);
			canvas.drawLine(0, 0, 10,30,arrowPaint);
			canvas.drawLine(0, 0, 30,10,arrowPaint);
			canvas.drawLine(0, 0, 50,50,arrowPaint);
			canvas.drawText(getContext().getString(R.string.calibration_tablet_left_top), getMeasuredWidth()/2, getMeasuredHeight()/2, arrowPaint);
			break;
		case CalibrationActivity.CALIBRATION_WACOM_RIGHT_TOP:
			arrowPaint.setColor(Color.BLACK);
			canvas.drawLine(getMeasuredWidth(), 0, getMeasuredWidth()-10,30,arrowPaint);
			canvas.drawLine(getMeasuredWidth(), 0, getMeasuredWidth()-30,10,arrowPaint);
			canvas.drawLine(getMeasuredWidth(), 0, getMeasuredWidth()-50,50,arrowPaint);
			canvas.drawText(getContext().getString(R.string.calibration_wacom_right_top), getMeasuredWidth()/2, getMeasuredHeight()/2, arrowPaint);
			Capture();

			break;
		case CalibrationActivity.CALIBRATION_TABLET_RIGHT_BOTTOM:
			arrowPaint.setColor(Color.BLACK);
			canvas.drawLine(getMeasuredWidth(), getMeasuredHeight(), getMeasuredWidth()-10,getMeasuredHeight()-30,arrowPaint);
			canvas.drawLine(getMeasuredWidth(), getMeasuredHeight(), getMeasuredWidth()-30,getMeasuredHeight()-10,arrowPaint);
			canvas.drawLine(getMeasuredWidth(), getMeasuredHeight(), getMeasuredWidth()-50,getMeasuredHeight()-50,arrowPaint);
			canvas.drawText(getContext().getString(R.string.calibration_tablet_right_bottom), getMeasuredWidth()/2, getMeasuredHeight()/2, arrowPaint);
			break;
		case CalibrationActivity.CALIBRATION_WACOM_LEFT_BOTTOM:
			arrowPaint.setColor(Color.BLACK);
			canvas.drawLine(0, getMeasuredHeight(), 10,getMeasuredHeight()-30,arrowPaint);
			canvas.drawLine(0, getMeasuredHeight(), 30,getMeasuredHeight()-10,arrowPaint);
			canvas.drawLine(0, getMeasuredHeight(), 50,getMeasuredHeight()-50,arrowPaint);
			canvas.drawText(getContext().getString(R.string.calibration_wacom_left_bottom), getMeasuredWidth()/2, getMeasuredHeight()/2, arrowPaint);
			Capture();

			break;
		case CalibrationActivity.CALIBRATION_DONE:
			arrowPaint.setColor(Color.BLACK);
			canvas.drawText(getContext().getString(R.string.calibration_done), getMeasuredWidth()/2, getMeasuredHeight()/2, arrowPaint);
			Capture();
			break;
		default:
			break;	
		}
	
	}
	
    private void Capture() { 
    	// do something useful here 
    	Intent i = new Intent(getContext(), LCD2EinkService.class);
        i.putExtra("Mode", LCD2EinkService.CAPTURE_WITH_SYSTEM_DELAY);
        getContext().startService(i);  	
    } 
}