package com.javese.android.lcd2einkapp;


import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.SystemClock;
import android.util.Log;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.LinearLayout;
import com.javese.android.lcd2einkapp.CalibrationView;


public class CalibrationActivity extends Activity {
	
	public static final int CALIBRATION_TABLET_LEFT_TOP = 1;
	public static final int CALIBRATION_WACOM_RIGHT_TOP = 2;
	public static final int CALIBRATION_TABLET_RIGHT_BOTTOM = 3;
	public static final int CALIBRATION_WACOM_LEFT_BOTTOM = 4;
	public static final int CALIBRATION_DONE = 5;
	CalibrationView view = null;
	

	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
    	super.onCreate(savedInstanceState);  
    	  
    	requestWindowFeature(Window.FEATURE_NO_TITLE);          
    	Window win = getWindow();  
    	win.setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,  
    	        WindowManager.LayoutParams.FLAG_FULLSCREEN);    
    	              
    	setContentView(R.layout.calibration);
    	view = (CalibrationView)this.findViewById(R.id.calibrationView);    
    }
    
    @Override  
    protected void onStart(){
    	super.onStart();  
	// TODO: Actions to perform when service is created.
		Log.i("CalibrationActivity", "OnStart");
		
		int step = this.getIntent().getIntExtra("Step", CALIBRATION_DONE);
		Log.i("CalibrationActivity", "Step = "+step);
    	view.SetStep(step);
	}
	
    public void Capture() { 
    	finish();
    	Log.e("SearchKeyActivity", "capture");
    	// do something useful here 
        Intent i = new Intent(this, LCD2EinkService.class);
        i.putExtra("DisableCheck", true);
        i.putExtra("DisableDelay", true);
        this.startService(i);
    	
    	
    } 
    
}