package com.javese.android.lcd2einkapp;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.SystemClock;
import android.preference.PreferenceManager;
import android.util.Log;
import android.widget.LinearLayout;
import android.widget.LinearLayout.LayoutParams;
import android.widget.Toast;
import java.io.File;

public class LCD2EinkService extends Service
{
  public static final int CAPTURE = 0;
  public static final int CAPTURE_WITH_OPTION = 4;
  public static final int CAPTURE_WITH_SYSTEM_DELAY = 2;
  public static final int CAPTURE_WITH_USER_DELAY = 3;
  public static final int CHECKFB = 1;
  public static final int INITIALIZE = 5;
  String appRoot;
  private ServiceConnection mConnection;
  SharedPreferences prefs;
  private IBinder serviceBinder;

  public LCD2EinkService()
  {
    1 local1 = new ServiceConnection()
    {
      public void onServiceConnected(ComponentName paramComponentName, IBinder paramIBinder)
      {
        LCD2EinkService.this.serviceBinder = paramIBinder;
        String str = "onServiceConnected:" + paramComponentName;
        int i = Log.i("lcd2einkservice", str);
      }

      public void onServiceDisconnected(ComponentName paramComponentName)
      {
        LCD2EinkService.this.serviceBinder = null;
      }
    };
    this.mConnection = local1;
    this.appRoot = null;
  }

  private void DisplayOnEPaper()
  {
    int i = Log.i("lcd2einkservice", "DisplayOnEPaper");
    String str = "/sdcard/public/screen.pdf";
    if (!new File(str).exists())
    {
      str = "/intsdcard/public/screen.pdf";
      if (!new File(str).exists())
        return;
    }
    if (this.serviceBinder == null)
    {
      int j = Log.i("lcd2einkservice", "serviceBinder is null.");
      return;
    }
    Parcel localParcel1 = Parcel.obtain();
    Parcel localParcel2 = Parcel.obtain();
    try
    {
      localParcel1.writeInterfaceToken("com.entouragesys.android.common.idl.IReaderService");
      localParcel1.writeString(str);
      localParcel1.writeString(null);
      try
      {
        boolean bool = this.serviceBinder.transact(1, localParcel1, localParcel2, 0);
        localParcel2.readException();
        int k = localParcel2.readInt();
        int m = k;
        localParcel2.recycle();
        localParcel1.recycle();
        return;
      }
      catch (RemoteException localRemoteException)
      {
        while (true)
          localRemoteException.printStackTrace();
      }
    }
    finally
    {
      localParcel2.recycle();
      localParcel1.recycle();
    }
    throw localObject;
  }

  private void DummyToast()
  {
    Context localContext = getApplicationContext();
    Toast localToast = Toast.makeText(localContext, "", 0);
    localToast.setGravity(48, 0, 0);
    LinearLayout localLinearLayout = new LinearLayout(localContext);
    localLinearLayout.setOrientation(1);
    DummyToastView localDummyToastView = new DummyToastView(localContext);
    LinearLayout.LayoutParams localLayoutParams = new LinearLayout.LayoutParams(-1, -1);
    localLinearLayout.addView(localDummyToastView, localLayoutParams);
    localToast.setView(localLinearLayout);
    localToast.show();
  }

  public IBinder onBind(Intent paramIntent)
  {
    return null;
  }

  public void onCreate()
  {
    int i = Log.i("lcd2einkservice", "OnCreate");
    String str = getApplicationContext().getFilesDir().getParent();
    this.appRoot = str;
    SharedPreferences localSharedPreferences = PreferenceManager.getDefaultSharedPreferences(this);
    this.prefs = localSharedPreferences;
    Intent localIntent = new Intent("com.entouragesys.android.common.idl.IReaderService");
    ServiceConnection localServiceConnection = this.mConnection;
    boolean bool = bindService(localIntent, localServiceConnection, 1);
    if (this.serviceBinder != null)
      return;
    int j = Log.i("lcd2einkservice", "serviceBinder is null.");
  }

  public void onDestroy()
  {
    int i = Log.i("lcd2einkservice", "onDestroy");
  }

  public void onStart(Intent paramIntent, int paramInt)
  {
    int i = Log.i("lcd2einkservice", "OnStart");
    String str1 = this.appRoot;
    int j = Log.i("lcd2einkservice,appRoot = ", str1);
    int k = 0;
    int m = paramIntent.getIntExtra("Mode", 0);
    StringBuilder localStringBuilder = new StringBuilder("su -c ");
    String str2 = this.appRoot;
    String str3 = str2;
    String str4 = "Mode = " + m;
    int n = Log.i("lcd2einkservice", str4);
    switch (m)
    {
    default:
      String str5 = String.valueOf(str3);
      str3 = str5 + "/lib/libexescreen2pdf.so";
    case 5:
    case 1:
    case 2:
    case 3:
    case 4:
    }
    while (true)
    {
      DummyToast();
      try
      {
        localProcess = Runtime.getRuntime().exec(str3);
        int i1 = localProcess.waitFor();
        k = i1;
        localProcess.destroy();
        if (k != 1)
          return;
        DisplayOnEPaper();
        return;
        String str6 = String.valueOf(str3);
        str3 = str6 + "/lib/libexecheckfb.so";
        continue;
        SystemClock.sleep(300L);
        int i2 = Log.i("lcd2einkservice", "sleep for 300 ms.");
        String str7 = String.valueOf(str3);
        str3 = str7 + "/lib/libexescreen2pdf.so";
        continue;
        SystemClock.sleep(this.prefs.getInt("PREF_USER_DELAY", 100));
        int i3 = Log.i("lcd2einkservice", "sleep for user defined delay");
        String str8 = String.valueOf(str3);
        str3 = str8 + "/lib/libexescreen2pdf.so";
        continue;
        if (!this.prefs.getBoolean("PREF_PENUP_CAPTURE", false))
          return;
        SystemClock.sleep(300L);
        int i4 = Log.i("lcd2einkservice", "sleep for user defined delay");
        String str9 = String.valueOf(str3);
        str3 = str9 + "/lib/libexescreen2pdf.so";
        continue;
      }
      catch (Exception localException)
      {
        while (true)
        {
          localException.printStackTrace();
          localProcess.destroy();
        }
      }
      finally
      {
        Process localProcess;
        localProcess.destroy();
      }
    }
    throw localObject;
  }
}

/* Location:           /e/dev/edge/LCD2Eink_dex2jar.jar
 * Qualified Name:     com.javese.android.lcd2einkapp.LCD2EinkService
 * JD-Core Version:    0.6.0
 */