package com.javese.android.lcd2einkapp;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.SystemClock;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.TextView.OnEditorActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

public class LCD2EinkActivity extends Activity
{
  public static final String PREF_AUTOFRESH_INTERVAL = "PREF_AUTOFRESH_INTERVAL";
  public static final String PREF_AUTO_MODE = "PREF_AUTO_MODE";
  public static final String PREF_EVKLISTENER_RUNNING = "PREF_EVKLISTENER_RUNNING";
  public static final String PREF_MONITOR_READER_KEY = "PREF_MONITOR_READER_KEY";
  public static final String PREF_MONITOR_READER_PAGE_KEY = "PREF_MONITOR_READER_PAGE_KEY";
  public static final String PREF_MONITOR_READER_PEN = "PREF_MONITOR_READER_PEN";
  public static final String PREF_PENUP_CAPTURE = "PREF_PENUP_CAPTURE";
  public static final String PREF_USER_DELAY = "PREF_USER_DELAY";
  public static final String PREF_WACOMLISTENER_RUNNING = "PREF_WACOMLISTENER_RUNNING";
  private Button RemoveNotificationButton = null;
  String appRoot = null;
  private CheckBox autoModeCheckbox = null;
  private EditText autofreshIntervalEdit = null;
  private Button calibrateButton = null;
  private Button captureButton = null;
  Handler handler;
  NotificationManager localNotificationManager;
  private ServiceConnection mConnection;
  int notificationRef;
  private CheckBox penupCaptureCheckbox = null;
  SharedPreferences prefs;
  private java.lang.Process readerKeyListener = null;
  private CheckBox readerKeyListenerCheckbox = null;
  String readerKeyListenerCommand = null;
  private CheckBox readerPageKeyListenerCheckbox = null;
  private CheckBox readerPenListenerCheckbox = null;
  String readerPenListenerCommand = null;
  private Button rotateReaderButton = null;
  private IBinder serviceBinder;
  TimerTask task;
  Timer timer;
  private EditText userDelayEdit = null;

  public LCD2EinkActivity()
  {
    1 local1 = new ServiceConnection()
    {
      public void onServiceConnected(ComponentName paramComponentName, IBinder paramIBinder)
      {
        LCD2EinkActivity.this.serviceBinder = paramIBinder;
        String str = "onServiceConnected:" + paramComponentName;
        int i = Log.i("LCD2EinkActivity", str);
      }

      public void onServiceDisconnected(ComponentName paramComponentName)
      {
        LCD2EinkActivity.this.serviceBinder = null;
      }
    };
    this.mConnection = local1;
    this.localNotificationManager = null;
    this.notificationRef = 1;
    this.timer = null;
    this.task = null;
    2 local2 = new Handler()
    {
      public void handleMessage(Message paramMessage)
      {
        switch (paramMessage.what)
        {
        default:
        case 1:
        }
        while (true)
        {
          super.handleMessage(paramMessage);
          return;
          LCD2EinkActivity localLCD2EinkActivity1 = LCD2EinkActivity.this;
          Intent localIntent1 = new Intent(localLCD2EinkActivity1, LCD2EinkService.class);
          Intent localIntent2 = localIntent1.putExtra("Mode", 1);
          ComponentName localComponentName = LCD2EinkActivity.this.startService(localIntent1);
          LCD2EinkActivity localLCD2EinkActivity2 = LCD2EinkActivity.this;
          SharedPreferences localSharedPreferences = PreferenceManager.getDefaultSharedPreferences(LCD2EinkActivity.this);
          localLCD2EinkActivity2.prefs = localSharedPreferences;
          boolean bool = LCD2EinkActivity.this.prefs.getBoolean("PREF_AUTO_MODE", false);
          int i = LCD2EinkActivity.this.prefs.getInt("PREF_AUTOFRESH_INTERVAL", 5);
          if (!bool)
            continue;
          LCD2EinkActivity localLCD2EinkActivity3 = LCD2EinkActivity.this;
          Timer localTimer1 = new Timer();
          localLCD2EinkActivity3.timer = localTimer1;
          LCD2EinkActivity localLCD2EinkActivity4 = LCD2EinkActivity.this;
          1 local1 = new TimerTask()
          {
            public void run()
            {
              Message localMessage = new Message();
              localMessage.what = 1;
              boolean bool = LCD2EinkActivity.this.handler.sendMessage(localMessage);
            }
          };
          localLCD2EinkActivity4.task = local1;
          Timer localTimer2 = LCD2EinkActivity.this.timer;
          TimerTask localTimerTask = LCD2EinkActivity.this.task;
          long l = i * 1000;
          localTimer2.schedule(localTimerTask, l);
        }
      }
    };
    this.handler = local2;
  }

  private void Calibrate()
  {
    int i = Log.e("lcd2einkactivity", "Calibrate");
    try
    {
      Runtime localRuntime = Runtime.getRuntime();
      StringBuilder localStringBuilder = new StringBuilder("su -c ");
      String str1 = this.appRoot;
      String str2 = str1 + "/lib/libexecalibration.so";
      java.lang.Process localProcess = localRuntime.exec(str2);
      return;
    }
    catch (IOException localIOException)
    {
      localIOException.printStackTrace();
    }
  }

  private void RotateReader()
  {
    int i = Log.e("lcd2einkactivity", "RotateReader");
    try
    {
      Runtime localRuntime = Runtime.getRuntime();
      StringBuilder localStringBuilder = new StringBuilder("su -c ");
      String str1 = this.appRoot;
      String str2 = str1 + "/lib/libexerotatereader.so";
      java.lang.Process localProcess = localRuntime.exec(str2);
      return;
    }
    catch (IOException localIOException)
    {
      localIOException.printStackTrace();
    }
  }

  private void destroyReaderKeyListenerProcess()
  {
    try
    {
      Runtime localRuntime = Runtime.getRuntime();
      StringBuilder localStringBuilder = new StringBuilder("su -c ");
      String str1 = this.appRoot;
      String str2 = str1 + "/lib/libexekillevklistener.so";
      java.lang.Process localProcess = localRuntime.exec(str2);
      SharedPreferences.Editor localEditor1 = this.prefs.edit();
      SharedPreferences.Editor localEditor2 = localEditor1.putBoolean("PREF_EVKLISTENER_RUNNING", false);
      boolean bool = localEditor1.commit();
      return;
    }
    catch (IOException localIOException)
    {
      localIOException.printStackTrace();
    }
  }

  private void destroyReaderPenListenerProcess()
  {
    try
    {
      Runtime localRuntime = Runtime.getRuntime();
      StringBuilder localStringBuilder = new StringBuilder("su -c ");
      String str1 = this.appRoot;
      String str2 = str1 + "/lib/libexekillwacomlistener.so";
      java.lang.Process localProcess = localRuntime.exec(str2);
      SharedPreferences.Editor localEditor1 = this.prefs.edit();
      SharedPreferences.Editor localEditor2 = localEditor1.putBoolean("PREF_WACOMLISTENER_RUNNING", false);
      boolean bool = localEditor1.commit();
      return;
    }
    catch (IOException localIOException)
    {
      localIOException.printStackTrace();
    }
  }

  public void Capture()
  {
    finish();
    int i = Log.e("lcd2einkactivity", "capture");
    Intent localIntent1 = new Intent(this, LCD2EinkService.class);
    Intent localIntent2 = localIntent1.putExtra("Mode", 2);
    ComponentName localComponentName = startService(localIntent1);
  }

  public void RemoveNotification()
  {
    finish();
    NotificationManager localNotificationManager1 = this.localNotificationManager;
    int i = this.notificationRef;
    localNotificationManager1.cancel(i);
    Intent localIntent = new Intent(this, LCD2EinkService.class);
    boolean bool1 = stopService(localIntent);
    SharedPreferences localSharedPreferences = PreferenceManager.getDefaultSharedPreferences(this);
    this.prefs = localSharedPreferences;
    boolean bool2 = this.prefs.getBoolean("PREF_AUTO_MODE", false);
    boolean bool3 = this.prefs.getBoolean("PREF_EVKLISTENER_RUNNING", false);
    boolean bool4 = this.prefs.getBoolean("PREF_WACOMLISTENER_RUNNING", false);
    if (bool2)
      this.timer.cancel();
    if (bool3)
    {
      destroyReaderKeyListenerProcess();
      this.readerKeyListener = null;
    }
    SystemClock.sleep(500L);
    if (bool4)
      destroyReaderPenListenerProcess();
    android.os.Process.killProcess(android.os.Process.myPid());
  }

  public void onCreate(Bundle paramBundle)
  {
    super.onCreate(paramBundle);
    LCD2EinkActivity localLCD2EinkActivity1 = this;
    int i = 2130903041;
    localLCD2EinkActivity1.setContentView(i);
    SharedPreferences localSharedPreferences = PreferenceManager.getDefaultSharedPreferences(this);
    this.prefs = localSharedPreferences;
    String str1 = getApplicationContext().getFilesDir().getParent();
    this.appRoot = str1;
    StringBuilder localStringBuilder1 = new StringBuilder("su -c ");
    String str2 = this.appRoot;
    String str3 = str2 + "/lib/libexeevklistener.so";
    this.readerKeyListenerCommand = str3;
    StringBuilder localStringBuilder2 = new StringBuilder("su -c ");
    String str4 = this.appRoot;
    String str5 = str4 + "/lib/libexewacomlistener.so";
    this.readerPenListenerCommand = str5;
    LCD2EinkActivity localLCD2EinkActivity2 = this;
    int j = 2131034126;
    Button localButton1 = (Button)localLCD2EinkActivity2.findViewById(j);
    this.captureButton = localButton1;
    LCD2EinkActivity localLCD2EinkActivity3 = this;
    int k = 2131034128;
    Button localButton2 = (Button)localLCD2EinkActivity3.findViewById(k);
    this.RemoveNotificationButton = localButton2;
    LCD2EinkActivity localLCD2EinkActivity4 = this;
    int m = 2131034127;
    Button localButton3 = (Button)localLCD2EinkActivity4.findViewById(m);
    this.rotateReaderButton = localButton3;
    Button localButton4 = this.captureButton;
    3 local31 = new com/javese/android/lcd2einkapp/LCD2EinkActivity$3;
    3 local32 = local31;
    LCD2EinkActivity localLCD2EinkActivity5 = this;
    local32.<init>(localLCD2EinkActivity5);
    localButton4.setOnClickListener(local31);
    Button localButton5 = this.RemoveNotificationButton;
    4 local41 = new com/javese/android/lcd2einkapp/LCD2EinkActivity$4;
    4 local42 = local41;
    LCD2EinkActivity localLCD2EinkActivity6 = this;
    local42.<init>(localLCD2EinkActivity6);
    localButton5.setOnClickListener(local41);
    Button localButton6 = this.rotateReaderButton;
    5 local51 = new com/javese/android/lcd2einkapp/LCD2EinkActivity$5;
    5 local52 = local51;
    LCD2EinkActivity localLCD2EinkActivity7 = this;
    local52.<init>(localLCD2EinkActivity7);
    localButton6.setOnClickListener(local51);
    LCD2EinkActivity localLCD2EinkActivity8 = this;
    int n = 2131034125;
    Button localButton7 = (Button)localLCD2EinkActivity8.findViewById(n);
    this.calibrateButton = localButton7;
    Button localButton8 = this.calibrateButton;
    6 local61 = new com/javese/android/lcd2einkapp/LCD2EinkActivity$6;
    6 local62 = local61;
    LCD2EinkActivity localLCD2EinkActivity9 = this;
    local62.<init>(localLCD2EinkActivity9);
    localButton8.setOnClickListener(local61);
    LCD2EinkActivity localLCD2EinkActivity10 = this;
    int i1 = 2131034113;
    CheckBox localCheckBox1 = (CheckBox)localLCD2EinkActivity10.findViewById(i1);
    this.autoModeCheckbox = localCheckBox1;
    CheckBox localCheckBox2 = this.autoModeCheckbox;
    7 local71 = new com/javese/android/lcd2einkapp/LCD2EinkActivity$7;
    7 local72 = local71;
    LCD2EinkActivity localLCD2EinkActivity11 = this;
    local72.<init>(localLCD2EinkActivity11);
    localCheckBox2.setOnCheckedChangeListener(local71);
    LCD2EinkActivity localLCD2EinkActivity12 = this;
    int i2 = 2131034116;
    EditText localEditText1 = (EditText)localLCD2EinkActivity12.findViewById(i2);
    this.autofreshIntervalEdit = localEditText1;
    EditText localEditText2 = this.autofreshIntervalEdit;
    8 local81 = new com/javese/android/lcd2einkapp/LCD2EinkActivity$8;
    8 local82 = local81;
    LCD2EinkActivity localLCD2EinkActivity13 = this;
    local82.<init>(localLCD2EinkActivity13);
    localEditText2.setOnEditorActionListener(local81);
    int i3 = this.prefs.getInt("PREF_AUTOFRESH_INTERVAL", 5);
    EditText localEditText3 = this.autofreshIntervalEdit;
    StringBuilder localStringBuilder3 = new StringBuilder();
    int i4 = i3;
    String str6 = i4;
    localEditText3.setText(str6);
    LCD2EinkActivity localLCD2EinkActivity14 = this;
    int i5 = 2131034121;
    EditText localEditText4 = (EditText)localLCD2EinkActivity14.findViewById(i5);
    this.userDelayEdit = localEditText4;
    EditText localEditText5 = this.userDelayEdit;
    9 local91 = new com/javese/android/lcd2einkapp/LCD2EinkActivity$9;
    9 local92 = local91;
    LCD2EinkActivity localLCD2EinkActivity15 = this;
    local92.<init>(localLCD2EinkActivity15);
    localEditText5.setOnEditorActionListener(local91);
    int i6 = this.prefs.getInt("PREF_USER_DELAY", 100);
    EditText localEditText6 = this.userDelayEdit;
    StringBuilder localStringBuilder4 = new StringBuilder();
    int i7 = i6;
    String str7 = i7;
    localEditText6.setText(str7);
    LCD2EinkActivity localLCD2EinkActivity16 = this;
    int i8 = 2131034118;
    CheckBox localCheckBox3 = (CheckBox)localLCD2EinkActivity16.findViewById(i8);
    this.readerKeyListenerCheckbox = localCheckBox3;
    CheckBox localCheckBox4 = this.readerKeyListenerCheckbox;
    10 local101 = new com/javese/android/lcd2einkapp/LCD2EinkActivity$10;
    10 local102 = local101;
    LCD2EinkActivity localLCD2EinkActivity17 = this;
    local102.<init>(localLCD2EinkActivity17);
    localCheckBox4.setOnCheckedChangeListener(local101);
    LCD2EinkActivity localLCD2EinkActivity18 = this;
    int i9 = 2131034122;
    CheckBox localCheckBox5 = (CheckBox)localLCD2EinkActivity18.findViewById(i9);
    this.readerPageKeyListenerCheckbox = localCheckBox5;
    CheckBox localCheckBox6 = this.readerPageKeyListenerCheckbox;
    11 local111 = new com/javese/android/lcd2einkapp/LCD2EinkActivity$11;
    11 local112 = local111;
    LCD2EinkActivity localLCD2EinkActivity19 = this;
    local112.<init>(localLCD2EinkActivity19);
    localCheckBox6.setOnCheckedChangeListener(local111);
    LCD2EinkActivity localLCD2EinkActivity20 = this;
    int i10 = 2131034123;
    CheckBox localCheckBox7 = (CheckBox)localLCD2EinkActivity20.findViewById(i10);
    this.readerPenListenerCheckbox = localCheckBox7;
    CheckBox localCheckBox8 = this.readerPenListenerCheckbox;
    12 local121 = new com/javese/android/lcd2einkapp/LCD2EinkActivity$12;
    12 local122 = local121;
    LCD2EinkActivity localLCD2EinkActivity21 = this;
    local122.<init>(localLCD2EinkActivity21);
    localCheckBox8.setOnCheckedChangeListener(local121);
    LCD2EinkActivity localLCD2EinkActivity22 = this;
    int i11 = 2131034124;
    CheckBox localCheckBox9 = (CheckBox)localLCD2EinkActivity22.findViewById(i11);
    this.penupCaptureCheckbox = localCheckBox9;
    CheckBox localCheckBox10 = this.penupCaptureCheckbox;
    13 local131 = new com/javese/android/lcd2einkapp/LCD2EinkActivity$13;
    13 local132 = local131;
    LCD2EinkActivity localLCD2EinkActivity23 = this;
    local132.<init>(localLCD2EinkActivity23);
    localCheckBox10.setOnCheckedChangeListener(local131);
    LCD2EinkActivity localLCD2EinkActivity24 = this;
    int i12 = 2131034129;
    TextView localTextView = (TextView)localLCD2EinkActivity24.findViewById(i12);
    LCD2EinkActivity localLCD2EinkActivity25 = this;
    int i13 = 2130968580;
    String str8 = String.valueOf(localLCD2EinkActivity25.getString(i13));
    StringBuilder localStringBuilder5 = new StringBuilder(str8).append(": javese\n");
    LCD2EinkActivity localLCD2EinkActivity26 = this;
    int i14 = 2130968581;
    String str9 = localLCD2EinkActivity26.getString(i14);
    String str10 = str9 + ": 0.1.12\n";
    localTextView.setText(str10);
    LCD2EinkActivity localLCD2EinkActivity27 = this;
    String str11 = "notification";
    NotificationManager localNotificationManager1 = (NotificationManager)localLCD2EinkActivity27.getSystemService(str11);
    this.localNotificationManager = localNotificationManager1;
    LCD2EinkActivity localLCD2EinkActivity28 = this;
    int i15 = 2130968577;
    String str12 = localLCD2EinkActivity28.getString(i15);
    long l1 = System.currentTimeMillis();
    Notification localNotification1 = new android/app/Notification;
    Notification localNotification2 = localNotification1;
    int i16 = 2130837504;
    String str13 = str12;
    long l2 = l1;
    localNotification2.<init>(i16, str13, l2);
    int i17 = localNotification1.flags | 0x2;
    localNotification1.flags = i17;
    Intent localIntent1 = new android/content/Intent;
    Intent localIntent2 = localIntent1;
    LCD2EinkActivity localLCD2EinkActivity29 = this;
    LCD2EinkService localLCD2EinkService1 = LCD2EinkService.class;
    localIntent2.<init>(localLCD2EinkActivity29, localLCD2EinkService1);
    Intent localIntent3 = localIntent1;
    String str14 = "Mode";
    int i18 = 2;
    Intent localIntent4 = localIntent3.putExtra(str14, i18);
    LCD2EinkActivity localLCD2EinkActivity30 = this;
    int i19 = 0;
    Intent localIntent5 = localIntent1;
    int i20 = 134217728;
    PendingIntent localPendingIntent1 = PendingIntent.getService(localLCD2EinkActivity30, i19, localIntent5, i20);
    localNotification1.contentIntent = localPendingIntent1;
    LCD2EinkActivity localLCD2EinkActivity31 = this;
    int i21 = 2130968576;
    String str15 = localLCD2EinkActivity31.getString(i21);
    Notification localNotification3 = localNotification1;
    LCD2EinkActivity localLCD2EinkActivity32 = this;
    String str16 = str15;
    String str17 = str12;
    PendingIntent localPendingIntent2 = localPendingIntent1;
    localNotification3.setLatestEventInfo(localLCD2EinkActivity32, str16, str17, localPendingIntent2);
    NotificationManager localNotificationManager2 = this.localNotificationManager;
    int i22 = this.notificationRef;
    NotificationManager localNotificationManager3 = localNotificationManager2;
    int i23 = i22;
    Notification localNotification4 = localNotification1;
    localNotificationManager3.notify(i23, localNotification4);
    int i24 = this.prefs.getInt("PREF_AUTOFRESH_INTERVAL", 5);
    if (this.prefs.getBoolean("PREF_AUTO_MODE", false))
    {
      this.autoModeCheckbox.setChecked(true);
      Timer localTimer1 = new Timer();
      this.timer = localTimer1;
      14 local141 = new com/javese/android/lcd2einkapp/LCD2EinkActivity$14;
      14 local142 = local141;
      LCD2EinkActivity localLCD2EinkActivity33 = this;
      local142.<init>(localLCD2EinkActivity33);
      14 local143 = local141;
      this.task = local143;
      Timer localTimer2 = this.timer;
      TimerTask localTimerTask = this.task;
      long l3 = i24 * 1000;
      localTimer2.schedule(localTimerTask, l3);
      if (!this.prefs.getBoolean("PREF_MONITOR_READER_KEY", false))
        break label1515;
      this.readerKeyListenerCheckbox.setChecked(true);
      label1365: if (!this.prefs.getBoolean("PREF_MONITOR_READER_PAGE_KEY", false))
        break label1526;
      this.readerPageKeyListenerCheckbox.setChecked(true);
      label1388: if (!this.prefs.getBoolean("PREF_MONITOR_READER_PEN", false))
        break label1537;
      SystemClock.sleep(500L);
      this.readerPenListenerCheckbox.setChecked(true);
      label1417: if (!this.prefs.getBoolean("PREF_PENUP_CAPTURE", false))
        break label1548;
      this.penupCaptureCheckbox.setChecked(true);
    }
    while (true)
    {
      Intent localIntent6 = new android/content/Intent;
      Intent localIntent7 = localIntent6;
      LCD2EinkActivity localLCD2EinkActivity34 = this;
      LCD2EinkService localLCD2EinkService2 = LCD2EinkService.class;
      localIntent7.<init>(localLCD2EinkActivity34, localLCD2EinkService2);
      Intent localIntent8 = localIntent6;
      String str18 = "Mode";
      int i25 = 5;
      Intent localIntent9 = localIntent8.putExtra(str18, i25);
      LCD2EinkActivity localLCD2EinkActivity35 = this;
      Intent localIntent10 = localIntent6;
      ComponentName localComponentName = localLCD2EinkActivity35.startService(localIntent10);
      return;
      this.autoModeCheckbox.setChecked(false);
      break;
      label1515: this.readerKeyListenerCheckbox.setChecked(false);
      break label1365;
      label1526: this.readerPageKeyListenerCheckbox.setChecked(false);
      break label1388;
      label1537: this.readerPenListenerCheckbox.setChecked(false);
      break label1417;
      label1548: this.penupCaptureCheckbox.setChecked(false);
    }
  }

  protected void onDestroy()
  {
    super.onDestroy();
    int i = Log.e("LCD2EinkActivity", "start onDestroy~~~");
  }

  protected void onPause()
  {
    super.onPause();
    int i = Log.e("LCD2EinkActivity", "start onPause~~~");
  }

  protected void onRestart()
  {
    super.onRestart();
    int i = Log.e("LCD2EinkActivity", "start onRestart~~~");
  }

  protected void onResume()
  {
    super.onResume();
    int i = Log.e("LCD2EinkActivity", "start onResume~~~");
  }

  protected void onStart()
  {
    super.onStart();
    int i = Log.e("LCD2EinkActivity", "start onStart~~~");
  }

  protected void onStop()
  {
    super.onStop();
    int i = Log.e("LCD2EinkActivity", "start onStop~~~");
  }
}

/* Location:           /e/dev/edge/LCD2Eink_dex2jar.jar
 * Qualified Name:     com.javese.android.lcd2einkapp.LCD2EinkActivity
 * JD-Core Version:    0.6.0
 */