#!/bin/sh

CONFIG=$1
CERTIFICATE=`echo $CONFIG|sed -e 's/cfg$/pem/'`

getmonth() 
{
    case ${1} in
        Jan) echo 01 ;;
        Feb) echo 02 ;;
        Mar) echo 03 ;;
        Apr) echo 04 ;;
        May) echo 05 ;;
        Jun) echo 06 ;;
        Jul) echo 07 ;;
        Aug) echo 08 ;;
        Sep) echo 09 ;;
        Oct) echo 10 ;;
        Nov) echo 11 ;;
        Dec) echo 12 ;;
          *) echo 00 ;;
    esac
}

CERTIFDATE=$(openssl x509 -in ${CERTIFICATE} -noout -startdate|sed 's/notBefore\=//')
#remove this in production!
#CERTIFDATE='Jan 01 01:02:03 2017'

set -- ${CERTIFDATE}
MONTH=$(getmonth ${1})
CERTIFDATE="${4}-${MONTH}-${2} ${3}"
CERTIFTIME=$(date +%s -u -d "${CERTIFDATE}")

KINDLEDATE=$(date -u +"%F %T")
KINDLETIME=$(date +%s -u -d "${KINDLEDATE}")

#echo "cert3: " $CERTIFDATE $CERTIFTIME
#echo "kindle: " $KINDLEDATE $KINDLETIME

if [ ${CERTIFTIME} -gt ${KINDLETIME} ]
then
	echo "Kindle date is earlier than date of certificate!"
	echo "trying to set to 3 days past $CERTIFDATE"
	date -u "`date -u -D '%s' -d $(($CERTIFTIME+60*60*24*3)) +'%F %T'`"
	sleep 3
fi

NETID="`wpa_cli add_network | sed -n '2p'`"

CONFIG=`cat $CONFIG|sed -e "s/^/set_network $NETID /"`
CONFIG=$CONFIG`echo -e "\nset_network $NETID ca_cert \"$CERTIFICATE\""`
CONFIG=$CONFIG`echo -e "\nenable_network $NETID"`
CONFIG=$CONFIG`echo -e "\nquit"`
echo "$CONFIG"

EXEC=`echo "$CONFIG"|wpa_cli`
echo "$EXEC"
