package jetbookcolor.scribble;

import java.util.LinkedList;


/*
 * ScribbleFile - contains info from one single file, about multiple scribbles
 */
public class ScribbleFile {
	private LinkedList<Scribble> scribbles;

	private int page;
	
	private int fileXMax;
	private int fileYMax;

	/*
	 * Future use... Inside JBC, each scribble for each page is in a separate directory, in separate files.
	 */
	public int getPage(){
		return page;
	}
	
	public void setPage(int x){
		page = x;
	}
	
	public int getHorizontal() {
		return fileXMax;
	}

	public int getVertical() {
		return fileYMax;
	}	
	
	public void setHorizontal(int x) {
		fileXMax = x;
	}

	public void setVertical(int y){
		fileYMax = y;
	}

	public ScribbleFile(){
		scribbles = new LinkedList<Scribble>();
	}
	
	public void add(Scribble s){
		scribbles.add(s);
	}
	
	public LinkedList<Scribble> get(){
		return scribbles;
	}
}
