package jetbookcolor.pdf;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;

import jetbookcolor.scribble.Point;
import jetbookcolor.scribble.Scribble;
import jetbookcolor.scribble.ScribbleFile;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDocument;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;

public class PDFEditor {

	private String original;
	private String newfile;

	/**
	 * 
	 */
	public PDFEditor(String original, String newfile) throws IOException {
		this.original = original;
		this.newfile = newfile;
		
		System.out.println("Reading from pdf: " + original);
	}

	public boolean insert(ScribbleFile[] s) throws IOException, DocumentException{
		// Reads from original file
		PdfReader pdfReader = new PdfReader(original);

		// Opens a new file to write to
		PdfStamper pdfStamper = new PdfStamper(pdfReader, new FileOutputStream(newfile));
		
		// Edits file with page number specified
		for(int i = 0; i < s.length; i++){
			PdfContentByte content = pdfStamper.getOverContent(s[i].getPage());	
			insertToPdf(s[i], s[i].getPage(), content);		
		}
		
		pdfStamper.close(); // close file
		
		return true;
	}
	
	public boolean insert(ScribbleFile s) throws IOException, DocumentException {
		return insert(s, s.getPage()); // use ScribbleFile's internal page number
	}

	/*
	 * Inserts the given ScribbleFile into the page number specified
	 */
	public boolean insert(ScribbleFile s, int pageNumber) throws IOException, DocumentException{

		// Reads from original file
		PdfReader pdfReader = new PdfReader(original);

		// Opens a new file to write to
		PdfStamper pdfStamper = new PdfStamper(pdfReader, new FileOutputStream(newfile));
		
		// Edits file with page number specified
		PdfContentByte content = pdfStamper.getOverContent(pageNumber);
		
		insertToPdf(s, pageNumber, content);
		
		pdfStamper.close(); // close file
		
		return true;
	}
	
	private boolean insertToPdf(ScribbleFile s, int pageNumber, PdfContentByte content) throws IOException, DocumentException {
		System.out.println("Writing to page " + pageNumber);

		PdfDocument doc = content.getPdfDocument();
		Rectangle rect = doc.getPageSize();
		System.out.println("PDF has resolution: " + rect.getWidth() + " " + rect.getHeight());
		System.out.println("Scribble has resolution: " + s.getHorizontal() + " " + s.getVertical());
		
		float fileX = rect.getWidth();
		float fileY = rect.getHeight();
		int scribbleX = s.getHorizontal();
		int scribbleY = s.getVertical();
		// Need to scale properly...  * rect.getWidth() * Scribble.x / s.getHorizontal()
		
		// Write Scribble
		Iterator<Scribble> listIter = s.get().iterator();
		while(listIter.hasNext()){
			Iterator<Point> pointIter = listIter.next().get().iterator();
			Point firstpt = pointIter.next();
			
			content.moveTo(fileX * firstpt.X / scribbleX, fileY * firstpt.Y / scribbleY);
			while(pointIter.hasNext()){
				Point p = pointIter.next();
				content.lineTo(fileX * p.X / scribbleX, fileY * p.Y / scribbleY);
			}
			
			content.closePathStroke();
		}
		
		
		return true;
	}
}
