package jetbookcolor.gui;

import java.io.File;
import java.io.IOException;

import jetbookcolor.pdf.PDFEditor;
import jetbookcolor.scribble.ScribbleFile;
import jetbookcolor.scribble.ScribbleHandler;

import com.itextpdf.text.DocumentException;

public class ConsoleMain {
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO: More robust file handling
		// Currently, assuming 1st file is the pdf, 2nd file is the scribble
		// Future, 1st file is pdf, 2nd file might be directory name

		if (args.length < 2) {
			System.out.println("Need 2 arguments.");
			System.out.println("1st argument: Source PDF file");
			System.out.println("2nd argument: Either Scribble filename or Directory containing Scribble files");
			return;
		}

		ScribbleHandler shandler;
		PDFEditor pdf;
		try {
			File sfile = new File(args[1]);

			if (sfile.isDirectory()) {
				File[] list = sfile.listFiles();
				ScribbleFile[] f = new ScribbleFile[list.length];
				for(int i = 0; i < f.length; i++){
					f[i] = (new ScribbleHandler(list[i])).getScribbleFile();
				}
				
				pdf = new PDFEditor(args[0], args[0].substring(0, args[0].length() - 3) + "edited.pdf"); // Currently, will replace any file named "x.edited.pdf
				pdf.insert(f);
			
			} else {
				shandler = new ScribbleHandler(sfile);
				ScribbleFile f = shandler.getScribbleFile();
				
				pdf = new PDFEditor(args[0], args[0].substring(0, args[0].length() - 3) + "edited.pdf"); // Currently, will replace any file named "x.edited.pdf"
				pdf.insert(f);
			}
			

		} catch (IOException e) {
			System.out.println(e.toString());
		} catch (DocumentException e) {
			System.out.println(e.toString());
		}

	}

}
