#!/bin/env python
# -*- coding: utf-8 -*-

import serial,os,subprocess
from sys import exit,argv
from time import sleep

slp_interv  = 0.01
my_prompt   = "root@onyx"
ser_dev     = "/dev/ttyACM0"
remote_dir  = "/media/flash/"

class m92_ser:
   def __init__(self,dev_path):
      if not os.path.exists(dev_path):
         print "M92 not connected or not in usb_dev_mode!"
         exit(1)
      self.port = serial.Serial(dev_path, 115200, timeout=1)
      self.dev_path = dev_path
      line = self.logon()
      if my_prompt in line:
         print "M92 is ready."
         sleep(slp_interv)
      else:
         print "Logon failed."
         exit(1)
         
   def close(self):
      if not self.port.closed:
         self.port.close()
         sleep(slp_interv)
      
   def logon(self,user="root",password=""):
      self.port.write("\n")
      line = self.wait()
      cnt = 0
      while True:
         if my_prompt in line:
            return line
         if "onyx login:" in line:
            break
         line = self.port.readline()
         cnt += 1
         if cnt > 5:
            print "Device doesn't react!"
            return ""
      self.port.write("%s\n" % (user))
      self.port.readline()
      if password != "":
         sleep(slp_interv)
         self.port.write("%s\n" % (password))
         self.port.readline()
      return self.wait(my_prompt,10)
      
   def wait(self,test_str=None,max_cnt=6):
      line = self.port.readline()
      cnt  = 0
      while line.strip() == "" or (test_str != None and test_str not in line):
         sleep(slp_interv)
         line = self.port.readline()
         cnt += 1
         if cnt > max_cnt:
            return ""
      return line
      
   def push(self,upl_file,target_dir=remote_dir):
      if not os.path.exists(upl_file):
         print "File does not exist!"
         return
      self.port.write("test -d %s || echo Not found\n" % (target_dir))
      sleep(slp_interv)
      self.port.readline()
      if "Not found" in self.port.readline():
         print line
         print "Target directory %s does not exist!" % (target_dir)
         return
      self.port.write("cd %s\n" % (target_dir))
      self.port.write("/media/flash/bin/lrz\n")
      sleep(slp_interv)
      tmp_ser = open(self.dev_path,"w+b")
      subprocess.call(["/usr/bin/sz","-vv","-b","--zmodem",upl_file],stdout=tmp_ser,stdin=tmp_ser)
      tmp_ser.close()
      self.wait()
      
   def pull(self,down_file):
      self.port.write("test -e %s || echo Not found\n" % (down_file))
      sleep(slp_interv)
      self.port.readline()
      if "Not found" in self.port.readline():
         print "Requested file does not exist!"
         return
      self.port.write("/media/flash/bin/lsz -b --zmodem %s\n" % (down_file))
      sleep(slp_interv)
      tmp_ser = open(self.dev_path,"w+b")
      subprocess.call(["/usr/bin/rz","-vv"],stdout=tmp_ser,stdin=tmp_ser)
      tmp_ser.close()
      self.wait()
   
if __name__ == "__main__":
   if len(argv) == 1:
      print "(push|pull|shell) expected!"
      exit(1)
      
   m92 = m92_ser(ser_dev)
   if argv[1] == "pull":
      if len(argv) < 3:
         print "Missing file argument!"
         exit(1)
      m92.pull(argv[2])
   elif argv[1] == "push":
      if len(argv) < 3:
         print "Missing file argument!"
         exit(1)
      for f in argv[2:]:
         m92.push(f)
   elif argv[1] == "shell":
      m92.port.write("sleep 1\n")
      m92.close()
      subprocess.call(["cu","-l",ser_dev,"-s","115200"])
   elif argv[1] in ["kill","exit","quit"]:
      m92.port.write("exit\n")
      print "Connection closed. You can stop or restart usb_dev_mode now."
   m92.close()
      
