// Additional options and functions from Analogus
// Initial version: 2012.03.06



tmp = function() 
{
	var LA, log, NAME, opt, dialog;
		
	NAME = "Analogus_Options";
	LA = Core.lang.getLocalizer("ANALOGUS");
	log = Core.log.getLogger(NAME);
	//dialog = kbook.model.getConfirmationDialog();

	//Akkusymbol aus/ein
	batteryData = function (type)	
		{
		switch (type) 
			{
			case 'ON':
				kbook.model.container.sandbox.STATUS_GROUP.sandbox.STATUS_GROUP_SUB.sandbox.STATUS_GROUP.sandbox.BATTERY_LEVEL.show(true);
				break;
			
			case 'OFF':
				kbook.model.container.sandbox.STATUS_GROUP.sandbox.STATUS_GROUP_SUB.sandbox.STATUS_GROUP.sandbox.BATTERY_LEVEL.show(false);
				break;
			}
		
		}	

	//System-Fonts (LRF, TXT, RTF)
	SystemfontData = function (font) 
	{
		switch (font) 
		{
			case 'Font1':
				Core.shell.exec('cp -f /Data/fonts/SysFont1/prsp.sh /Data/database/system/PRSPlus/prsp.sh');
				break ;
			case 'Font2':
				Core.shell.exec('cp -f /Data/fonts/SysFont2/prsp.sh /Data/database/system/PRSPlus/prsp.sh');
				break ;
			case 'Font3':
				Core.shell.exec('cp -f /Data/fonts/SysFont3/prsp.sh /Data/database/system/PRSPlus/prsp.sh');
				break ;
			case 'Font4':
				Core.shell.exec('cp -f /Data/fonts/SysFont4/prsp.sh /Data/database/system/PRSPlus/prsp.sh');
				break ;
			case 'FontSony':
				Core.shell.exec('cp -f /Data/fonts/SysFont0/prsp.sh /Data/database/system/PRSPlus/prsp.sh');
				break ;
		}
		//Restart:
		{
		switch (Core.config.model) 
			{
			case '350':
				Core.ui.showMsg(LA("MSG_RESTART_AUTO")); 
				ebook.setExitCode(5);
				kbook.model.doDeviceShutdown();	
				break;
			default:
				kbook.model.commitCache();
				Core.ui.showMsg(LA("MSG_RESTART_AUTO")); 
				kbook.bookData.setData(null);
				kbook.model.doDeviceShutdown();	
				break;
			}
		}
	}
	
	
	
//------------------------------------------------------------------------------------------------------------------------
	var Analogus_Options = 
	{
		name: NAME,
		title: LA("OPTIONS_ANALOGUS"),	
		icon: "LAUNCHER",
		optionDefs: [],
		onInit: function () 
			{
				opt = this.options;
			},
			
		actions: 
			[	
				//Auto-reboot:
				{
					name: "RestartReader",
					title: LA("RESTART_READER"),
					group: "PRS_DEVELOPER_TOOLS",
					icon: "BACK",
					action: function () 
					{
						switch (Core.config.model) 	//Model-Prfung
							{
							case '350':
								Core.ui.showMsg(LA("MSG_RESTART_AUTO")); 
								ebook.setExitCode(5);
								kbook.model.doDeviceShutdown();	
								break;
							default:
								//Dirty restart-mode (crashes reader to restart)
								kbook.model.commitCache();		//saves unsaved parts of the system cache befor crashing
								Core.ui.showMsg(LA("MSG_RESTART_AUTO")); 
								kbook.bookData.setData(null);
								kbook.model.doDeviceShutdown();	
							}
					}
				},
			],
	
	
	
	//----------------------------------------------------------------------------------------------------------------------------

		optionDefs:
		[
			{
				name: 'Battery',
				title: LA('OPTION_BATTERY_SYMBOL_ONOFF'),
				icon: 'BATTERY',
				defaultValue: 'ON',	
				values: ['ON', 'OFF'],
				valueTitles: {
					'ON': LA('OPTION_BATTERY_SYMBOL_ON'),
					'OFF': LA('OPTION_BATTERY_SYMBOL_OFF')}
			}, 
			
			{
				name: 'Systemfont',	
				title: LA('OPTION_SYSTEM_FONTS'),
				icon: 'FONT',
				defaultValue: 'NoOption',
				values: ['NoOption', 'Font1', 'Font2', 'Font3', 'Font4', 'FontSony'],
				valueTitles: 
					{
					'NoOption': LA('OPTION_NO_OPTION'), 
					'Font1': LA('ACTION_SYSTEM_FONT_1'),
					'Font2': LA('ACTION_SYSTEM_FONT_2'),
					'Font3': LA('ACTION_SYSTEM_FONT_3'), 
					'Font4': LA('ACTION_SYSTEM_FONT_4'), 
					'FontSony': LA('ACTION_SYSTEM_FONT_SONY')
					}
			}, 

		],
		
//----------------------------------------------------------------------------------------------------------
		
		onSettingsChanged: function (propertyName, oldValue, newValue, object) 
		{
			switch (propertyName) 
			{
				case 'Battery':
					if (newValue != 'NoOption')
						batteryData (newValue) ;
					opt.Save = 'NoOption' ;
					break; 
				case 'Systemfont':
					if (newValue != 'NoOption')
						SystemfontData (newValue) ;
					opt.Save = 'NoOption' ;
					break; 
			}
		}
	};

	Core.addAddon(Analogus_Options);
};


try 
{
	tmp();
} catch (e) 
{
	// Core's log
	log.error("in Analogus_Options.js", e);
}
