require "keys"
require "rfbkeys"

-- comment out the following line on a KDX
set_k3_keycodes()


-- variables client_width and client_height will be available when handleInput() is called
client_width = 0
client_height = 0

--[[
   you have also the following API functions:

   Quit( [status] )
      will quit the application. optional: return code (must be positive)

   SendKeyEvent( keyCode, pressed )
      sends a key event to the rfb server. "pressed" is a bool value
      telling whether the key was pressed (true) or released (false)

   SendPointerEvent( x, y, buttonMask )
      sends a pointer event to the rfb server
]]--


-- globals for remembering key state
shift = false
sym = false
alt = false
menu = false
back = false

--[[ Matching Matan's myts v7 keyboard
           Alt         1  2  3  4  5  6  7  8  9  0
                
           Key         q  w  e  r  t  y  u  i  o  p                 
                       a  s  d  f  g  h  j  k  l  <-               
                       z  x  c  v  b  n  m  .                       
                                                                    
           Shift       Q  W  E  R  T  Y  U  I  O  P                 
                       A  S  D  F  G  H  J  K  L  Del                
                       Z  X  C  V  B  N  M  .     
             
           Menu       F1 F2 F3 F4 F5 F6 F7 F8 F9  F10               
                       `  %  ^  <  >  [  ]  = F11 F12               
                      =>  ;  ,  (  )  {  }  ,                       
                                                                    
           Back        !  @  #  $  %  ^  &  *  (  )                 
                       *  +  #  -  _  (  )  &  !  ?                 
                       ~  $  |  /  \  "  '  :                       
                                                                    
           Sym         _  _  _  _  _  _  _  _  _  _                  
                       _  _  _  _  _  _  _  _  _  _                 
                       _  _  _  _  _  _  _  _                       
                                              
                      
           Special     Help 		Menu+Left<                   
                       Exit		Left<                        
                       Esc		Left>                        
                       Ctrl		aA                           
                       Enter		<-|                         
                       Home		Home                         
                       End 		Shift+Home                   
                       ScrollUp		Right<                       
                       ScrollDown	Right>                       
                       Up		Fw_Up                        
                       Down		Fw_Down                      
                       Left		Fw_Left                      
                       Right		Fw_Right                     
                       PgUp		Shift+Fw_Up                  
                       PgDown		Shift+Fw_Down
]]--

-- this handler will be called upon key presses (input events, actually)
function handleInput(channel, itype, code, value)
	print("input:", channel, itype, code, value)
	if itype == EV_KEY then
		local pressed = false
		if value == EVENT_VALUE_KEY_PRESS then
			pressed = true
		elseif value == EVENT_VALUE_KEY_RELEASE then
			pressed = false
		else
			return -- we don't know how to handle this.
		end

		-- will toggle state 
		if code == KEY_SYM then sym = pressed
		elseif code == KEY_SHIFT then shift = pressed
		elseif code == KEY_ALT then alt = pressed
		elseif code == KEY_MENU then menu = pressed
		elseif code == KEY_BACK then back = pressed

		-- alternate number keys on K3
		elseif alt and code == KEY_Q then SendKeyEvent(XK_1, pressed)
		elseif alt and code == KEY_W then SendKeyEvent(XK_2, pressed)
		elseif alt and code == KEY_E then SendKeyEvent(XK_3, pressed)
		elseif alt and code == KEY_R then SendKeyEvent(XK_4, pressed)
		elseif alt and code == KEY_T then SendKeyEvent(XK_5, pressed)
		elseif alt and code == KEY_Y then SendKeyEvent(XK_6, pressed)
		elseif alt and code == KEY_U then SendKeyEvent(XK_7, pressed)
		elseif alt and code == KEY_I then SendKeyEvent(XK_8, pressed)
		elseif alt and code == KEY_O then SendKeyEvent(XK_9, pressed)
		elseif alt and code == KEY_P then SendKeyEvent(XK_0, pressed)

		-- number keys, not present on K3
		elseif code == KEY_1 then SendKeyEvent(XK_1, pressed)
		elseif code == KEY_2 then SendKeyEvent(XK_2, pressed)
		elseif code == KEY_3 then SendKeyEvent(XK_3, pressed)
		elseif code == KEY_4 then SendKeyEvent(XK_4, pressed)
		elseif code == KEY_5 then SendKeyEvent(XK_5, pressed)
		elseif code == KEY_6 then SendKeyEvent(XK_6, pressed)
		elseif code == KEY_7 then SendKeyEvent(XK_7, pressed)
		elseif code == KEY_8 then SendKeyEvent(XK_8, pressed)
		elseif code == KEY_9 then SendKeyEvent(XK_9, pressed)
		elseif code == KEY_0 then SendKeyEvent(XK_0, pressed)

                -- upper case letter keys
		elseif shift and code == KEY_Q then SendKeyEvent(XK_Q, pressed)
		elseif shift and code == KEY_W then SendKeyEvent(XK_W, pressed)
		elseif shift and code == KEY_E then SendKeyEvent(XK_E, pressed)
		elseif shift and code == KEY_R then SendKeyEvent(XK_R, pressed)
		elseif shift and code == KEY_T then SendKeyEvent(XK_T, pressed)
		elseif shift and code == KEY_Y then SendKeyEvent(XK_Y, pressed)
		elseif shift and code == KEY_U then SendKeyEvent(XK_U, pressed)
		elseif shift and code == KEY_I then SendKeyEvent(XK_I, pressed)
		elseif shift and code == KEY_O then SendKeyEvent(XK_O, pressed)
		elseif shift and code == KEY_P then SendKeyEvent(XK_P, pressed)
		elseif shift and code == KEY_A then SendKeyEvent(XK_A, pressed)
		elseif shift and code == KEY_S then SendKeyEvent(XK_S, pressed)
		elseif shift and code == KEY_D then SendKeyEvent(XK_D, pressed)
		elseif shift and code == KEY_F then SendKeyEvent(XK_F, pressed)
		elseif shift and code == KEY_G then SendKeyEvent(XK_G, pressed)
		elseif shift and code == KEY_H then SendKeyEvent(XK_H, pressed)
		elseif shift and code == KEY_J then SendKeyEvent(XK_J, pressed)
		elseif shift and code == KEY_K then SendKeyEvent(XK_K, pressed)
		elseif shift and code == KEY_L then SendKeyEvent(XK_L, pressed)
		elseif shift and code == KEY_Z then SendKeyEvent(XK_Z, pressed)
		elseif shift and code == KEY_X then SendKeyEvent(XK_X, pressed)
		elseif shift and code == KEY_C then SendKeyEvent(XK_C, pressed)
		elseif shift and code == KEY_V then SendKeyEvent(XK_V, pressed)
		elseif shift and code == KEY_B then SendKeyEvent(XK_B, pressed)
		elseif shift and code == KEY_N then SendKeyEvent(XK_N, pressed)
		elseif shift and code == KEY_M then SendKeyEvent(XK_M, pressed)

		-- menu + keys
		elseif menu and code == KEY_Q then SendKeyEvent(XK_F1, pressed)
		elseif menu and code == KEY_W then SendKeyEvent(XK_F2, pressed)
		elseif menu and code == KEY_E then SendKeyEvent(XK_F3, pressed)
		elseif menu and code == KEY_R then SendKeyEvent(XK_F4, pressed)
		elseif menu and code == KEY_T then SendKeyEvent(XK_F5, pressed)
		elseif menu and code == KEY_Y then SendKeyEvent(XK_F6, pressed)
		elseif menu and code == KEY_U then SendKeyEvent(XK_F7, pressed)
		elseif menu and code == KEY_I then SendKeyEvent(XK_F8, pressed)
		elseif menu and code == KEY_O then SendKeyEvent(XK_F9, pressed)
		elseif menu and code == KEY_P then SendKeyEvent(XK_F10, pressed)
		elseif menu and code == KEY_A then SendKeyEvent(XK_grave, pressed)
		elseif menu and code == KEY_S then SendKeyEvent(XK_percent, pressed)
		elseif menu and code == KEY_D then SendKeyEvent(XK_asciicircum, pressed)
		elseif menu and code == KEY_F then SendKeyEvent(XK_less, pressed)
		elseif menu and code == KEY_G then SendKeyEvent(XK_greater, pressed)
		elseif menu and code == KEY_H then SendKeyEvent(XK_bracketleft, pressed)
		elseif menu and code == KEY_J then SendKeyEvent(XK_bracketright, pressed)
		elseif menu and code == KEY_K then SendKeyEvent(XK_equal, pressed)
		elseif menu and code == KEY_L then SendKeyEvent(XK_F11, pressed)
		elseif menu and code == KEY_DEL then SendKeyEvent(XK_F12, pressed)
		elseif menu and code == KEY_Z then SendKeyEvent(XK_Tab, pressed)
		elseif menu and code == KEY_X then SendKeyEvent(XK_semicolon, pressed)
		elseif menu and code == KEY_C then SendKeyEvent(XK_comma, pressed)
		elseif menu and code == KEY_V then SendKeyEvent(XK_parenleft, pressed)
		elseif menu and code == KEY_B then SendKeyEvent(XK_parenright, pressed)
		elseif menu and code == KEY_N then SendKeyEvent(XK_braceleft, pressed)
		elseif menu and code == KEY_M then SendKeyEvent(XK_braceright, pressed)
		elseif menu and code == KEY_DOT then SendKeyEvent(XK_comma, pressed)

		-- back + keys
		elseif back and code == KEY_Q then SendKeyEvent(XK_exclam, pressed)
		elseif back and code == KEY_W then SendKeyEvent(XK_at, pressed)
		elseif back and code == KEY_E then SendKeyEvent(XK_numbersign, pressed)
		elseif back and code == KEY_R then SendKeyEvent(XK_dollar, pressed)
		elseif back and code == KEY_T then SendKeyEvent(XK_percent, pressed)
		elseif back and code == KEY_Y then SendKeyEvent(XK_caret, pressed)
		elseif back and code == KEY_U then SendKeyEvent(XK_ampersand, pressed)
		elseif back and code == KEY_I then SendKeyEvent(XK_asterisk, pressed)
		elseif back and code == KEY_O then SendKeyEvent(XK_parenleft, pressed)
		elseif back and code == KEY_P then SendKeyEvent(XK_parenright, pressed)
		elseif back and code == KEY_A then SendKeyEvent(XK_asterisk, pressed)
		elseif back and code == KEY_S then SendKeyEvent(XK_plus, pressed)
		elseif back and code == KEY_D then SendKeyEvent(XK_numbersign, pressed)
		elseif back and code == KEY_F then SendKeyEvent(XK_minus, pressed)
		elseif back and code == KEY_G then SendKeyEvent(XK_underscore, pressed)
		elseif back and code == KEY_H then SendKeyEvent(XK_parenleft, pressed)
		elseif back and code == KEY_J then SendKeyEvent(XK_parenright, pressed)
		elseif back and code == KEY_K then SendKeyEvent(XK_ampersand, pressed)
		elseif back and code == KEY_L then SendKeyEvent(XK_exclam, pressed)
		elseif back and code == KEY_DEL then SendKeyEvent(XK_question, pressed)
		elseif back and code == KEY_Z then SendKeyEvent(XK_asciitilde, pressed)
		elseif back and code == KEY_X then SendKeyEvent(XK_dollar, pressed)
		elseif back and code == KEY_C then SendKeyEvent(XK_bar, pressed)
		elseif back and code == KEY_V then SendKeyEvent(XK_slash, pressed)
		elseif back and code == KEY_B then SendKeyEvent(XK_backslash, pressed)
		elseif back and code == KEY_N then SendKeyEvent(XK_quotedbl, pressed)
		elseif back and code == KEY_M then SendKeyEvent(XK_apostrophe, pressed)
		elseif back and code == KEY_DOT then SendKeyEvent(XK_colon, pressed)

		-- sym + keys
		--elseif sym and code == KEY_Q then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_W then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_E then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_R then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_T then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_Y then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_U then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_I then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_O then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_P then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_A then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_S then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_D then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_F then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_G then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_H then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_J then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_K then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_L then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_DEL then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_Z then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_X then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_C then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_V then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_B then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_N then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_M then SendKeyEvent(XK_, pressed)
		--elseif sym and code == KEY_DOT then SendKeyEvent(XK_, pressed)

		-- lower case letter keys
		elseif code == KEY_Q then SendKeyEvent(XK_q, pressed)
		elseif code == KEY_W then SendKeyEvent(XK_w, pressed)
		elseif code == KEY_E then SendKeyEvent(XK_e, pressed)
		elseif code == KEY_R then SendKeyEvent(XK_r, pressed)
		elseif code == KEY_T then SendKeyEvent(XK_t, pressed)
		elseif code == KEY_Y then SendKeyEvent(XK_y, pressed)
		elseif code == KEY_U then SendKeyEvent(XK_u, pressed)
		elseif code == KEY_I then SendKeyEvent(XK_i, pressed)
		elseif code == KEY_O then SendKeyEvent(XK_o, pressed)
		elseif code == KEY_P then SendKeyEvent(XK_p, pressed)
		elseif code == KEY_A then SendKeyEvent(XK_a, pressed)
		elseif code == KEY_S then SendKeyEvent(XK_s, pressed)
		elseif code == KEY_D then SendKeyEvent(XK_d, pressed)
		elseif code == KEY_F then SendKeyEvent(XK_f, pressed)
		elseif code == KEY_G then SendKeyEvent(XK_g, pressed)
		elseif code == KEY_H then SendKeyEvent(XK_h, pressed)
		elseif code == KEY_J then SendKeyEvent(XK_j, pressed)
		elseif code == KEY_K then SendKeyEvent(XK_k, pressed)
		elseif code == KEY_L then SendKeyEvent(XK_l, pressed)
		elseif code == KEY_Z then SendKeyEvent(XK_z, pressed)
		elseif code == KEY_X then SendKeyEvent(XK_x, pressed)
		elseif code == KEY_C then SendKeyEvent(XK_c, pressed)
		elseif code == KEY_V then SendKeyEvent(XK_v, pressed)
		elseif code == KEY_B then SendKeyEvent(XK_b, pressed)
		elseif code == KEY_N then SendKeyEvent(XK_n, pressed)
		elseif code == KEY_M then SendKeyEvent(XK_m, pressed)

		-- other keys
		elseif shift and code == KEY_DEL then SendKeyEvent(XK_Delete, pressed)
		elseif code == KEY_DEL then SendKeyEvent(XK_BackSpace, pressed)
		elseif code == KEY_DOT then SendKeyEvent(XK_period, pressed)
		elseif code == KEY_SLASH then SendKeyEvent(XK_slash, pressed)
		elseif code == KEY_ENTER then SendKeyEvent(XK_Return, pressed)
		elseif code == KEY_SPACE then SendKeyEvent(XK_space, pressed)
		elseif code == KEY_ALT then SendKeyEvent(XK_Alt_L, pressed)
		elseif code == KEY_AA then SendKeyEvent(XK_Control_L, pressed)

		-- special keys
		--elseif code == KEY_VPLUS then SendKeyEvent(XK_, pressed)
		--elseif code == KEY_VMINUS then SendKeyEvent(XK_, pressed)
		elseif code == KEY_LPGBCK then Quit()
		elseif shift and code == KEY_HOME then SendKeyEvent(XK_End, pressed)
		elseif code == KEY_HOME then SendKeyEvent(XK_Home, pressed)
		elseif code == KEY_LPGFWD then SendKeyEvent(XK_Escape, pressed)
		--elseif code == KEY_PGFWD then SendKeyEvent(XK_, pressed)
		--elseif code == KEY_PGBCK then SendKeyEvent(XK_, pressed)
		elseif code == KEY_FW_LEFT then SendKeyEvent(XK_Left, pressed)
		elseif code == KEY_FW_RIGHT then SendKeyEvent(XK_Right, pressed)
		elseif shift and code == KEY_FW_UP then SendKeyEvent(XK_Page_Up, pressed)
		elseif code == KEY_FW_UP then SendKeyEvent(XK_Up, pressed)
		elseif shift and code == KEY_FW_DOWN then SendKeyEvent(XK_Page_Down, pressed)
		elseif code == KEY_FW_DOWN then SendKeyEvent(XK_Down, pressed)
		elseif code == KEY_FW_PRESS then SendKeyEvent(XK_Return, pressed)
		end
	end
end
