#!/bin/sh

# Ehh.. 

_BLANKET_LIPC_NAME="com.lab126.blanket"
_BLANKET_LIPC_LOAD="load"

source /etc/upstart/env
source /etc/upstart/functions
source /etc/upstart/blanket_functions

LIST_PATH="/mnt/us/extensions/screensaver/bin"

if [  -f "$LIST_PATH/list_modules" ]; then
	echo list_modules was created before... 
else
	MODULE_LIST=$(lipc-get-prop $_BLANKET_LIPC_NAME $_BLANKET_LIPC_LOAD -s)
	echo $MODULE_LIST 
	echo $MODULE_LIST > $LIST_PATH/list_modules
fi  

blanket_module_load() {
    local MODULE= $1
    MODULE_LIST=$(lipc-get-prop $_BLANKET_LIPC_NAME $_BLANKET_LIPC_LOAD -s)
    for M in $MODULE_LIST; do
        if [ "$M" == "$1" ]; then
            echo module $1 was loaded before...  
            return;
        fi
    done
    echo Load module  $1
    f_blanket_load_module $1
}
 
blanket_module_unload() {
    local MODULE= $1
    MODULE_LIST=$(lipc-get-prop $_BLANKET_LIPC_NAME $_BLANKET_LIPC_LOAD -s)
    for M in $MODULE_LIST; do
        if [ "$M" == "$1" ]; then
	     echo Unload module $1
	     f_blanket_unload_module $1
            return;
        fi
    done
    echo $1 was not loaded before...
}
 

case "$1" in
"E")
	blanket_module_load screensaver
	blanket_module_load ad_screensaver
        ;;
"D")
	MODULE_LIST=$(lipc-get-prop $_BLANKET_LIPC_NAME $_BLANKET_LIPC_LOAD -s)
	echo $MODULE_LIST > list_modules

	blanket_module_unload screensaver
	blanket_module_unload ad_screensaver
        ;;
esac



