#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai

import sys, os
from smartypants import smartyPants

def main(argv=sys.argv):
	print len(argv)
	if len(argv) < 3:
		print "Usage:"
		print "  smarty-wrapper.py infile outfile"
		return 1
	else:  
		if len(argv) > 3:
			print 'smarty-wrapper.py takes exactly two arguments: infile outfile'
		else:
			infile, outfile = argv[1:]
			if not os.path.isfile(infile):
				print '%s does not exist!' % str(infile)
				return 1
			f = file(infile, 'rb').read()
			sp = smartyPants(f)
			file(outfile, 'wb').write(sp)

if __name__ == "__main__":
	sys.exit(main())