#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2012, Ramin & Irmgard Sabet'
__docformat__ = 'restructuredtext en'

if False:
    # This is here to keep my python error checker from complaining about
    # the builtin functions that will be defined by the plugin loading system
    # You do not need this code in your plugins
    get_icons = get_resources = None

from PyQt4.Qt import QDialog, QVBoxLayout, QHBoxLayout, QPushButton, QCheckBox, QTimer
from PyQt4.Qt import QMessageBox, QLabel, QTextEdit, QTableWidget, QTableWidgetItem, QLineEdit
from PyQt4.Qt import QPixmap

from PyQt4 import QtGui, QtCore
from calibre.gui2.complete import MultiCompleteComboBox, MultiCompleteLineEdit


from calibre_plugins.merge_tags.config import prefs
import cStringIO

rowHeight = 96
maxBooks = 100

def_image = get_icons('images/default_cover.png')
def_image = def_image.pixmap(def_image.availableSizes()[0])

class ImageTableWidgetItem(QtGui.QLabel):

    def __init__(self, parent=None, imagePath=None):
        super(ImageTableWidgetItem, self).__init__(parent)
        if imagePath is None:
            pic = def_image
        else:
            pic = QtGui.QPixmap(imagePath)
        self.setPixmap(pic.scaledToHeight(rowHeight,QtCore.Qt.SmoothTransformation)) 

class StrCaseInsensitiveTableWidgetItem(QtGui.QTableWidgetItem):
    def __init__(self, text, sortKey):
        QtGui.QTableWidgetItem.__init__(self, text, QtGui.QTableWidgetItem.UserType)
        self.sortKey = sortKey

    def __lt__(self, other):
        return self.sortKey < other.sortKey


class NumTableWidgetItem(QtGui.QTableWidgetItem):
    def __init__(self, text):
        QtGui.QTableWidgetItem.__init__(self, text)

    def __lt__(self, other):
        return int(str(self.text())) < int(str(other.text()))


class KeyTableWidget(QTableWidget):

    def __init__(self, parent=None):
        QTableWidget.__init__(self, parent)
        self.parent = parent

    def keyPressEvent(self, event):
        print (event.key())
        if event.key() == QtCore.Qt.Key_Delete:
            self.parent.onDeleteTags()
        return QTableWidget.keyPressEvent(self, event)

    def contextMenuEvent(self, event):
        menu = QtGui.QMenu(self)
        selAllAction = menu.addAction("Select &All")
        selNoneAction = menu.addAction("Select &None")
        menu.addSeparator()
        delAction = menu.addAction("&Delete")
        if len(self.parent.getSelectedRows()) == 0:
            delAction.setEnabled(False)
        action = menu.exec_(self.mapToGlobal(event.pos()))
        if action == delAction:
            self.parent.onDeleteTags()
        elif action == selAllAction:
            self.parent.onSelectAll()
        elif action == selNoneAction:
            self.parent.onSelectNone()



class DemoDialog(QDialog):

    def __init__(self, gui, icon, do_user_config):
        QDialog.__init__(self, gui)
        self.gui = gui
        self.do_user_config = do_user_config

        self.db = gui.current_db

        _fromUtf8 = lambda s: s
        Dialog = self
        self.getTags()
        Dialog.resize(600, 600)
        ####################
        Dialog.setSizeGripEnabled(True)
        Dialog.setModal(True)
        self.horizontalLayout_7 = QtGui.QHBoxLayout(Dialog)
        self.horizontalLayout_7.setObjectName(_fromUtf8("horizontalLayout_7"))
        self.splitter = QtGui.QSplitter(Dialog)
        sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.splitter.sizePolicy().hasHeightForWidth())
        self.splitter.setSizePolicy(sizePolicy)
        self.splitter.setMinimumSize(QtCore.QSize(839, 0))
        self.splitter.setLineWidth(3)
        self.splitter.setOrientation(QtCore.Qt.Horizontal)
        self.splitter.setObjectName(_fromUtf8("splitter"))
        self.widget = QtGui.QWidget(self.splitter)
        self.widget.setObjectName(_fromUtf8("widget"))
        self.gridLayout = QtGui.QGridLayout(self.widget)
        self.gridLayout.setMargin(0)
        self.gridLayout.setObjectName(_fromUtf8("gridLayout"))
        self.label = QtGui.QLabel(self.widget)
        self.label.setText(QtGui.QApplication.translate("Dialog", "Filter Tags", None, QtGui.QApplication.UnicodeUTF8))
        self.label.setObjectName(_fromUtf8("label"))
        self.gridLayout.addWidget(self.label, 0, 0, 1, 1)
        self.horizontalLayout = QtGui.QHBoxLayout()
        self.horizontalLayout.setObjectName(_fromUtf8("horizontalLayout"))
        self.gridLayout.addLayout(self.horizontalLayout, 1, 2, 1, 1)
        self.tbl = KeyTableWidget(self.widget)
        sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Expanding)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.tbl.sizePolicy().hasHeightForWidth())
        self.tbl.setSizePolicy(sizePolicy)
        palette = QtGui.QPalette()
        brush = QtGui.QBrush(QtGui.QColor(51, 153, 255))
        brush.setStyle(QtCore.Qt.SolidPattern)
        palette.setBrush(QtGui.QPalette.Active, QtGui.QPalette.Highlight, brush)
        brush = QtGui.QBrush(QtGui.QColor(0, 170, 255))
        brush.setStyle(QtCore.Qt.SolidPattern)
        palette.setBrush(QtGui.QPalette.Inactive, QtGui.QPalette.Highlight, brush)
        brush = QtGui.QBrush(QtGui.QColor(51, 153, 255))
        brush.setStyle(QtCore.Qt.SolidPattern)
        palette.setBrush(QtGui.QPalette.Disabled, QtGui.QPalette.Highlight, brush)
        self.tbl.setPalette(palette)
        self.tbl.setAlternatingRowColors(True)
        self.tbl.setSelectionMode(QtGui.QAbstractItemView.ExtendedSelection)
        self.tbl.setSelectionBehavior(QtGui.QAbstractItemView.SelectRows)
        self.tbl.setObjectName(_fromUtf8("tbl"))
        self.tbl.setColumnCount(0)
        self.tbl.setRowCount(0)
        self.tbl.horizontalHeader().setVisible(True)
        self.tbl.horizontalHeader().setSortIndicatorShown(True)
        self.tbl.horizontalHeader().setStretchLastSection(False)
        self.tbl.verticalHeader().setVisible(True)
        self.tbl.verticalHeader().setCascadingSectionResizes(False)
        self.tbl.verticalHeader().setSortIndicatorShown(False)
        self.tbl.verticalHeader().setStretchLastSection(False)
        self.gridLayout.addWidget(self.tbl, 3, 2, 1, 1)
        self.label_2 = QtGui.QLabel(self.widget)
        self.label_2.setText(QtGui.QApplication.translate("Dialog", "New Tag(s)", None, QtGui.QApplication.UnicodeUTF8))
        self.label_2.setObjectName(_fromUtf8("label_2"))
        self.gridLayout.addWidget(self.label_2, 5, 0, 1, 1)
        self.horizontalLayout_2 = QtGui.QHBoxLayout()
        self.horizontalLayout_2.setObjectName(_fromUtf8("horizontalLayout_2"))
        self.txtNewTags = MultiCompleteLineEdit(self.widget)
        self.txtNewTags.setToolTip(QtGui.QApplication.translate("Dialog", "Enter comma separated list of Tag names which will be written to the books containing the selected tasks", None, QtGui.QApplication.UnicodeUTF8))
        self.txtNewTags.setPlaceholderText(QtGui.QApplication.translate("Dialog", "Enter comma separated new tags", None, QtGui.QApplication.UnicodeUTF8))
        self.txtNewTags.setObjectName(_fromUtf8("txtNewTags"))
        self.horizontalLayout_2.addWidget(self.txtNewTags)
        self.btnReTag = QtGui.QPushButton(self.widget)
        self.btnReTag.setEnabled(False)
        self.btnReTag.setToolTip(QtGui.QApplication.translate("Dialog", "Replace selected Tags by New Tags", None, QtGui.QApplication.UnicodeUTF8))
        self.btnReTag.setText(QtGui.QApplication.translate("Dialog", "&Replace Tags", None, QtGui.QApplication.UnicodeUTF8))
        self.btnReTag.setObjectName(_fromUtf8("btnReTag"))
        self.horizontalLayout_2.addWidget(self.btnReTag)
        self.gridLayout.addLayout(self.horizontalLayout_2, 5, 2, 1, 1)
        self.horizontalLayout_3 = QtGui.QHBoxLayout()
        self.horizontalLayout_3.setSpacing(0)
        self.horizontalLayout_3.setObjectName(_fromUtf8("horizontalLayout_3"))
        self.txtFilter = QtGui.QLineEdit(self.widget)
        self.txtFilter.setToolTip(QtGui.QApplication.translate("Dialog", "Enter minimum of two letters to filter the tag list", None, QtGui.QApplication.UnicodeUTF8))
        self.txtFilter.setPlaceholderText(QtGui.QApplication.translate("Dialog", "Enter part of tag name to filter (min 2 letters)", None, QtGui.QApplication.UnicodeUTF8))
        self.txtFilter.setObjectName(_fromUtf8("txtFilter"))
        self.horizontalLayout_3.addWidget(self.txtFilter)
        self.btnDeleteFilter = QtGui.QToolButton(self.widget)
        self.btnDeleteFilter.setText(QtGui.QApplication.translate("Dialog", "X", None, QtGui.QApplication.UnicodeUTF8))
        self.btnDeleteFilter.setObjectName(_fromUtf8("btnDeleteFilter"))
        self.horizontalLayout_3.addWidget(self.btnDeleteFilter)
        self.btnShowBooks = QtGui.QToolButton(self.widget)
        self.btnShowBooks.setText(QtGui.QApplication.translate("Dialog", ">", None, QtGui.QApplication.UnicodeUTF8))
        self.btnShowBooks.setArrowType(QtCore.Qt.NoArrow)
        self.btnShowBooks.setObjectName(_fromUtf8("btnShowBooks"))
        self.horizontalLayout_3.addWidget(self.btnShowBooks)
        self.gridLayout.addLayout(self.horizontalLayout_3, 0, 2, 1, 1)
        self.horizontalLayout_4 = QtGui.QHBoxLayout()
        self.horizontalLayout_4.setObjectName(_fromUtf8("horizontalLayout_4"))
        spacerItem = QtGui.QSpacerItem(40, 20, QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.horizontalLayout_4.addItem(spacerItem)
        self.btnDelete = QtGui.QPushButton(self.widget)
        self.btnDelete.setEnabled(False)
        self.btnDelete.setToolTip(QtGui.QApplication.translate("Dialog", "Delete selected Tags", None, QtGui.QApplication.UnicodeUTF8))
        self.btnDelete.setText(QtGui.QApplication.translate("Dialog", "&Delete", None, QtGui.QApplication.UnicodeUTF8))
        self.btnDelete.setObjectName(_fromUtf8("btnDelete"))
        self.horizontalLayout_4.addWidget(self.btnDelete)
        self.gridLayout.addLayout(self.horizontalLayout_4, 4, 2, 1, 1)
        self.horizontalLayout_5 = QtGui.QHBoxLayout()
        self.horizontalLayout_5.setObjectName(_fromUtf8("horizontalLayout_5"))
        spacerItem1 = QtGui.QSpacerItem(0, 0, QtGui.QSizePolicy.Preferred, QtGui.QSizePolicy.Minimum)
        self.horizontalLayout_5.addItem(spacerItem1)
        self.verticalLayout_2 = QtGui.QVBoxLayout()
        self.verticalLayout_2.setObjectName(_fromUtf8("verticalLayout_2"))
        spacerItem2 = QtGui.QSpacerItem(20, 40, QtGui.QSizePolicy.Minimum, QtGui.QSizePolicy.Expanding)
        self.verticalLayout_2.addItem(spacerItem2)
        self.btnSelectAll = QtGui.QToolButton(self.widget)
        self.btnSelectAll.setMinimumSize(QtCore.QSize(32, 32))
        self.btnSelectAll.setToolTip(QtGui.QApplication.translate("Dialog", "Select all items in the Tags list", None, QtGui.QApplication.UnicodeUTF8))
        self.btnSelectAll.setText(QtGui.QApplication.translate("Dialog", "...", None, QtGui.QApplication.UnicodeUTF8))
        self.btnSelectAll.setIconSize(QtCore.QSize(32, 32))
        self.btnSelectAll.setObjectName(_fromUtf8("btnSelectAll"))
        self.verticalLayout_2.addWidget(self.btnSelectAll)
        self.btnSelectNone = QtGui.QToolButton(self.widget)
        self.btnSelectNone.setMinimumSize(QtCore.QSize(32, 32))
        self.btnSelectNone.setToolTip(QtGui.QApplication.translate("Dialog", "Deselect all items in the tag list", None, QtGui.QApplication.UnicodeUTF8))
        self.btnSelectNone.setText(QtGui.QApplication.translate("Dialog", "...", None, QtGui.QApplication.UnicodeUTF8))
        self.btnSelectNone.setIconSize(QtCore.QSize(32, 32))
        self.btnSelectNone.setObjectName(_fromUtf8("btnSelectNone"))
        self.verticalLayout_2.addWidget(self.btnSelectNone)
        spacerItem3 = QtGui.QSpacerItem(20, 40, QtGui.QSizePolicy.Minimum, QtGui.QSizePolicy.Expanding)
        self.verticalLayout_2.addItem(spacerItem3)
        self.horizontalLayout_5.addLayout(self.verticalLayout_2)
        spacerItem4 = QtGui.QSpacerItem(0, 0, QtGui.QSizePolicy.Preferred, QtGui.QSizePolicy.Minimum)
        self.horizontalLayout_5.addItem(spacerItem4)
        self.gridLayout.addLayout(self.horizontalLayout_5, 3, 0, 1, 1)
        self.dockWidget = QtGui.QDockWidget(self.splitter)
        sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Preferred, QtGui.QSizePolicy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.dockWidget.sizePolicy().hasHeightForWidth())
        self.dockWidget.setSizePolicy(sizePolicy)
        self.dockWidget.setBaseSize(QtCore.QSize(0, 0))
        self.dockWidget.setFloating(False)
        self.dockWidget.setFeatures(QtGui.QDockWidget.DockWidgetClosable|QtGui.QDockWidget.DockWidgetMovable)
        self.dockWidget.setWindowTitle(QtGui.QApplication.translate("Dialog", "Books containg selected Tag", None, QtGui.QApplication.UnicodeUTF8))
        self.dockWidget.setObjectName(_fromUtf8("dockWidget"))
        self.dockWidgetContents = QtGui.QWidget()
        self.dockWidgetContents.setObjectName(_fromUtf8("dockWidgetContents"))
        self.verticalLayout_4 = QtGui.QVBoxLayout(self.dockWidgetContents)
        self.verticalLayout_4.setSpacing(6)
        self.verticalLayout_4.setContentsMargins(0, 4, 0, 0)
        self.verticalLayout_4.setObjectName(_fromUtf8("verticalLayout_4"))
        self.verticalLayout_3 = QtGui.QVBoxLayout()
        self.verticalLayout_3.setObjectName(_fromUtf8("verticalLayout_3"))
        self.tblBooks = QtGui.QTableWidget(self.dockWidgetContents)
        self.tblBooks.setAlternatingRowColors(True)
        self.tblBooks.setColumnCount(3)
        self.tblBooks.setObjectName(_fromUtf8("tblBooks"))
        self.tblBooks.setRowCount(0)
        self.verticalLayout_3.addWidget(self.tblBooks)
        self.verticalLayout_4.addLayout(self.verticalLayout_3)
        self.dockWidget.setWidget(self.dockWidgetContents)
        self.horizontalLayout_7.addWidget(self.splitter)
        ####################

        self.btnShowBooks.setVisible(False)
        self.btnShowBooks.clicked.connect(self.onShowBooks)
        self.dockWidget.visibilityChanged.connect(self.onDock)
        
        self.tblBooks.setRowCount(0)
        self.tblBooks.setColumnCount(3)
        self.tblBooks.horizontalHeader().setResizeMode(1, QtGui.QHeaderView.Stretch)
        self.tblBooks.setHorizontalHeaderLabels(('','Title', 'Authors'))
        self.tblBooks.horizontalHeader().setResizeMode(0, QtGui.QHeaderView.ResizeToContents)
        
        self.btnSelectNone.setIcon(get_icons('images/select_none.png'))
        self.btnSelectAll.setIcon(get_icons('images/select_all.png'))
        self.btnDeleteFilter.setIcon(get_icons('images/delete16.png'))
        self.btnShowBooks.setIcon(get_icons('images/arrow-right-circle.png'))
        self.tbl.setColumnCount(3)
        self.tbl.hideColumn(2)
        self.tbl.cellChanged.connect(self.cellChanged)
        self.tbl.horizontalHeader().setResizeMode(0, QtGui.QHeaderView.Stretch)
        self.tbl.horizontalHeader().sortIndicatorChanged.connect(self.onSortIndicatorChanged)
        self.txtNewTags.update_items_cache(self.db.all_tags())
        self.txtNewTags.textChanged.connect(self.manageEnable)
        self.txtFilter.textChanged.connect(self.OnFilterTags)
        self.btnDeleteFilter.clicked.connect(self.onClearFilter)
        self.btnReTag.clicked.connect(self.onReplaceTags)
        self.btnDelete.clicked.connect(self.onDeleteTags)
        self.btnSelectAll.clicked.connect(self.onSelectAll)
        self.btnSelectNone.clicked.connect(self.onSelectNone)
        self.tbl.setHorizontalHeaderLabels(('Tag', 'Count'))
        self.tbl.itemSelectionChanged.connect(self.onTblSelChange)
        self.tbl.setSortingEnabled(True)
        self.setWindowTitle('Merge Tags')
        self.setWindowIcon(icon)
        self.lastFilteredText = ''

        #self.cursor = QCursor(Qt.WaitCursor)
        QTimer.singleShot(0, self.delayedInit)

    def onShowBooks(self):
        self.dockWidget.setVisible(True)
        self.onTblSelChange()

    def onDock(self, bVisible):
        self.btnShowBooks.setVisible(not bVisible)
        
    def getTags(self):
        db = self.db
        arTags = self.db.get_tags_with_ids()
        print('got tags')
        arTags = [(tag[1], len(db.get_books_for_category('tags', tag[0])), tag[0]) for tag in arTags]
        print('count tags before clean', len(arTags))
        self.arTags = [tag for tag in arTags if tag[1] > 0]
        print('count tags', len(self.arTags))

    def delayedInit(self):
        self.tbl.sortByColumn(0, 0)
        self.populateTable()

    def doSort(self, column):
        self.lastSortColumn = column
        ar = [(i[column], i) for i in self.arTags]
        ar.sort()
        self.arTags = [i[1] for i in ar]

    def onSortIndicatorChanged(self, colIdx, order):
        if colIdx < 2:
            self.doSort(colIdx)
            if order == 1:
                self.arTags.reverse()

    def populateTable(self, strFilter=''):
        self.tbl.cellChanged.disconnect()
        self.tbl.clearContents()
        if strFilter:
            print('filtering')
            strFilterLower = unicode(strFilter).lower()
            self.FilteredTags = [i for i in self.arTags if strFilterLower in i[0].lower()]
        else:
            self.FilteredTags = self.arTags
        print('filteredtags')
        self.tbl.setRowCount(len(self.FilteredTags))
        for row, tag in enumerate(self.FilteredTags):
            #print (tag)
            tag, cnt, idx = tag
            item = NumTableWidgetItem('%d' % cnt)
            item.setFlags(item.flags() & ~QtCore.Qt.ItemIsEditable)
            self.tbl.setItem(row, 2, QTableWidgetItem('%d' % idx))
            if self.lastSortColumn == 0:
                self.tbl.setItem(row, 1, item)
                self.tbl.setItem(row, 0, StrCaseInsensitiveTableWidgetItem(tag, tag.lower()))
            else:
                self.tbl.setItem(row, 0, StrCaseInsensitiveTableWidgetItem(tag, tag.lower()))
                self.tbl.setItem(row, 1, item)
        self.tbl.cellChanged.connect(self.cellChanged)
        print('filled')

    def OnFilterTags(self):
        #print(self.txtFilter.text())
        if len(self.txtFilter.text()) > 1:
            self.populateTable(self.txtFilter.text())
            self.lastFilteredText = self.txtFilter.text()
        else:
            if len(self.lastFilteredText) > 1:
                self.populateTable()
                self.lastFilteredText = ''

    def getSelectedRows(self):
        return [i.row() for i in self.tbl.selectionModel().selectedRows()]

    def onReplaceTags(self):
        arBooks = set()
        arRemoveTags = set()
        arIdx = self.getSelectedRows()
        #print(arIdx)
        for row in arIdx:
            tag = unicode(self.tbl.item(row, 0).text())
            tag_idx = None
            for i in self.arTags:
                if i[0] == tag:
                    tag_idx = i[2]
                    ####self.arTags.remove(i)
                    break
            arRemoveTags.add(tag)
            #print(tag,tag_idx)
            bks = self.db.get_books_for_category('tags', tag_idx)
            #print(bks)
            for i in bks:
                arBooks.add(i)
            #print(tag)
        #print('arBooks', arBooks)
        #print('arRemoveTags',arRemoveTags)
        self.bulk_modify_tags(unicode(self.txtNewTags.text()), arBooks, arRemoveTags)
        #self.db.bulk_modify_tags(arBooks, add=str(self.txtNewTags.text()).split(','), remove=arRemoveTags, notify=True)
        #self.getTags()
        #self.populateTable(self.txtFilter.text())
        #self.gui.library_view.model().refresh_ids(arBooks)
        #self.gui.tags_view.recount()

    def onDeleteTags(self):
        arIdx = self.getSelectedRows()
        strMessage = 'Do you want to remove the following tag(s) from the books:\n'
        for row in arIdx:
            strMessage += 5 * ' ' + unicode(self.tbl.item(row, 0).text()) + '\n'

        if self.YesNo(title='Confirm Delete', message=strMessage):
            arBooks = []
            for row in arIdx:
                tag = unicode(self.tbl.item(row, 0).text())
                tag_idx = None
                for i in self.arTags:
                    if i[0] == tag:
                        tag_idx = i[2]
                        self.arTags.remove(i)
                        break
                #print(tag,tag_idx)
                bks = self.db.get_books_for_category('tags', tag_idx)
                #print(bks)
                for i in bks:
                    arBooks.append(i)
                #print(tag)
                self.db.delete_tag(tag)
            self.gui.library_view.model().refresh_ids(arBooks)
            self.gui.tags_view.recount()
            #print('arBooks',arBooks)
            mi = self.db.get_metadata(arBooks[0], index_is_id=True)
            #print(mi.title)
            arIdx.sort()
            arIdx.reverse()
            for row in arIdx:
                self.tbl.removeRow(row)

    def manageEnable(self):
        if len(self.getSelectedRows()) == 0:
            self.btnReTag.setEnabled(False)
            self.btnDelete.setEnabled(False)
        else:
            if len(self.txtNewTags.text()):
                self.btnReTag.setEnabled(True)
            else:
                self.btnReTag.setEnabled(False)
            self.btnDelete.setEnabled(True)


    def onTblSelChange(self):
        self.manageEnable()
        if self.dockWidget.isVisible():
            rows = self.getSelectedRows()
            self.tblBooks.clearContents()
            count = 0
            bTruncated = False
            if len(rows):
                arBooks = set()
                for row in rows:
                    tag_idx = int(self.tbl.item(row, 2).text())
                    #print('tag_idx',tag_idx)
                    for book in self.db.get_books_for_category('tags', tag_idx):
                        count += 1
                        if count >= maxBooks - 1:
                            bTruncated = True
                            break
                        arBooks.add(book)
                    if bTruncated:
                        break
                arBooks = list(arBooks)
                self.tblBooks.setRowCount(len(arBooks))
                for pos, book_idx in enumerate(arBooks):
                    mi = self.db.get_metadata(book_idx, index_is_id=True,get_cover=True)
                    strAuthors = ' & '.join(mi.authors)
                    self.tblBooks.setRowHeight(pos, rowHeight)
                    self.tblBooks.setItem(pos, 1, QTableWidgetItem(mi.title))
                    self.tblBooks.setItem(pos, 2, QTableWidgetItem(strAuthors))
                    self.tblBooks.setCellWidget(pos, 0, ImageTableWidgetItem(self, mi.cover))
                if bTruncated:
                    self.tblBooks.setItem(pos + 1, 1, QTableWidgetItem('... more than %d ...' % maxBooks))
                self.tblBooks.horizontalHeader().setResizeMode(0, QtGui.QHeaderView.ResizeToContents)                    
            else:
                self.tblBooks.setRowCount(0)

    def onClearFilter(self):
        self.txtFilter.clear()

    def onSelectAll(self):
        self.tbl.selectAll()
        self.tbl.setFocus()

    def onSelectNone(self):
        self.tbl.clearSelection()

    def cellChanged(self, row, column):
        #idx = int(self.tbl.item(row, 2).text())
        #new_name = unicode(self.tbl.item(row, column).text()).strip()
        #self.db.rename_tag(idx, new_name)
        #for pos, tag in enumerate(self.arTags):
            #if tag[2] == idx:
                #newtag = (new_name, tag[1], tag[2])
                #self.arTags[pos] = newtag
                #break
        #self.db.refresh()
        #bks = self.db.get_books_for_category('tags', idx)
        #self.gui.library_view.model().refresh_ids(bks)
        #self.gui.tags_view.recount()
        #self.gui.library_view.refresh_book_details()

        arRemoveTags = []
        idx = int(self.tbl.item(row, 2).text())
        #print('idx=',idx)
        for tag in self.arTags:
            if tag[2] == idx:
                arRemoveTags = [tag[0]]
                break
        new_name = unicode(self.tbl.item(row, column).text()).strip()
        arBooks = self.db.get_books_for_category('tags', idx)
        self.bulk_modify_tags(new_name, arBooks, arRemoveTags)

    def bulk_modify_tags(self, new_name, arBooks, arRemoveTags):
        print('bulk_modify_tags',new_name,arBooks,arRemoveTags)
        self.db.bulk_modify_tags(arBooks, add=new_name.split(','), remove=arRemoveTags, notify=True)
        self.db.refresh()
        self.getTags()
        self.populateTable(self.txtFilter.text())        
        #self.gui.library_view.model().refresh_ids(arBooks)
        #self.gui.tags_view.recount()
        #self.gui.library_view.refresh_book_details()


    def about(self):
        # Get the about text from a file inside the plugin zip file
        # The get_resources function is a builtin function defined for all your
        # plugin code. It loads files from the plugin zip file. It returns
        # the bytes from the specified file.
        #
        # Note that if you are loading more than one file, for performance, you
        # should pass a list of names to get_resources. In this case,
        # get_resources will return a dictionary mapping names to bytes. Names that
        # are not found in the zip file will not be in the returned dictionary.
        text = get_resources('about.txt')
        QMessageBox.about(self, 'About the Merge Duplicates Plugin',
                text.decode('utf-8'))

    def YesNo(self, title, message):
        reply = QtGui.QMessageBox.question(self, title,
            message, QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
        return reply == QtGui.QMessageBox.Yes

    def config(self):
        self.do_user_config(parent=self)
        # Apply the changes
        ##self.label.setText(prefs['hello_world_msg'])
        return
