#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2012, Pr.BarnArt, based on the Barnes work by Grant Drake'
__docformat__ = 'restructuredtext en'

from PyQt4 import QtGui
from PyQt4.Qt import QLabel, QGridLayout, Qt, QGroupBox, QCheckBox
from calibre.gui2.metadata.config import ConfigWidget as DefaultConfigWidget
from calibre.utils.config import JSONConfig

STORE_NAME = 'Options'
KEY_MAX_DOWNLOADS = 'maxDownloads'
KEY_RECENSIES_BOL= 'get also recensies if available from comments bol.nl'
KEY_GET_LP_COVERS = 'get covers from literatuurplein.nl if available'
KEY_GET_LPONLY_COVERS = 'get only covers from iteratuurplein.nl, not from bol'

DEFAULT_STORE_VALUES = {
    KEY_MAX_DOWNLOADS: 1,
	KEY_RECENSIES_BOL: True,
	KEY_GET_LP_COVERS: False,
	KEY_GET_LPONLY_COVERS: False
}

# This is where all preferences for this plugin will be stored
plugin_prefs = JSONConfig('plugins/BOL_NL')

# Set defaults
plugin_prefs.defaults[STORE_NAME] = DEFAULT_STORE_VALUES


class ConfigWidget(DefaultConfigWidget):

    def __init__(self, plugin):
        DefaultConfigWidget.__init__(self, plugin)
        c = plugin_prefs[STORE_NAME]

        other_group_box = QGroupBox('Other options', self)
        self.l.addWidget(other_group_box, self.l.rowCount(), 0, 1, 2)
        other_group_box_layout = QGridLayout()
        other_group_box.setLayout(other_group_box_layout)

        max_label = QLabel('Maximum title/author search matches to evaluate (1 = fastest):', self)
        max_label.setToolTip('BOL.com do not always have links to large covers for every ISBN\n'
                             'of the same book. Increasing this value will take effect when doing\n'
                             'title/author searches to consider more ISBN editions.\n\n'
                             'This will increase the potential likelihood of getting a larger cover\n'
                             'though does not guarantee it.')
        other_group_box_layout.addWidget(max_label, 0, 0, 1, 1)
        self.max_downloads_spin = QtGui.QSpinBox(self)
        self.max_downloads_spin.setMinimum(1)
        self.max_downloads_spin.setMaximum(5)
        self.max_downloads_spin.setProperty('value', c.get(KEY_MAX_DOWNLOADS, DEFAULT_STORE_VALUES[KEY_MAX_DOWNLOADS]))
        other_group_box_layout.addWidget(self.max_downloads_spin, 0, 1, 1, 1)
        other_group_box_layout.setColumnStretch(2, 1)
		
		self.recensies_bol_checkbox = QCheckBox('Get besides the description also reviews from BOL.NL if available', self)
        self.recensies_bol_checkbox.setToolTip('If unchecked you get only the description of BOL.nl. Default is Checked.')
        self.recensies_bol_checkbox.setChecked(c.get(KEY_RECENSIES_BOL, DEFAULT_STORE_VALUES[KEY_RECENSIES_BOL]))
        other_group_box_layout.addWidget(self.recensies_bol_checkbox, 1, 0, 1, 3)
		
		self.lp_checkbox = QCheckBox('Get covers from literatuurplein.nl if available (search is isbn-based)', self)
        self.lp_checkbox.setToolTip('If checked then the plugin looks first for a cover at literatuurplein.nl, based on the isbn number if that is found. Default is Unchecked.')
        self.lp_checkbox.setChecked(c.get(KEY_GET_LP_COVERS, DEFAULT_STORE_VALUES[KEY_GET_LP_COVERS]))
        other_group_box_layout.addWidget(self.lp_checkbox, 2, 0, 1, 3)
		
		self.lponly_checkbox = QCheckBox('Get ONLY covers from literatuurplein.nl not from bol.com', self)
        self.lponly_checkbox.setToolTip('If checked then the plugin looks only for a cover at literatuurplein.nl, based on the isbn number. Default is Unchecked.')
        self.lponly_checkbox.setChecked(c.get(KEY_GET_LPONLY_COVERS, DEFAULT_STORE_VALUES[KEY_GET_LPONLY_COVERS]))
        other_group_box_layout.addWidget(self.lponly_checkbox, 3, 0, 1, 3)
		
		other_group_box2 = QGroupBox('Errors and Request', self)
        self.l.addWidget(other_group_box2, self.l.rowCount(), 0, 1, 2)
        other_group_box2_layout = QGridLayout()
        other_group_box2.setLayout(other_group_box2_layout)
		txt1_label=QLabel('At the forum of Mobileread.com, section Calibre->Plugins, there is a special thread for BOL_NL!')
		txt_label=QLabel('<a href="http://www.mobileread.com/forums/showthread.php?t=139472">Please report errors or request overthere - CLICK </a>', self)
		txt_label.setOpenExternalLinks(True)
		other_group_box2_layout.addWidget(txt1_label)
		other_group_box2_layout.addWidget(txt_label)
       
    def commit(self):
        DefaultConfigWidget.commit(self)
        new_prefs = {}
        new_prefs[KEY_MAX_DOWNLOADS] = int(unicode(self.max_downloads_spin.value()))
        new_prefs[KEY_RECENSIES_BOL] = self.recensies_bol_checkbox.checkState() == Qt.Checked
		new_prefs[KEY_GET_LP_COVERS] = self.lp_checkbox.checkState() == Qt.Checked
        new_prefs[KEY_GET_LPONLY_COVERS] = self.lponly_checkbox.checkState() == Qt.Checked
		'''
		if self.lponly_checkbox.checkState() == Qt.Checked:
			new_prefs[KEY_GET_LP_COVERS] = self.lponly_checkbox.checkState() == Qt.Checked
		if self.lp_checkbox.checkState() != Qt.Checked:
			new_prefs[KEY_GET_LPONLY_COVERS] = self.lp_checkbox.checkState() == Qt.Checked
		'''
        plugin_prefs[STORE_NAME] = new_prefs

