
    /** Adding e-ink support **/
    public static class MyWebView extends WebView {
    	
    	
    	/* E-ink screen control for WebView calls
    	 * tries to add update mode parameter to function calls
    	 * set to 34 for normal mode
    	 * set to  5 for fast e-ink mode
       * call with MyWebView.mUpdateMode  = 5;
    	 */
    	public static int mUpdateMode = 5;

	public MyWebView(Context context) {
    		super(context);
    	}
   	
    	public MyWebView(Context context, AttributeSet attrs, int defStyle) {
    		super(context, attrs, defStyle);
    	}

    	public MyWebView(Context context, AttributeSet attrs) {
    		super(context, attrs);
    	}

    	@Override
    	public void invalidate() {
    		try {
    			Method invalidateMethod = super.getClass().getMethod("invalidate", int.class);
    			invalidateMethod.invoke(this, mUpdateMode);
    		} catch(Exception e) {
    			e.printStackTrace();
    		}
    	}

    	@Override
    	public void invalidate(int l, int t, int r, int b) {
    		try {
    			Method invalidateMethod = super.getClass().getMethod("invalidate", 
    					int.class, int.class, int.class, int.class, int.class);
    			invalidateMethod.invoke(this, l, t, r, b, mUpdateMode);
    		} catch(Exception e) {
    			e.printStackTrace();
    		}
    		
    	}

    	@Override
    	public void invalidate(Rect dirty) {
    		try {
    			Method invalidateMethod = super.getClass().getMethod("invalidate", 
    					Rect.class, int.class);
    			invalidateMethod.invoke(this, dirty, mUpdateMode);
    		} catch(Exception e) {
    			e.printStackTrace();
    		}	
    	}

    	@Override
    	public void invalidateDrawable(Drawable drawable) {
    		try {
    			Method invalidateMethod = super.getClass().getMethod("invalidateDrawable", 
    					Drawable.class, int.class);
    			invalidateMethod.invoke(this, drawable, mUpdateMode);
    		} catch(Exception e) {
    			e.printStackTrace();
    		}	
    	}

    	@Override
    	public void postInvalidate() {
    		try {
    			Method invalidateMethod = super.getClass().getMethod("postInvalidate", int.class);
    			invalidateMethod.invoke(this, mUpdateMode);
    		} catch(Exception e) {
    			e.printStackTrace();
    		}		
    	}

    	@Override
    	public void postInvalidate(int left, int top, int right, int bottom) {
    		try {
    			Method invalidateMethod = super.getClass().getMethod("postInvalidate", 
    					int.class, int.class, int.class, int.class, int.class);
    			invalidateMethod.invoke(this, left, top, right, bottom, mUpdateMode);
    		} catch(Exception e) {
    			e.printStackTrace();
    		}	
    	}

    	@Override
    	public void postInvalidateDelayed(long delayMilliseconds, int left,
    			int top, int right, int bottom) {
    		try {
    			Method invalidateMethod = super.getClass().getMethod("postInvalidateDelayed", 
    					long.class, int.class, int.class, int.class, int.class, int.class);
    			invalidateMethod.invoke(this, delayMilliseconds, left, top, right, bottom, mUpdateMode); 
    		} catch(Exception e) {
    			e.printStackTrace();
    		}			
    	}

    	@Override
    	public void postInvalidateDelayed(long delayMilliseconds) {
    		try {
    			Method invalidateMethod = super.getClass().getMethod("postInvalidateDelayed", 
    					long.class, int.class);
    			invalidateMethod.invoke(this, delayMilliseconds, mUpdateMode); 
    		} catch(Exception e) {
    			e.printStackTrace();
    		}				
    	}

    	@Override
    	public void scrollBy(int x, int y) {
    		try {
    			Method invalidateMethod = super.getClass().getMethod("scrollBy", 
    					int.class, int.class, int.class);
    			invalidateMethod.invoke(this, x, y , mUpdateMode); 
    		} catch(Exception e) {
    			e.printStackTrace();
    		}			
    	}

    	@Override
    	public void scrollTo(int x, int y) {
    		try {
    			Method invalidateMethod = super.getClass().getMethod("scrollTo", 
    					int.class, int.class, int.class);
    			invalidateMethod.invoke(this, x, y , mUpdateMode); 
    		} catch(Exception e) {
    			e.printStackTrace();
    		}			
    	}
}
