/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.settings.view.settings;

import com.amazon.agui.swing.DefaultDetailElementModel;
import com.amazon.agui.swing.DetailElementModel;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import com.amazon.ebook.util.thread.ThreadPool;
import com.amazon.kindle.apps.util.CommunicationUtils;
import com.amazon.kindle.apps.util.GestureDispatchUtils;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.apps.util.NetworkUtils;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.booklet.ChromeException;
import com.amazon.kindle.booklet.ChromeHeaderBar;
import com.amazon.kindle.control.DisplayController;
import com.amazon.kindle.control.widget.DCPagedLandingPanel;
import com.amazon.kindle.net.Wireless;
import com.amazon.kindle.net.WirelessEvent;
import com.amazon.kindle.net.WirelessListener;
import com.amazon.kindle.restricted.net.wifi.WiFi;
import com.amazon.kindle.restricted.net.wifi.WiFiNetwork;
import com.amazon.kindle.settings.SettingsBooklet;
import com.amazon.kindle.settings.property.PageRefreshAction;
import com.amazon.kindle.settings.util.PasscodeUtils;
import com.amazon.kindle.settings.view.deviceoptions.DeviceOptionsDisplayController;
import com.amazon.kindle.settings.view.dictionary.DictionaryLanguagesDisplayController;
import com.amazon.kindle.settings.view.international.InternationalDisplayController;
import com.amazon.kindle.settings.view.passcode.PasscodeDisplayController;
import com.amazon.kindle.settings.view.readingoptions.ReadingOptionsDisplayController;
import com.amazon.kindle.settings.view.registration.RegistrationDisplayController;
import com.amazon.kindle.settings.view.settings.DefaultSettingsDisplayController;
import com.amazon.kindle.settings.view.settings.SettingsElementView;
import com.amazon.kindle.webservices.registration.AmazonRegistrationService;
import com.amazon.kindle.webservices.registration.RegistrationEvent;
import com.amazon.kindle.webservices.registration.RegistrationListener;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class SettingsDisplayController
extends DefaultSettingsDisplayController
implements RegistrationListener,
WirelessListener {
    private static final Log V = Log.getInstance((String)"SettingsDisplayController");
    private static final LogMessage u = new LogMessage("ShowWiFiNetworks", new String[]{"action"});
    private static final String y = "WIFI_SCAN_CLIENT_ID";
    public static final String O = "SETTINGS";
    private static final int x = 100000;
    private static final int f = 0;
    private DetailElementModel M;
    private DetailElementModel J;
    private DetailElementModel G;
    private DetailElementModel a;
    private DetailElementModel i;
    private DetailElementModel E;
    private DetailElementModel C;
    private DetailElementModel d;
    private SettingsElementView j;
    private SettingsElementView g;
    private SettingsElementView e;
    private SettingsElementView I;
    private SettingsElementView F;
    private SettingsElementView L;
    private SettingsElementView c;
    private SettingsElementView l;
    private List k;
    private List m;
    private boolean h;
    private UpdateWifiCountHandler A;
    private ShowWiFiNetworksRunnable H;
    static /* synthetic */ Class D;

    public static synchronized SettingsDisplayController getInstance(SettingsBooklet a) {
        Object a2 = a.getDisplayController(O);
        if (a2 == null) {
            a2 = new SettingsDisplayController(a);
            a.addDisplayController(O, (DisplayController)a2, true);
        }
        return (SettingsDisplayController)((Object)a2);
    }

    private SettingsDisplayController(SettingsBooklet a) {
        super(a);
        SettingsDisplayController a2;
        a2.H = a2.new ShowWiFiNetworksRunnable();
        a2.A = a2.new UpdateWifiCountHandler();
        a2.initWidgets();
    }

    public String getViewKey() {
        return O;
    }

    public void willLoad() {
        SettingsDisplayController a;
        super.willLoad();
        a.setupRegistration(true);
        a.setupDevicePasscode(true);
        a.setupWifiNetworks(true);
        a.setupPageRefresh(true);
    }

    public void load() {
        SettingsDisplayController a;
        if (a.booklet == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        BookletContext a2 = a.booklet.getBookletContext();
        if (a2 == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        super.load();
        ((AmazonRegistrationService)a2.getService(AmazonRegistrationService.class)).addRegistrationListener((RegistrationListener)a);
        Wireless a3 = (Wireless)a2.getService(Wireless.class);
        a3.addWirelessListener((WirelessListener)a);
        a.B = new DCPagedLandingPanel(a.booklet, a.getUpdatedWidgetList());
        a.B.setHeaderBarEnabled(true);
        a.B.setLayoutParams(true, (int)K, (int)b);
        a.B.initGUI();
    }

    public void unload() {
        SettingsDisplayController a;
        if (a.booklet == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        BookletContext a2 = a.booklet.getBookletContext();
        if (a2 == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        super.unload();
        ((AmazonRegistrationService)a2.getService(AmazonRegistrationService.class)).removeRegistrationListener((RegistrationListener)a);
        Wireless a3 = (Wireless)a2.getService(Wireless.class);
        a3.removeWirelessListener((WirelessListener)a);
        ((DCPagedLandingPanel)a.B).removeAllItems();
        a.B = null;
        if (a.H.getAtomicState().get()) {
            V.warning(u, new String[]{"Handler Recreated"}, "expected: Handler Free, actual: Handler Waiting");
            a.H = a.new ShowWiFiNetworksRunnable();
        }
    }

    public boolean shouldMarkHistory() {
        return true;
    }

    public void onRegistrationInfoChanged(RegistrationEvent a) {
        SettingsDisplayController a2;
        final RegistrationEvent.RegistrationEventType a3 = a.getEventType();
        SwingUtilities.invokeLater(new Runnable(){
            {
                1 a;
            }

            public void run() {
                1 a;
                if (a.a3.equals((Object)RegistrationEvent.RegistrationEventType.REGISTERED) || a.a3.equals((Object)RegistrationEvent.RegistrationEventType.DEREGISTERED)) {
                    a.SettingsDisplayController.this.switchTo(null, false);
                }
            }
        });
    }

    public void onWirelessEvent(WirelessEvent a) {
        SettingsDisplayController a2;
        a2.setupWifiNetworks(true);
    }

    protected String getHeaderBarText() {
        return ResourceBundle.getBundle("com.amazon.kindle.settings.resources.SettingsResources").getString("header");
    }

    protected void initPanel() {
    }

    private List getUpdatedWidgetList() {
        SettingsDisplayController a;
        boolean a2 = CommunicationUtils.isRegistered((Booklet)a.booklet);
        if (a.h != a2) {
            a.h = a2;
            a.setupRegistration(true);
        }
        return a.h ? a.k : a.m;
    }

    private void initWidgets() {
        SettingsDisplayController a;
        a.setupRegistration(false);
        a.setupWifiNetworks(false);
        a.setupDevicePasscode(false);
        a.setupDeviceOptions();
        a.setupPageRefresh(false);
        a.setupReadingOptions();
        a.setupDictionaries();
        a.m = new ArrayList();
        a.m.add(a.j);
        a.m.add(a.g);
        a.m.add(a.e);
        a.m.add(a.c);
        a.m.add(a.F);
        a.k = new ArrayList();
        a.k.add(a.j);
        a.k.add(a.g);
        a.k.add(a.I);
        a.k.add(a.L);
        a.k.add(a.c);
    }

    private void setupRegistration(boolean a) {
        String a2;
        Object a3;
        String a4;
        SettingsDisplayController a5;
        ResourceBundle a6 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.SettingsResources");
        if (CommunicationUtils.isRegistered((Booklet)a5.booklet)) {
            a4 = a6.getString("reg.property.name.yes");
            a3 = CommunicationUtils.getUser((Booklet)a5.booklet);
            a2 = a3 != null ? a3 : a6.getString("reg.property.value.default.yes");
        } else {
            a4 = a6.getString("reg.property.name.no");
            a2 = a6.getString("reg.property.value.default.no");
        }
        if (a) {
            a5.M.addProperty("REGISTERED_USER", a4, (Object)a2);
            a5.M.refresh();
        } else {
            a3 = new AbstractAction(){
                {
                    2 a;
                }

                public void actionPerformed(ActionEvent a) {
                    if (GestureDispatchUtils.isReady()) {
                        2 a2;
                        RegistrationDisplayController.getInstance((SettingsBooklet)a2.SettingsDisplayController.this.booklet).switchTo();
                    }
                }
            };
            a5.M = new DefaultDetailElementModel(a6.getString("reg.name.label"), a6.getString("reg.description.label"), (Action)a3);
            a5.M.addProperty("REGISTERED_USER", a4, (Object)a2);
            a5.j = new SettingsElementView(a5.M);
        }
    }

    private void setupDevicePasscode(boolean a) {
        SettingsDisplayController a2;
        String a3;
        ResourceBundle a4 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.SettingsResources");
        String string = a3 = PasscodeUtils.isPasscodeEnabled((Booklet)a2.booklet) ? a4.getString("passcode.property.value.enabled") : a4.getString("passcode.property.value.disabled");
        if (a) {
            a2.G.addProperty("DEVICE_PASSCODE", a4.getString("passcode.property.name"), (Object)a3);
            a2.G.refresh();
        } else {
            AbstractAction a5 = new AbstractAction(){
                {
                    3 a;
                }

                public void actionPerformed(ActionEvent a) {
                    if (GestureDispatchUtils.isReady()) {
                        3 a2;
                        PasscodeDisplayController.getInstance((SettingsBooklet)a2.SettingsDisplayController.this.booklet).switchTo();
                    }
                }
            };
            a2.G = new DefaultDetailElementModel(a4.getString("passcode.name.label"), a4.getString("passcode.description.label"), (Action)a5);
            a2.G.addProperty("DEVICE_PASSCODE", a4.getString("passcode.property.name"), (Object)a3);
            a2.e = new SettingsElementView(a2.G);
        }
    }

    private void setupDeviceOptions() {
        SettingsDisplayController a;
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.SettingsResources");
        AbstractAction a3 = new AbstractAction(){
            {
                4 a;
            }

            public void actionPerformed(ActionEvent a) {
                if (GestureDispatchUtils.isReady()) {
                    4 a2;
                    DeviceOptionsDisplayController.getInstance((SettingsBooklet)a2.SettingsDisplayController.this.booklet).switchTo();
                }
            }
        };
        a.a = new DefaultDetailElementModel(a2.getString("deviceoptions.name.label"), a2.getString("deviceoptions.description.label"), (Action)a3);
        a.I = new SettingsElementView(a.a);
    }

    private void setupPageRefresh(boolean a) {
        SettingsDisplayController a2;
        ResourceBundle a3 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.SettingsResources");
        String a4 = a3.getString("pagerefresh.property.name");
        if (a) {
            PageRefreshAction a5 = (PageRefreshAction)a2.i.getItemAction();
            Boolean a6 = (Boolean)a5.getActionState();
            a2.i.setSingleBooleanPropertyValue(a6);
            a2.i.refresh();
        } else {
            PageRefreshAction a7 = new PageRefreshAction((SettingsBooklet)a2.booklet);
            a2.i = new DefaultDetailElementModel(a3.getString("pagerefresh.name.label"), a3.getString("pagerefresh.description.label"), (Action)a7);
            a2.i.addProperty("PAGE_REFRESH", a4, a7.getActionState());
            a2.F = new SettingsElementView(a2.i, 1);
        }
    }

    private void setupReadingOptions() {
        SettingsDisplayController a;
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.SettingsResources");
        AbstractAction a3 = new AbstractAction(){
            {
                5 a;
            }

            public void actionPerformed(ActionEvent a) {
                if (GestureDispatchUtils.isReady()) {
                    5 a2;
                    ReadingOptionsDisplayController.getInstance((SettingsBooklet)a2.SettingsDisplayController.this.booklet).switchTo();
                }
            }
        };
        a.E = new DefaultDetailElementModel(a2.getString("readingoptions.name.label"), a2.getString("readingoptions.description.label"), (Action)a3);
        a.L = new SettingsElementView(a.E);
    }

    private void setupDictionaries() {
        SettingsDisplayController a;
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.SettingsResources");
        AbstractAction a3 = new AbstractAction(){
            {
                6 a;
            }

            public void actionPerformed(ActionEvent a) {
                if (GestureDispatchUtils.isReady()) {
                    6 a2;
                    DictionaryLanguagesDisplayController.getInstance((SettingsBooklet)a2.SettingsDisplayController.this.booklet).switchTo();
                }
            }
        };
        a.C = new DefaultDetailElementModel(a2.getString("dictionary.name.label"), a2.getString("dictionary.description.label"), (Action)a3);
        a.c = new SettingsElementView(a.C);
    }

    private void setupWifiNetworks(boolean a) {
        SettingsDisplayController a2;
        if (a) {
            a2.updateWifiCount();
            a2.updateWifiConnection();
        } else {
            ResourceBundle a3 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.SettingsResources");
            AbstractAction a4 = new AbstractAction(){
                {
                    7 a;
                }

                public void actionPerformed(ActionEvent a) {
                    7 a2;
                    if (!a2.SettingsDisplayController.this.H.getAtomicState().getAndSet(true)) {
                        ThreadPool.getInstance().runIt((Runnable)a2.SettingsDisplayController.this.H, "Show Wifi Networks", 10);
                    }
                }
            };
            a2.J = new DefaultDetailElementModel(a3.getString("wifi.name.label"), a3.getString("wifi.description.label"), (Action)a4);
            a2.J.addProperty("WIFI_NETWORK_COUNT", a3.getString("wifi.property.name.count"), (Object)new Integer(0));
            a2.J.addProperty("WIFI_CONNECTION", a3.getString("wifi.property.name.connected.no"), (Object)a3.getString("wifi.property.value.connected.no.default"));
            a2.g = new SettingsElementView(a2.J);
        }
    }

    private void setupInternational() {
        SettingsDisplayController a;
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.SettingsResources");
        AbstractAction a3 = new AbstractAction(){
            {
                8 a;
            }

            public void actionPerformed(ActionEvent a) {
                if (GestureDispatchUtils.isReady()) {
                    8 a2;
                    InternationalDisplayController.getInstance((SettingsBooklet)a2.SettingsDisplayController.this.booklet).switchTo();
                }
            }
        };
        a.d = new DefaultDetailElementModel(a2.getString("international.name.label"), a2.getString("international.description.label"), (Action)a3);
        a.l = new SettingsElementView(a.d);
    }

    private void updateWifiCount() {
        try {
            SettingsDisplayController a;
            if (NetworkUtils.hasWifi((Booklet)a.booklet)) {
                BookletContext a2 = a.booklet.getBookletContext();
                if (a2 == null) {
                    LogUtils.logBookletContextIsNull();
                    return;
                }
                if (((Wireless)a2.getService(Wireless.class)).isWirelessSwitchOn()) {
                    SwingUtilities.invokeLater(a.A);
                } else {
                    ResourceBundle a3 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.SettingsResources");
                    a.J.addProperty("WIFI_NETWORK_COUNT", a3.getString("wifi.property.name.count"), (Object)new Integer(0));
                    a.J.refresh();
                }
            }
        }
        catch (Exception a) {
            V.error(Log.CATCHALL_EX, "error updating wifi networks count");
        }
    }

    private void updateWifiConnection() {
        try {
            SettingsDisplayController a;
            if (NetworkUtils.hasWifi((Booklet)a.booklet)) {
                String a2;
                String a3;
                BookletContext a4 = a.booklet.getBookletContext();
                if (a4 == null) {
                    LogUtils.logBookletContextIsNull();
                    return;
                }
                WiFiNetwork a5 = ((WiFi)a4.getService(WiFi.class)).getConnectedNetwork();
                ResourceBundle a6 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.SettingsResources");
                if (a5 != null) {
                    a3 = a6.getString("wifi.property.name.connected.yes");
                    a2 = a5.getSSID();
                } else {
                    a3 = a6.getString("wifi.property.name.connected.no");
                    a2 = a6.getString("wifi.property.value.connected.no.default");
                }
                a.J.addProperty("WIFI_CONNECTION", a3, (Object)a2);
                a.J.refresh();
            }
        }
        catch (Exception a) {
            V.error("Service Access Error: WiFi");
        }
    }

    private class ShowWiFiNetworksRunnable
    implements Runnable {
        private AtomicBoolean B = new AtomicBoolean();

        public ShowWiFiNetworksRunnable() {
            ShowWiFiNetworksRunnable a;
        }

        public void run() {
            ShowWiFiNetworksRunnable a;
            Class a2 = a.SettingsDisplayController.this.B;
            if (a2 != null && a2.isShowing() && GestureDispatchUtils.isReady()) {
                ((Wireless)a.SettingsDisplayController.this.getBooklet().getBookletContext().getService(K == null ? (K = SettingsDisplayController.class$("com.amazon.kindle.net.Wireless")) : K)).showWifiNetworks();
                a.SettingsDisplayController.this.setupWifiNetworks(true);
            }
            a.B.set(false);
        }

        public AtomicBoolean getAtomicState() {
            ShowWiFiNetworksRunnable a;
            return a.B;
        }
    }

    private class UpdateWifiCountHandler
    implements Runnable,
    WiFi.NetworkScanHandler {
        private UpdateWifiCountHandler() {
            UpdateWifiCountHandler a;
        }

        public void run() {
            try {
                UpdateWifiCountHandler a;
                BookletContext a2 = a.SettingsDisplayController.this.booklet.getBookletContext();
                if (a2 == null) {
                    LogUtils.logBookletContextIsNull();
                    return;
                }
                WiFi a3 = (WiFi)a2.getService(B == null ? (B = SettingsDisplayController.class$("com.amazon.kindle.restricted.net.wifi.WiFi")) : B);
                ((ChromeHeaderBar)a2.getService(D == null ? (D = SettingsDisplayController.class$("com.amazon.kindle.booklet.ChromeHeaderBar")) : D)).enableActivityIndicator(SettingsDisplayController.y, 100000, 0);
                a3.getNetworks((WiFi.NetworkScanHandler)a);
            }
            catch (ChromeException a) {
                V.error("BeachBall enable error: WIFI_SCAN_CLIENT_ID", (Throwable)a);
            }
        }

        public void onScanCompleted(List a) {
            Object a2;
            UpdateWifiCountHandler a3;
            try {
                a2 = a3.SettingsDisplayController.this.booklet.getBookletContext();
                if (a2 == null) {
                    LogUtils.logBookletContextIsNull();
                    return;
                }
                ((ChromeHeaderBar)a2.getService(D == null ? (D = SettingsDisplayController.class$("com.amazon.kindle.booklet.ChromeHeaderBar")) : D)).disableActivityIndicator(SettingsDisplayController.y);
            }
            catch (ChromeException a4) {
                V.error("BeachBall disable error: WIFI_SCAN_CLIENT_ID", (Throwable)a4);
            }
            a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.SettingsResources");
            a3.SettingsDisplayController.this.J.addProperty("WIFI_NETWORK_COUNT", ((ResourceBundle)a2).getString("wifi.property.name.count"), (Object)new Integer(a == null ? 0 : a.size()));
            SwingUtilities.invokeLater(new Runnable(){
                {
                    1 a;
                }

                public void run() {
                    1 a;
                    SettingsDisplayController.this.J.refresh();
                }
            });
        }
    }
}

