/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.settings.view.readingoptions;

import com.amazon.agui.swing.DefaultDetailElementModel;
import com.amazon.agui.swing.DetailElementModel;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.control.DisplayController;
import com.amazon.kindle.control.widget.DCPagedLandingPanel;
import com.amazon.kindle.identity.Marketplace;
import com.amazon.kindle.settings.SettingsBooklet;
import com.amazon.kindle.settings.property.AnnotationsBackupAction;
import com.amazon.kindle.settings.property.PageRefreshAction;
import com.amazon.kindle.settings.property.PopularHighlightsAction;
import com.amazon.kindle.settings.property.PublicNotesAction;
import com.amazon.kindle.settings.util.DeviceUtils;
import com.amazon.kindle.settings.view.settings.DefaultSettingsDisplayController;
import com.amazon.kindle.settings.view.settings.SettingsElementView;
import com.amazon.kindle.swing.actions.SwitchAppAction;
import com.amazon.kindle.webservices.registration.AmazonRegistrationService;
import com.amazon.kindle.webservices.registration.RegistrationEvent;
import com.amazon.kindle.webservices.registration.RegistrationListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.Action;

public class ReadingOptionsDisplayController
extends DefaultSettingsDisplayController
implements RegistrationListener {
    public static final String F = "READING_OPTIONS";
    private DetailElementModel L;
    private DetailElementModel c;
    private DetailElementModel l;
    private DetailElementModel k;
    private DetailElementModel m;
    private SettingsElementView h;
    private SettingsElementView A;
    private SettingsElementView H;
    private SettingsElementView b;
    private SettingsElementView K;

    public static synchronized ReadingOptionsDisplayController getInstance(SettingsBooklet a) {
        Object a2 = a.getDisplayController(F);
        if (a2 == null) {
            a2 = new ReadingOptionsDisplayController(a);
            a.addDisplayController(F, (DisplayController)a2);
        }
        return (ReadingOptionsDisplayController)((Object)a2);
    }

    private ReadingOptionsDisplayController(SettingsBooklet a) {
        super(a);
        ReadingOptionsDisplayController a2;
    }

    public String getViewKey() {
        return F;
    }

    public void willLoad() {
        ReadingOptionsDisplayController a;
        super.willLoad();
        a.setupPageRefresh(true);
    }

    public void load() {
        ReadingOptionsDisplayController a;
        if (a.booklet == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        BookletContext a2 = a.booklet.getBookletContext();
        if (a2 == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        super.load();
        ((AmazonRegistrationService)a2.getService(AmazonRegistrationService.class)).addRegistrationListener((RegistrationListener)a);
    }

    public void unload() {
        ReadingOptionsDisplayController a;
        if (a.booklet == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        BookletContext a2 = a.booklet.getBookletContext();
        if (a2 == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        super.unload();
        ((AmazonRegistrationService)a2.getService(AmazonRegistrationService.class)).removeRegistrationListener((RegistrationListener)a);
    }

    public void onRegistrationInfoChanged(RegistrationEvent a) {
        if (a.getEventType().equals((Object)RegistrationEvent.RegistrationEventType.DEREGISTERED)) {
            ReadingOptionsDisplayController a2;
            a2.booklet.loadPreviousView();
        }
    }

    protected void initPanel() {
        ReadingOptionsDisplayController a;
        a.setupAnnotationsBackup();
        a.setupPopularHighlights();
        a.setupPublicNotes();
        a.setupPageRefresh(false);
        a.setupSocialNetworks();
        ArrayList<SettingsElementView> a2 = new ArrayList<SettingsElementView>();
        a2.add(a.h);
        a2.add(a.A);
        a2.add(a.H);
        a2.add(a.b);
        a2.add(a.K);
        a.B = new DCPagedLandingPanel(a.booklet, a2);
        a.B.setHeaderBarEnabled(true);
        a.B.setLayoutParams(true, (int)K, (int)b);
        a.B.initGUI();
    }

    protected String getHeaderBarText() {
        return ResourceBundle.getBundle("com.amazon.kindle.settings.resources.ReadingOptionsResources").getString("header");
    }

    private void setupAnnotationsBackup() {
        ReadingOptionsDisplayController a;
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.ReadingOptionsResources");
        AnnotationsBackupAction a3 = new AnnotationsBackupAction((SettingsBooklet)a.booklet);
        Object a4 = a3.getActionState();
        a.L = new DefaultDetailElementModel(a2.getString("annotations.name.label"), a2.getString("annotations.description.label"), (Action)a3);
        a.L.addProperty("ANNOTATIONS_BACKUP", a2.getString("annotations.property.name"), a4);
        a.h = new SettingsElementView(a.L, 1);
    }

    private void setupPopularHighlights() {
        ReadingOptionsDisplayController a;
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.ReadingOptionsResources");
        PopularHighlightsAction a3 = new PopularHighlightsAction((SettingsBooklet)a.booklet);
        a.c = new DefaultDetailElementModel(a2.getString("highlights.name.label"), a2.getString("highlights.description.label"), (Action)a3);
        a.c.addProperty("POPULAR_HIGHLIGHTS", a2.getString("highlights.property.name"), a3.getActionState());
        a.A = new SettingsElementView(a.c, 1);
    }

    private void setupPublicNotes() {
        ReadingOptionsDisplayController a;
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.ReadingOptionsResources");
        PublicNotesAction a3 = new PublicNotesAction((SettingsBooklet)a.booklet);
        BookletContext a4 = a.booklet.getBookletContext();
        if (a4 == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        Marketplace a5 = (Marketplace)a4.getService(Marketplace.class);
        String a6 = a5 == null ? a2.getString("publicnotes.description.value.default") : a5.getItem("kindle.home.site", a2.getString("publicnotes.description.value.default"));
        a.l = new DefaultDetailElementModel(a2.getString("publicnotes.name.label"), MessageFormat.format(a2.getString("publicnotes.description.template"), a6), (Action)a3);
        a.l.addProperty("PUBLIC_NOTES", a2.getString("publicnotes.property.name"), a3.getActionState());
        a.H = new SettingsElementView(a.l, 1);
    }

    private void setupPageRefresh(boolean a) {
        ReadingOptionsDisplayController a2;
        ResourceBundle a3 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.ReadingOptionsResources");
        String a4 = a3.getString("pagerefresh.property.name");
        if (a) {
            PageRefreshAction a5 = (PageRefreshAction)a2.k.getItemAction();
            Boolean a6 = (Boolean)a5.getActionState();
            a2.k.setSingleBooleanPropertyValue(a6);
            a2.k.refresh();
        } else {
            PageRefreshAction a7 = new PageRefreshAction((SettingsBooklet)a2.booklet);
            a2.k = new DefaultDetailElementModel(a3.getString("pagerefresh.name.label"), a3.getString("pagerefresh.description.label"), (Action)a7);
            a2.k.addProperty("PAGE_REFRESH", a4, a7.getActionState());
            a2.b = new SettingsElementView(a2.k, 1);
        }
    }

    private void setupSocialNetworks() {
        ReadingOptionsDisplayController a;
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.ReadingOptionsResources");
        SwitchAppAction a3 = new SwitchAppAction("", a2.getString("socialnetworks.uri.dnt"));
        StringBuffer a4 = new StringBuffer(a2.getString("socialnetworks.query.dnt"));
        a4.append('&');
        a4.append(DeviceUtils.getDeviceTypeQuery((Booklet)a.booklet));
        a3.setQuery(a4.toString());
        a.m = new DefaultDetailElementModel(a2.getString("socialnetworks.name.label"), a2.getString("socialnetworks.description.label"), (Action)a3);
        a.K = new SettingsElementView(a.m);
    }
}

