/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.settings.view.passcode;

import com.amazon.agui.swing.DefaultDetailElementModel;
import com.amazon.agui.swing.DetailElementModel;
import com.amazon.agui.swing.DetailElementView;
import com.amazon.kindle.apps.util.GestureDispatchUtils;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.control.DisplayController;
import com.amazon.kindle.control.widget.DCPagedLandingPanel;
import com.amazon.kindle.settings.SettingsBooklet;
import com.amazon.kindle.settings.dialog.PasscodeDialog;
import com.amazon.kindle.settings.util.PasscodeUtils;
import com.amazon.kindle.settings.view.settings.DefaultSettingsDisplayController;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.border.Border;

public class PasscodeDisplayController
extends DefaultSettingsDisplayController {
    public static final String B = "PASSCODE";
    private List D;

    public static synchronized PasscodeDisplayController getInstance(SettingsBooklet a) {
        Object a2 = a.getDisplayController(B);
        if (a2 == null) {
            a2 = new PasscodeDisplayController(a);
            a.addDisplayController(B, (DisplayController)a2);
        }
        return (PasscodeDisplayController)((Object)a2);
    }

    private PasscodeDisplayController(SettingsBooklet a) {
        super(a);
        PasscodeDisplayController a2;
        a2.initWidgets();
    }

    public String getViewKey() {
        return B;
    }

    public void switchTo() {
        PasscodeDisplayController a;
        if (PasscodeUtils.isPasscodeEnabled((Booklet)a.booklet)) {
            super.switchTo();
        } else {
            a.createPasscode();
        }
    }

    public void load() {
        PasscodeDisplayController a;
        if (a.booklet == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        super.load();
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.PasscodeResources");
        a.B = new DCPagedLandingPanel(a.booklet, a.D);
        a.B.setHeaderBarEnabled(true);
        a.B.setLayoutParams(true, ((Integer)a2.getObject("default.columns")).intValue(), ((Integer)a2.getObject("default.rows")).intValue());
        a.B.initGUI();
    }

    public void unload() {
        PasscodeDisplayController a;
        super.unload();
        ((DCPagedLandingPanel)a.B).removeAllItems();
        a.B = null;
    }

    public boolean shouldMarkHistory() {
        return false;
    }

    protected void initPanel() {
    }

    protected String getHeaderBarText() {
        return ResourceBundle.getBundle("com.amazon.kindle.settings.resources.PasscodeResources").getString("header");
    }

    private void initWidgets() {
        PasscodeDisplayController a;
        a.D = new ArrayList();
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.PasscodeResources");
        Border a3 = (Border)a2.getObject("widget.border");
        DefaultDetailElementModel a4 = new DefaultDetailElementModel(a2.getString("turnoff.name.label"), null, a.getTurnOffPasscodeAction());
        DetailElementView a5 = new DetailElementView((DetailElementModel)a4);
        a5.setBorder(a3);
        a.D.add(a5);
        a4 = new DefaultDetailElementModel(a2.getString("change.name.label"), null, a.getChangePasscodeAction());
        a5 = new DetailElementView((DetailElementModel)a4);
        a5.setBorder(a3);
        a.D.add(a5);
    }

    private void createPasscode() {
        PasscodeDisplayController a;
        char[][] a2;
        ResourceBundle a3 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.PasscodeResources");
        char[][] cArray = a2 = new PasscodeDialog(a.getBooklet().getName(), a3.getString("create.title.label"), null, a3.getString("enter.passcode.label"), a3.getString("confirm.passcode.label")).showDialog();
        while (cArray != null) {
            if (Arrays.equals(a2[1], a2[0])) {
                if (PasscodeUtils.setPasscode((Booklet)a.booklet, a2[0], null)) {
                    PasscodeUtils.setPasscodeEnabled((Booklet)a.booklet, true);
                    a2 = null;
                    a.switchTo();
                    cArray = a2;
                    continue;
                }
                cArray = new PasscodeDialog(a.getBooklet().getName(), a3.getString("invalid.title.label"), a3.getString("enter.different.passcode.label"), a3.getString("enter.passcode.label"), a3.getString("confirm.passcode.label")).showDialog();
                continue;
            }
            cArray = new PasscodeDialog(a.getBooklet().getName(), a3.getString("mismatch.title.label"), a3.getString("try.again.label"), a3.getString("enter.passcode.label"), a3.getString("confirm.passcode.label")).showDialog();
        }
    }

    private Action getTurnOffPasscodeAction() {
        PasscodeDisplayController a;
        return new AbstractAction(){
            {
                1 a;
            }

            public void actionPerformed(ActionEvent a) {
                if (GestureDispatchUtils.isReady()) {
                    1 a2;
                    char[][] a3;
                    ResourceBundle a4 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.PasscodeResources");
                    char[][] cArray = a3 = new PasscodeDialog(a2.PasscodeDisplayController.this.getBooklet().getName(), a4.getString("turnoff.title.label"), null, a4.getString("enter.passcode.label"), null).showDialog();
                    while (cArray != null) {
                        if (PasscodeUtils.isPasscodeValid((Booklet)a2.PasscodeDisplayController.this.booklet, a3[0])) {
                            PasscodeUtils.setPasscodeEnabled((Booklet)a2.PasscodeDisplayController.this.booklet, false);
                            a3 = null;
                            a2.PasscodeDisplayController.this.booklet.loadPreviousView();
                            cArray = a3;
                            continue;
                        }
                        cArray = new PasscodeDialog(a2.PasscodeDisplayController.this.getBooklet().getName(), a4.getString("incorrect.title.label"), a4.getString("try.again.label"), a4.getString("enter.passcode.label"), null).showDialog();
                    }
                }
            }
        };
    }

    private Action getChangePasscodeAction() {
        PasscodeDisplayController a;
        return new AbstractAction(){
            {
                2 a;
            }

            public void actionPerformed(ActionEvent a) {
                if (GestureDispatchUtils.isReady()) {
                    2 a2;
                    char[][] a3;
                    ResourceBundle a4 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.PasscodeResources");
                    char[] a5 = null;
                    char[][] cArray = a3 = new PasscodeDialog(a2.PasscodeDisplayController.this.getBooklet().getName(), a4.getString("change.title.label"), null, a4.getString("enter.current.passcode.label"), null).showDialog();
                    while (cArray != null) {
                        a5 = a3[0];
                        if (PasscodeUtils.isPasscodeValid((Booklet)a2.PasscodeDisplayController.this.booklet, a5)) {
                            cArray = null;
                            continue;
                        }
                        a5 = null;
                        cArray = new PasscodeDialog(a2.PasscodeDisplayController.this.getBooklet().getName(), a4.getString("incorrect.title.label"), a4.getString("try.again.label"), a4.getString("enter.passcode.label"), null).showDialog();
                    }
                    if (a5 != null) {
                        char[][] cArray2 = a3 = new PasscodeDialog(a2.PasscodeDisplayController.this.getBooklet().getName(), a4.getString("change.title.label"), null, a4.getString("enter.new.passcode.label"), a4.getString("confirm.new.passcode.label")).showDialog();
                        while (cArray2 != null) {
                            if (Arrays.equals(a3[1], a3[0])) {
                                if (PasscodeUtils.setPasscode((Booklet)a2.PasscodeDisplayController.this.booklet, a3[0], a5)) {
                                    cArray2 = null;
                                    continue;
                                }
                                cArray2 = new PasscodeDialog(a2.PasscodeDisplayController.this.getBooklet().getName(), a4.getString("invalid.title.label"), a4.getString("enter.different.passcode.label"), a4.getString("enter.new.passcode.label"), a4.getString("confirm.new.passcode.label")).showDialog();
                                continue;
                            }
                            cArray2 = new PasscodeDialog(a2.PasscodeDisplayController.this.getBooklet().getName(), a4.getString("mismatch.title.label"), a4.getString("try.again.label"), a4.getString("enter.new.passcode.label"), a4.getString("confirm.new.passcode.label")).showDialog();
                        }
                    }
                }
            }
        };
    }
}

