/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.settings.view.legal;

import com.amazon.agui.swing.HeaderBar;
import com.amazon.kindle.settings.view.legal.LegalImageTextPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class LegalPanel
extends JPanel {
    private HeaderBar mHeaderBar;
    private JLabel mTitleLabel;
    private LegalImageTextPanel mImageTextPanel;
    private MessageFormat mPageLabelFormat;

    public LegalPanel() {
        LegalPanel a;
        a.initGUI();
    }

    public int getCurrentPage() {
        LegalPanel a;
        return a.mImageTextPanel.getCurrentPage();
    }

    public void setToPage(int a) {
        LegalPanel a2;
        a2.mImageTextPanel.setToPage(a);
    }

    public void nextPage() {
        LegalPanel a;
        if (a.mImageTextPanel.nextPage()) {
            a.updateGUI();
        }
    }

    public void prevPage() {
        LegalPanel a;
        if (a.mImageTextPanel.prevPage()) {
            a.updateGUI();
        }
    }

    protected void paintComponent(Graphics a) {
        LegalPanel a2;
        a2.paintChildren(a);
        a2.mHeaderBar.setText(2, a2.getPageLabel());
    }

    private void initGUI() {
        LegalPanel a;
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.LegalResources");
        a.mPageLabelFormat = new MessageFormat(a2.getString("legal.subheader.template"));
        a.mHeaderBar = new HeaderBar();
        a.mHeaderBar.setText(0, a2.getString("legal.header"));
        a.mTitleLabel = new JLabel(a2.getString("legal.title.label"));
        a.mTitleLabel.setFont((Font)a2.getObject("legal.title.font"));
        a.mTitleLabel.setBorder((Border)a2.getObject("legal.title.border"));
        a.mImageTextPanel = new LegalImageTextPanel();
        a.mImageTextPanel.setBorder((Border)a2.getObject("legal.body.border"));
        a.mImageTextPanel.setFont((Font)a2.getObject("legal.body.font"));
        JPanel a3 = new JPanel();
        a3.setLayout(new BorderLayout());
        a3.add((Component)a.mHeaderBar, "North");
        a3.add((Component)a.mTitleLabel, "South");
        a.setLayout(new BorderLayout());
        a.add((Component)a3, "North");
        a.add((Component)a.mImageTextPanel, "Center");
    }

    private void updateGUI() {
        LegalPanel a;
        a.mImageTextPanel.repaint();
        a.mHeaderBar.setText(2, a.getPageLabel());
    }

    private String getPageLabel() {
        LegalPanel a;
        return a.mPageLabelFormat.format(new Object[]{new Integer(a.mImageTextPanel.getCurrentPage() + 1), new Integer(a.mImageTextPanel.getTotalPages())});
    }
}

