/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.settings.view.legal;

import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import com.amazon.ebook.util.text.AcceleratedFontMetrics;
import com.amazon.ebook.util.text.StringUtil;
import com.amazon.kindle.restricted.device.DisplayManager;
import com.amazon.kindle.restricted.runtime.Const;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JPanel;

public class LegalImageTextPanel
extends JPanel {
    private static final Log LOG = Log.getInstance((String)"LegalImageTextPanel");
    private static final LogMessage FILE_NOT_FOUND = new LogMessage("FileNotFoundException", new String[]{"filename"});
    private static final LogMessage INVALID_CHARSET = new LogMessage("UnsupportedEncodingException", new String[]{"Charset"});
    private static final char BOM = '\ufeff';
    private static final int BOM_INDEX = 0;
    private static final String EMPTY_STRING = "";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String ABOUT_FILE_NAME = Const.getInstance().getAboutFile();
    private static final String IMAGE_FILE_NAME = Const.getInstance().getPreferencesDirectory() + File.separator + "javalogo.gif";
    private static final String CHARSET = "UTF-8";
    private AcceleratedFontMetrics mFontMetrics;
    private DisplayManager mDisplayManager;
    private DisplayPage mDisplayPage;
    private Dimension mImageDimension;
    private Point mImageLocation;
    private Image mImage;
    private List mPages;
    private int mCurrentPageIndex;
    private int mImagePageIndex;
    private int mFontHeight;
    private String mImageKey;

    public LegalImageTextPanel() {
        LegalImageTextPanel a;
    }

    public void setToPage(int a) {
        a.mCurrentPageIndex = a;
    }

    public boolean nextPage() {
        LegalImageTextPanel a;
        if (a.mCurrentPageIndex + 1 < a.mPages.size()) {
            ++a.mCurrentPageIndex;
            return true;
        }
        return false;
    }

    public boolean prevPage() {
        LegalImageTextPanel a;
        if (a.mCurrentPageIndex - 1 >= 0) {
            --a.mCurrentPageIndex;
            return true;
        }
        return false;
    }

    public int getCurrentPage() {
        LegalImageTextPanel a;
        return a.mCurrentPageIndex;
    }

    public int getTotalPages() {
        LegalImageTextPanel a;
        return a.mPages != null ? a.mPages.size() : 0;
    }

    protected void paintComponent(Graphics a) {
        LegalImageTextPanel a2;
        a2.setupToPaint(a);
        if (a2.mCurrentPageIndex < 0 || a2.mCurrentPageIndex > a2.mPages.size() - 1) {
            a2.mCurrentPageIndex = a2.mPages.size() - 1;
        }
        a2.mDisplayPage = (DisplayPage)a2.mPages.get(a2.mCurrentPageIndex);
        a2.mDisplayPage.paintDisplayPage(a);
        if (a2.mCurrentPageIndex == a2.mImagePageIndex) {
            DisplayManager.drawImageSync((Image)a2.mImage, (Graphics)a, (int)a2.mImageLocation.x, (int)a2.mImageLocation.y);
        }
    }

    private void setupToPaint(Graphics a) {
        LegalImageTextPanel a2;
        if (a2.mPages == null) {
            a2.mCurrentPageIndex = 0;
            a2.mPages = new ArrayList();
            a2.mDisplayManager = new DisplayManager();
            ResourceBundle a3 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.LegalResources");
            a2.mImageKey = a3.getString("legal.image.key");
            a2.mImage = Toolkit.getDefaultToolkit().createImage(IMAGE_FILE_NAME);
            a2.mImageDimension = a2.mDisplayManager.getImageDimensionSync(a2.mImage);
            a2.mImageLocation = new Point();
            a2.mImageLocation.x = a2.getBounds().width - a2.mImageDimension.width >> 1;
            Font a4 = a2.getFont();
            a.setFont(a4);
            a.setColor((Color)a3.getObject("legal.body.color"));
            a2.mFontMetrics = AcceleratedFontMetrics.getInstance((Font)a4, (FontMetrics)a.getFontMetrics());
            a2.mFontHeight = a2.mFontMetrics.getHeight();
            a2.mDisplayPage = a2.new DisplayPage();
            a2.loadDisplayPages(a);
        }
    }

    private void loadDisplayPages(Graphics a) {
        LegalImageTextPanel a2;
        List a3 = a2.organizeIntoDisplayLines(a, a2.getLegalFileLines());
        boolean a4 = false;
        int a5 = a2.getDrawableHeight();
        String a6 = null;
        Iterator a7 = a3.iterator();
        block0: while (true) {
            Iterator iterator = a7;
            block1: while (true) {
                boolean bl = iterator.hasNext();
                while (bl) {
                    a6 = ((String)a7.next()).trim();
                    if (a2.mDisplayPage.y > a5) {
                        a2.mPages.add(a2.mDisplayPage);
                        a2.mDisplayPage = a2.new DisplayPage();
                    }
                    if (!a4 && a6.indexOf(a2.mImageKey) >= 0) {
                        if (a2.mDisplayPage.y - a2.mFontHeight + a2.mImageDimension.height > a5) {
                            a2.mPages.add(a2.mDisplayPage);
                            a2.mDisplayPage = a2.new DisplayPage();
                        }
                        a2.mImageLocation.y = a2.mDisplayPage.y;
                        a2.mDisplayPage.y += a2.mImageDimension.height;
                        a2.mImagePageIndex = a2.mPages.size();
                        a4 = true;
                        bl = a7.hasNext();
                        continue;
                    }
                    if (!StringUtil.isNotEmpty((String)a6) && (a2.mDisplayPage.isEmpty() || !StringUtil.isEmpty((String)a6))) continue block0;
                    a2.mDisplayPage.add(a2.new DisplayLine(a6, a2.mDisplayPage.y));
                    a2.mDisplayPage.y += a2.mFontHeight;
                    iterator = a7;
                    continue block1;
                }
                break;
            }
            if (!a2.mDisplayPage.isEmpty()) {
                a2.mPages.add(a2.mDisplayPage);
            }
            return;
        }
    }

    private List organizeIntoDisplayLines(Graphics a, List a2) {
        LegalImageTextPanel a3;
        ArrayList<String> a4 = new ArrayList<String>();
        FontMetrics a5 = a.getFontMetrics();
        int a6 = a3.getDrawableWidth();
        int a7 = a3.getDrawableHeight() / a3.mFontHeight;
        Iterator a8 = a2.iterator();
        while (a8.hasNext()) {
            String a9 = (String)a8.next();
            if (StringUtil.isNotEmpty((String)a9)) {
                List a10 = StringUtil.splitIntoLines((FontMetrics)a5, (String)a9, (int)a6, (int)a7);
                a4.addAll(a10);
                continue;
            }
            a4.add(NEW_LINE);
        }
        return a4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List getLegalFileLines() {
        ArrayList<String> a;
        block43: {
            a = new ArrayList<String>();
            FileInputStream a2 = null;
            InputStreamReader a3 = null;
            BufferedReader a4 = null;
            a2 = new FileInputStream(ABOUT_FILE_NAME);
            a3 = new InputStreamReader((InputStream)a2, CHARSET);
            a4 = new BufferedReader(a3);
            String a5 = a4.readLine();
            if (a5.charAt(0) == '\ufeff') {
                a5 = a5.length() > 1 ? a5.substring(1) : EMPTY_STRING;
            }
            while (a5 != null) {
                a5 = a5.trim();
                a.add(a5);
                a5 = a4.readLine();
            }
            Object var7_9 = null;
            try {
                if (a2 != null) {
                    a2.close();
                }
            }
            catch (IOException a6) {
                LOG.error(Log.IO_EX, "Closing InputSteam");
            }
            try {
                if (a3 != null) {
                    a3.close();
                }
            }
            catch (IOException a6) {
                LOG.error(Log.IO_EX, "Closing InputSteamReader");
            }
            try {
                if (a4 != null) {
                    a4.close();
                }
                break block43;
            }
            catch (IOException a6) {
                LOG.error(Log.IO_EX, "Closing BufferedReader");
            }
            break block43;
            {
                catch (FileNotFoundException a7) {
                    LOG.error(FILE_NOT_FOUND, new String[]{"AboutFile"}, "Cannot find" + ABOUT_FILE_NAME);
                    Object var7_10 = null;
                    try {
                        if (a2 != null) {
                            a2.close();
                        }
                    }
                    catch (IOException a6) {
                        LOG.error(Log.IO_EX, "Closing InputSteam");
                    }
                    try {
                        if (a3 != null) {
                            a3.close();
                        }
                    }
                    catch (IOException a6) {
                        LOG.error(Log.IO_EX, "Closing InputSteamReader");
                    }
                    try {
                        if (a4 != null) {
                            a4.close();
                        }
                        break block43;
                    }
                    catch (IOException a6) {
                        LOG.error(Log.IO_EX, "Closing BufferedReader");
                    }
                    break block43;
                }
                catch (UnsupportedEncodingException a8) {
                    LOG.error(INVALID_CHARSET, new String[]{CHARSET}, EMPTY_STRING);
                    Object var7_11 = null;
                    try {
                        if (a2 != null) {
                            a2.close();
                        }
                    }
                    catch (IOException a6) {
                        LOG.error(Log.IO_EX, "Closing InputSteam");
                    }
                    try {
                        if (a3 != null) {
                            a3.close();
                        }
                    }
                    catch (IOException a6) {
                        LOG.error(Log.IO_EX, "Closing InputSteamReader");
                    }
                    try {
                        if (a4 != null) {
                            a4.close();
                        }
                        break block43;
                    }
                    catch (IOException a6) {
                        LOG.error(Log.IO_EX, "Closing BufferedReader");
                    }
                    break block43;
                }
                catch (IOException a9) {
                    LOG.error(Log.IO_EX, "Reading: " + ABOUT_FILE_NAME);
                    Object var7_12 = null;
                    try {
                        if (a2 != null) {
                            a2.close();
                        }
                    }
                    catch (IOException a6) {
                        LOG.error(Log.IO_EX, "Closing InputSteam");
                    }
                    try {
                        if (a3 != null) {
                            a3.close();
                        }
                    }
                    catch (IOException a6) {
                        LOG.error(Log.IO_EX, "Closing InputSteamReader");
                    }
                    try {
                        if (a4 != null) {
                            a4.close();
                        }
                        break block43;
                    }
                    catch (IOException a6) {
                        LOG.error(Log.IO_EX, "Closing BufferedReader");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_13 = null;
                try {
                    if (a2 != null) {
                        a2.close();
                    }
                }
                catch (IOException a6) {
                    LOG.error(Log.IO_EX, "Closing InputSteam");
                }
                try {
                    if (a3 != null) {
                        a3.close();
                    }
                }
                catch (IOException a6) {
                    LOG.error(Log.IO_EX, "Closing InputSteamReader");
                }
                try {
                    if (a4 != null) {
                        a4.close();
                    }
                }
                catch (IOException a6) {
                    LOG.error(Log.IO_EX, "Closing BufferedReader");
                }
                throw throwable;
            }
        }
        return a;
    }

    private int getDrawableWidth() {
        LegalImageTextPanel a;
        return a.getBounds().width - (a.getInsets().left + a.getInsets().right);
    }

    private int getDrawableHeight() {
        LegalImageTextPanel a;
        return a.getBounds().height - (a.getInsets().top + a.getInsets().bottom);
    }

    private class DisplayPage
    extends ArrayList {
        private int y;

        public DisplayPage() {
            DisplayPage a;
            a.y = a.LegalImageTextPanel.this.getInsets().top + a.LegalImageTextPanel.this.mFontHeight;
        }

        public void paintDisplayPage(Graphics a) {
            DisplayPage a2;
            Iterator a3;
            Iterator iterator = a3 = a2.iterator();
            while (iterator.hasNext()) {
                ((DisplayLine)a3.next()).paintDisplayLine(a);
                iterator = a3;
            }
        }

        public boolean isEmpty() {
            DisplayPage a;
            return a.y == a.LegalImageTextPanel.this.getInsets().top + a.LegalImageTextPanel.this.mFontHeight;
        }
    }

    private class DisplayLine {
        private String K;
        private int B;

        public DisplayLine(String a, int a2) {
            DisplayLine a3;
            a3.K = a;
            a3.B = a2;
        }

        public void paintDisplayLine(Graphics a) {
            DisplayLine a2;
            a.drawString(a2.K, a2.LegalImageTextPanel.this.getInsets().left, a2.B);
        }
    }
}

