/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.settings.view.keyboard;

import com.amazon.ebook.util.log.Log;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.control.DisplayController;
import com.amazon.kindle.control.widget.DCListLandingPanel;
import com.amazon.kindle.control.widget.JListDataTransferObject;
import com.amazon.kindle.device.KeyboardLayout;
import com.amazon.kindle.settings.SettingsBooklet;
import com.amazon.kindle.settings.view.international.InternationalDisplayController;
import com.amazon.kindle.settings.view.settings.DefaultSettingsDisplayController;
import java.awt.event.ActionEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class KeyboardDisplayController
extends DefaultSettingsDisplayController {
    private static final Log K = Log.getInstance((String)"KeyboardDisplayController");
    public static final String B = "KEYBOARD";

    public static synchronized KeyboardDisplayController getInstance(SettingsBooklet a) {
        Object a2 = a.getDisplayController(B);
        if (a2 == null) {
            a2 = new KeyboardDisplayController(a);
            a.addDisplayController(B, (DisplayController)a2);
        }
        return (KeyboardDisplayController)((Object)a2);
    }

    private KeyboardDisplayController(SettingsBooklet a) {
        super(a);
        KeyboardDisplayController a2;
    }

    public String getViewKey() {
        return B;
    }

    public void load() {
        KeyboardDisplayController a;
        Object[] a2 = a.getKeyboardLayoutTransferObjects();
        if (a2 != null) {
            super.load();
            a.B = new DCListLandingPanel(a.getBooklet(), a2, false);
            a.B.setHeaderBarEnabled(true);
            a.B.setOKAction(a.getSaveSelectedKeyboardsAction((SettingsBooklet)a.getBooklet()));
            a.B.setCancelAction((Action)new AbstractAction(){
                {
                    1 a;
                }

                public void actionPerformed(ActionEvent a) {
                    1 a2;
                    InternationalDisplayController.getInstance((SettingsBooklet)a2.KeyboardDisplayController.this.booklet).switchTo();
                }
            });
            a.B.initGUI();
        }
    }

    public void unload() {
        KeyboardDisplayController a;
        super.unload();
        a.B = null;
    }

    public boolean shouldMarkHistory() {
        return false;
    }

    protected void initPanel() {
    }

    protected String getHeaderBarText() {
        return ResourceBundle.getBundle("com.amazon.kindle.settings.resources.KeyboardResources").getString("header");
    }

    private Object[] getKeyboardLayoutTransferObjects() {
        int a;
        KeyboardDisplayController a2;
        if (a2.booklet == null) {
            LogUtils.logBookletIsNull();
            return null;
        }
        BookletContext a3 = a2.booklet.getBookletContext();
        if (a3 == null) {
            LogUtils.logBookletContextIsNull();
            return null;
        }
        KeyboardLayout a4 = (KeyboardLayout)a3.getService(KeyboardLayout.class);
        List a5 = a4.getAllLayouts();
        if (a5 == null) {
            K.error("device must have at least 1 keyboard");
            return null;
        }
        Collator a6 = Collator.getInstance(Locale.getDefault());
        Collections.sort(a5, a6);
        Object[] a7 = new Object[a5.size()];
        int n = a = 0;
        while (n < a5.size()) {
            String a8 = (String)a5.get(a);
            JListDataTransferObject a9 = new JListDataTransferObject(a8, a8, a4.isLayoutSelected(a8));
            a7[a] = a9;
            n = ++a;
        }
        return a7;
    }

    private Action getSaveSelectedKeyboardsAction(SettingsBooklet a) {
        KeyboardDisplayController a2;
        return new AbstractAction(){
            {
                2 a;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void actionPerformed(ActionEvent a) {
                JListDataTransferObject a2;
                int a3;
                2 a4;
                Object[] a5 = ((DCListLandingPanel)a4.KeyboardDisplayController.this.B).getSelectedValues();
                ArrayList<String> a6 = new ArrayList<String>();
                int n = a3 = 0;
                while (n < a5.length) {
                    a2 = (JListDataTransferObject)a5[a3];
                    a6.add(a2.getTag());
                    n = ++a3;
                }
                if (a4.KeyboardDisplayController.this.booklet == null) {
                    LogUtils.logBookletIsNull();
                    return;
                }
                BookletContext a22 = a4.KeyboardDisplayController.this.booklet.getBookletContext();
                if (a22 == null) {
                    LogUtils.logBookletContextIsNull();
                    return;
                }
                a2 = (KeyboardLayout)a22.getService(D == null ? (D = KeyboardDisplayController.class$("com.amazon.kindle.device.KeyboardLayout")) : D);
                try {
                    try {
                        a2.setSelectedLayouts(a6);
                    }
                    catch (NullPointerException a7) {
                        K.error("selected keyboard layout list is null");
                        Object var9_8 = null;
                        InternationalDisplayController.getInstance((SettingsBooklet)a4.KeyboardDisplayController.this.booklet).switchTo();
                        return;
                    }
                    catch (IllegalArgumentException a8) {
                        K.error("selected keyboard layout list is empty or not in the set of available layouts");
                        Object var9_9 = null;
                        InternationalDisplayController.getInstance((SettingsBooklet)a4.KeyboardDisplayController.this.booklet).switchTo();
                        return;
                    }
                    Object var9_7 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    InternationalDisplayController.getInstance((SettingsBooklet)a4.KeyboardDisplayController.this.booklet).switchTo();
                    throw throwable;
                }
                InternationalDisplayController.getInstance((SettingsBooklet)a4.KeyboardDisplayController.this.booklet).switchTo();
            }
        };
    }
}

