/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.settings.view.international;

import com.amazon.agui.swing.DefaultDetailElementModel;
import com.amazon.agui.swing.DetailElementModel;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.text.LanguageTag;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.control.DisplayController;
import com.amazon.kindle.control.widget.DCPagedLandingPanel;
import com.amazon.kindle.device.KeyboardLayout;
import com.amazon.kindle.restricted.device.LocalizationServices;
import com.amazon.kindle.settings.SettingsBooklet;
import com.amazon.kindle.settings.view.dictionary.DictionaryLanguagesDisplayController;
import com.amazon.kindle.settings.view.keyboard.KeyboardDisplayController;
import com.amazon.kindle.settings.view.language.LanguageDisplayController;
import com.amazon.kindle.settings.view.settings.DefaultSettingsDisplayController;
import com.amazon.kindle.settings.view.settings.SettingsElementView;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class InternationalDisplayController
extends DefaultSettingsDisplayController {
    private static final Log l = Log.getInstance((String)"InternationalDisplayController");
    public static final String k = "INTERNATIONAL";
    private DetailElementModel m;
    private DetailElementModel h;
    private DetailElementModel A;
    private SettingsElementView H;
    private SettingsElementView b;
    private SettingsElementView K;

    public static synchronized InternationalDisplayController getInstance(SettingsBooklet a) {
        Object a2 = a.getDisplayController(k);
        if (a2 == null) {
            a2 = new InternationalDisplayController(a);
            a.addDisplayController(k, (DisplayController)a2);
        }
        return (InternationalDisplayController)((Object)a2);
    }

    private InternationalDisplayController(SettingsBooklet a) {
        super(a);
        InternationalDisplayController a2;
    }

    public String getViewKey() {
        return k;
    }

    public void willLoad() {
        InternationalDisplayController a;
        super.willLoad();
        a.setupKeyboards(true);
    }

    protected void initPanel() {
        InternationalDisplayController a;
        a.setupLanguage();
        a.setupKeyboards(false);
        a.setupDictionaries();
        ArrayList<SettingsElementView> a2 = new ArrayList<SettingsElementView>();
        a2.add(a.H);
        a2.add(a.b);
        a2.add(a.K);
        a.B = new DCPagedLandingPanel(a.booklet, a2);
        a.B.setHeaderBarEnabled(true);
        a.B.setLayoutParams(true, (int)K, (int)b);
        a.B.initGUI();
    }

    protected String getHeaderBarText() {
        return ResourceBundle.getBundle("com.amazon.kindle.settings.resources.InternationalResources").getString("header");
    }

    private void setupLanguage() {
        InternationalDisplayController a;
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.InternationalResources");
        AbstractAction a3 = new AbstractAction(){
            {
                1 a;
            }

            public void actionPerformed(ActionEvent a) {
                1 a2;
                LanguageDisplayController.getInstance((SettingsBooklet)a2.InternationalDisplayController.this.booklet).switchTo();
            }
        };
        a.m = new DefaultDetailElementModel(a2.getString("language.name.label"), a2.getString("language.description.label"), (Action)a3);
        if (a.booklet == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        BookletContext a4 = a.booklet.getBookletContext();
        if (a4 == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        LocalizationServices a5 = (LocalizationServices)a4.getService(LocalizationServices.class);
        a.m.addProperty("DEVICE_LANGUAGE", a2.getString("language.property.name"), (Object)a5.getDisplayName(LanguageTag.toLanguage((Locale)Locale.getDefault())));
        a.H = new SettingsElementView(a.m);
    }

    private void setupKeyboards(boolean a) {
        InternationalDisplayController a2;
        ResourceBundle a3 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.InternationalResources");
        if (a2.booklet == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        BookletContext a4 = a2.booklet.getBookletContext();
        if (a4 == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        List a5 = ((KeyboardLayout)a4.getService(KeyboardLayout.class)).getSelectedLayouts();
        if (a5 == null || a5.isEmpty()) {
            l.error("no selected keyboard layouts");
        } else if (!a) {
            AbstractAction a6 = new AbstractAction(){
                {
                    2 a;
                }

                public void actionPerformed(ActionEvent a) {
                    2 a2;
                    KeyboardDisplayController.getInstance((SettingsBooklet)a2.InternationalDisplayController.this.booklet).switchTo();
                }
            };
            a2.h = new DefaultDetailElementModel(a3.getString("keyboard.name.label"), a3.getString("keyboard.description.label"), (Action)a6);
            a2.h.addProperty("SELECTED_KEYBOARDS", a3.getString("keyboard.property.name"), (Object)MessageFormat.format(a3.getString("keyboard.property.value.pattern"), new Integer(a5.size())));
            a2.b = new SettingsElementView(a2.h);
        } else {
            a2.h.addProperty("SELECTED_KEYBOARDS", a3.getString("keyboard.property.name"), (Object)MessageFormat.format(a3.getString("keyboard.property.value.pattern"), new Integer(a5.size())));
            a2.h.refresh();
        }
    }

    private void setupDictionaries() {
        InternationalDisplayController a;
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.InternationalResources");
        AbstractAction a3 = new AbstractAction(){
            {
                3 a;
            }

            public void actionPerformed(ActionEvent a) {
                3 a2;
                DictionaryLanguagesDisplayController.getInstance((SettingsBooklet)a2.InternationalDisplayController.this.booklet).switchTo();
            }
        };
        a.A = new DefaultDetailElementModel(a2.getString("dictionary.name.label"), a2.getString("dictionary.description.label"), (Action)a3);
        a.K = new SettingsElementView(a.A);
    }
}

