/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.settings.view.dictionary;

import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.dictionary.Dictionary;
import com.amazon.ebook.booklet.reader.sdk.event.EventHandler;
import com.amazon.ebook.util.text.LanguageTag;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.control.DisplayController;
import com.amazon.kindle.control.widget.DCListLandingPanel;
import com.amazon.kindle.control.widget.JListDataTransferObject;
import com.amazon.kindle.settings.SettingsBooklet;
import com.amazon.kindle.settings.view.dictionary.DictionaryUpdateHandler;
import com.amazon.kindle.settings.view.settings.DefaultSettingsDisplayController;
import java.awt.event.ActionEvent;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class SelectDictionaryDisplayController
extends DefaultSettingsDisplayController {
    public static final String H = "SELECT_DICTIONARY";
    private DictionaryUpdateHandler b;
    private ReaderSDK K;
    private String B;

    public static synchronized SelectDictionaryDisplayController getInstance(SettingsBooklet a) {
        Object a2 = a.getDisplayController(H);
        if (a2 == null) {
            a2 = new SelectDictionaryDisplayController(a);
            a.addDisplayController(H, (DisplayController)a2);
        }
        return (SelectDictionaryDisplayController)((Object)a2);
    }

    private SelectDictionaryDisplayController(SettingsBooklet a) {
        super(a);
        SelectDictionaryDisplayController a2;
    }

    public String getViewKey() {
        return H;
    }

    public void load() {
        SelectDictionaryDisplayController a;
        if (a.booklet == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        BookletContext a2 = a.booklet.getBookletContext();
        if (a2 == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        super.load();
        a.b = new DictionaryUpdateHandler(a);
        a.b.setMetadata(a.B);
        a.K = (ReaderSDK)a2.getService(ReaderSDK.class);
        a.K.getRegistry().registerHandler((EventHandler)a.b);
        Object[] a3 = a.getDictionaryTransferObjects();
        if (a3 != null) {
            a.B = new DCListLandingPanel(a.getBooklet(), a3, true);
            a.B.setHeaderBarEnabled(true);
            a.B.setOKAction(a.getChangeDictionaryAction());
            a.B.setCancelAction((Action)new AbstractAction(){
                {
                    1 a;
                }

                public void actionPerformed(ActionEvent a) {
                    1 a2;
                    a2.SelectDictionaryDisplayController.this.booklet.loadPreviousView();
                }
            });
            a.B.initGUI();
        } else {
            a.booklet.loadPreviousView();
        }
    }

    public void loadData(Object a) {
        if (a == null) {
            throw new NullPointerException("null:load object");
        }
        if (!(a instanceof String)) {
            throw new IllegalArgumentException("load object must be a String");
        }
        a.B = (String)a;
    }

    public void unload() {
        SelectDictionaryDisplayController a;
        super.unload();
        a.K.getRegistry().deregisterHandler((EventHandler)a.b);
        a.b = null;
        a.K = null;
        a.B = null;
    }

    public boolean shouldMarkHistory() {
        return false;
    }

    protected void initPanel() {
    }

    protected String getHeaderBarText() {
        SelectDictionaryDisplayController a;
        return MessageFormat.format(ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DictionaryResources").getString("selectdictionary.header.template"), LanguageTag.toLocale((String)a.B).getDisplayLanguage(Locale.getDefault()));
    }

    private Object[] getDictionaryTransferObjects() {
        Iterator a;
        SelectDictionaryDisplayController a2;
        List a3 = a2.K.getDictionaryManager().getAvailableDictionariesByLanguage(a2.B);
        if (a3 == null || a3.isEmpty()) {
            return null;
        }
        ArrayList a4 = new ArrayList();
        a4.addAll(a3);
        final Collator a5 = Collator.getInstance();
        Collections.sort(a4, new Comparator(){
            {
                2 a;
            }

            public int compare(Object a, Object a2) {
                2 a3;
                return a3.a5.compare(((Dictionary)a).getCollationTitle(), ((Dictionary)a2).getCollationTitle());
            }
        });
        Object[] a6 = new Object[a4.size()];
        int a7 = 0;
        Iterator iterator = a = a4.iterator();
        while (iterator.hasNext()) {
            Dictionary a8 = (Dictionary)a.next();
            JListDataTransferObject a9 = new JListDataTransferObject(a8.getUniqueID(), a8.getCollationTitle(), a2.isDefaultDictionary(a8));
            a9.setMetadata((Object)a8);
            a6[a7] = a9;
            ++a7;
            iterator = a;
        }
        return a6;
    }

    private boolean isDefaultDictionary(Dictionary a) {
        SelectDictionaryDisplayController a2;
        if (a2.booklet == null) {
            LogUtils.logBookletIsNull();
            return false;
        }
        BookletContext a3 = a2.booklet.getBookletContext();
        if (a3 == null) {
            LogUtils.logBookletContextIsNull();
            return false;
        }
        ReaderSDK a4 = (ReaderSDK)a3.getService(ReaderSDK.class);
        if (a4 == null || a4.getDictionaryManager() == null) {
            return false;
        }
        return a.equals(a4.getDictionaryManager().getDefaultDictionary(a2.B));
    }

    private Action getChangeDictionaryAction() {
        SelectDictionaryDisplayController a;
        return new AbstractAction(){
            {
                3 a;
            }

            public void actionPerformed(ActionEvent a) {
                3 a2;
                JListDataTransferObject a3 = (JListDataTransferObject)((DCListLandingPanel)a2.SelectDictionaryDisplayController.this.B).getSelectedValue();
                Dictionary a4 = (Dictionary)a3.getMetadata();
                if (a4 != null && !a2.SelectDictionaryDisplayController.this.isDefaultDictionary(a4)) {
                    a2.SelectDictionaryDisplayController.this.K.getDictionaryManager().setDefaultDictionary(a4);
                }
                a2.SelectDictionaryDisplayController.this.booklet.loadPreviousView();
            }
        };
    }
}

