/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.settings.view.diagnostic;

import com.amazon.agui.swing.ConfirmationDialog;
import com.amazon.ebook.util.log.Log;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.apps.util.NetworkUtils;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.control.DisplayController;
import com.amazon.kindle.control.widget.JListDataTransferObject;
import com.amazon.kindle.net.Wireless;
import com.amazon.kindle.restricted.net.wan.CarrierServiceException;
import com.amazon.kindle.restricted.net.wan.Wan;
import com.amazon.kindle.restricted.net.wan.WanCarrierInfo;
import com.amazon.kindle.restricted.net.wan.WanCarrierService;
import com.amazon.kindle.settings.SettingsBooklet;
import com.amazon.kindle.settings.mcs.CarriersController;
import com.amazon.kindle.settings.view.diagnostic.DiagnosticDisplayController;
import com.amazon.kindle.settings.view.diagnostic.ThreeOneOneScannedPanel;
import com.amazon.kindle.settings.view.diagnostic.ThreeOneOneScanningPanel;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JPanel;

public class ThreeOneOneDisplayController
extends DiagnosticDisplayController {
    public static final String F = "SCANNED_VIEW";
    public static final String L = ";311";
    private static final Log c = Log.getInstance((String)"ThreeOneOneDisplayController");
    public static final String l = "311";
    private CarriersController k;
    private String m;
    private JPanel h;
    private boolean A;
    private boolean H;
    private boolean b;
    private boolean K;

    public static synchronized ThreeOneOneDisplayController getInstance(SettingsBooklet a) {
        Object a2 = a.getDisplayController(l);
        if (a2 == null) {
            a2 = new ThreeOneOneDisplayController(a);
            a.addDisplayController(l, (DisplayController)a2);
        }
        return (ThreeOneOneDisplayController)((Object)a2);
    }

    private ThreeOneOneDisplayController(SettingsBooklet a) {
        super(a);
        ThreeOneOneDisplayController a2;
    }

    public void load() {
        ThreeOneOneDisplayController a;
        super.load();
        if (a.H) {
            a.h = a.getScannedPanel();
        } else {
            ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DiagnosticResources");
            AbstractAction a3 = new AbstractAction(){
                {
                    1 a;
                }

                public void actionPerformed(ActionEvent a) {
                    1 a2;
                    a2.ThreeOneOneDisplayController.this.k.stopScanning();
                    a2.ThreeOneOneDisplayController.this.K = true;
                    a2.ThreeOneOneDisplayController.this.booklet.loadPreviousView();
                }
            };
            a.h = new ThreeOneOneScanningPanel(a2.getString("311.header.dnt"), a2.getString("311.scanning.label.dnt"), a3, a2.getString("311.button.label.cancel.dnt"));
            a.k = new CarriersController((SettingsBooklet)a.booklet);
            a.k.startScanning();
        }
    }

    public void loadData(Object a) {
        if (a != null && a instanceof String) {
            a.H = F.equals((String)a);
        }
    }

    public void unload() {
        ThreeOneOneDisplayController a;
        super.unload();
        if (a.H && !a.b) {
            a.k.closeCarriersService();
        } else if (!(a.H || a.A || a.K)) {
            a.k.stopScanning();
        }
        if (!a.A) {
            a.k = null;
        }
        a.H = false;
        a.b = false;
        a.A = false;
        a.K = false;
        a.h = null;
    }

    public JPanel getPanel() {
        ThreeOneOneDisplayController a;
        return a.h;
    }

    public String getViewKey() {
        return l;
    }

    public String getHeaderBarText() {
        return ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DiagnosticResources").getString("311.header.dnt");
    }

    public void switchTo(Object a) {
        ThreeOneOneDisplayController a2;
        if (a != null && a instanceof String) {
            a2.A = F.equals((String)a);
        }
        super.switchTo(a, false);
    }

    public void switchTo(Object a, boolean a2) {
        block12: {
            ThreeOneOneDisplayController a3;
            if (NetworkUtils.hasWan((Booklet)a3.booklet)) {
                try {
                    if (a3.booklet == null) {
                        LogUtils.logBookletIsNull();
                        return;
                    }
                    BookletContext a4 = a3.booklet.getBookletContext();
                    if (a4 == null) {
                        LogUtils.logBookletContextIsNull();
                        return;
                    }
                    if (!((Wan)a4.getService(Wan.class)).getRadioTechnology().equals((Object)Wan.RadioTechnology.D)) {
                        if (Log.isDebugOn()) {
                            c.debug("311 NOT supported on a non-GSM-based device");
                        }
                        return;
                    }
                    Wireless a5 = (Wireless)a4.getService(Wireless.class);
                    if (a5.showWirelessRequiredDialog()) {
                        ResourceBundle a6 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DiagnosticResources");
                        int a7 = ConfirmationDialog.showDialog((String)a3.booklet.getName(), (String)a6.getString("311.switch.provider.msg.label.dnt"), (String)a6.getString("311.switch.provider.title.label.dnt"), (int)1);
                        if (a7 == 0) {
                            ThreeOneOneDisplayController.super.switchTo(a, a2);
                        } else {
                            a3.booklet.loadPreviousView();
                        }
                        break block12;
                    }
                    a3.booklet.loadPreviousView();
                }
                catch (Exception a8) {
                    c.error(Log.CATCHALL_EX, null, "", (Throwable)a8);
                }
            } else if (Log.isDebugOn()) {
                c.debug("Device is not wan enabled. Cannot bring up 311 page");
            }
        }
    }

    private Object[] get311TransferObjects() {
        int a;
        ThreeOneOneDisplayController a2;
        List a3 = a2.k.getCarriers();
        ResourceBundle a4 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DiagnosticResources");
        String a5 = a4.getString("311.display.template.dnt");
        JListDataTransferObject a6 = new JListDataTransferObject(null, a4.getString("311.switch.automatically.label.dnt"), true);
        Object[] objectArray = new Object[a3.size() + 1];
        Object[] a7 = objectArray;
        objectArray[0] = a6;
        int n = a = 0;
        while (n < a3.size()) {
            WanCarrierInfo a8 = (WanCarrierInfo)a3.get(a);
            a6 = new JListDataTransferObject(a8.getCarrierID(), MessageFormat.format(a5, new Integer(a + 1), a2.getCarrierNameWithTechnology(a8)), false);
            if (a == a2.k.getCurrentCarrierIndex()) {
                a2.m = a6.getDisplay();
            }
            a7[a + 1] = a6;
            n = ++a;
        }
        return a7;
    }

    private String getCarrierNameWithTechnology(WanCarrierInfo a) {
        if (a == null) {
            throw new NullPointerException("carrier");
        }
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DiagnosticResources");
        String a3 = a.getName();
        String a4 = null;
        WanCarrierInfo.AccessTechnology a5 = a.getTechnology();
        if (a5.equals((Object)WanCarrierInfo.AccessTechnology.h)) {
            a4 = a2.getString("311.technology.gsm.dnt");
        } else if (a5.equals((Object)WanCarrierInfo.AccessTechnology.A)) {
            a4 = a2.getString("311.technology.gsm.compact.dnt");
        } else if (a5.equals((Object)WanCarrierInfo.AccessTechnology.H)) {
            a4 = a2.getString("311.technology.utran.dnt");
        } else if (a5.equals((Object)WanCarrierInfo.AccessTechnology.b)) {
            a4 = a2.getString("311.technology.gsm.egprs.dnt");
        } else if (a5.equals((Object)WanCarrierInfo.AccessTechnology.K)) {
            a4 = a2.getString("311.technology.utran.hsdpa.dnt");
        } else if (a5.equals((Object)WanCarrierInfo.AccessTechnology.B)) {
            a4 = a2.getString("311.technology.utran.hsupa.dnt");
        } else if (a5.equals((Object)WanCarrierInfo.AccessTechnology.D)) {
            a4 = a2.getString("311.technology.utran.hsdpa.hsupa.dnt");
        }
        if (a4 == null) {
            return a3;
        }
        return MessageFormat.format(a2.getString("311.technology.template.dnt"), a3, a4);
    }

    private ThreeOneOneScannedPanel getScannedPanel() {
        ThreeOneOneDisplayController a;
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DiagnosticResources");
        final ThreeOneOneScannedPanel a3 = new ThreeOneOneScannedPanel((SettingsBooklet)a.booklet, a2.getString("311.header.dnt"), a.get311TransferObjects(), MessageFormat.format(a2.getString("311.message.template.dnt"), a.m));
        a3.setOKButtonAction(new AbstractAction(){
            {
                2 a;
            }

            public void actionPerformed(ActionEvent a) {
                2 a2;
                Object a32 = a2.a3.getSelectedOption();
                if (a32 instanceof JListDataTransferObject) {
                    String a4 = ((JListDataTransferObject)a32).getTag();
                    new Thread(new SetCarrierController(a4)).start();
                }
                a2.ThreeOneOneDisplayController.this.b = true;
                a2.ThreeOneOneDisplayController.this.booklet.loadPreviousView();
            }
        });
        a3.setOKButtonLabel(a2.getString("311.button.label.ok.dnt"));
        a3.setCloseButtonAction(new AbstractAction(){
            {
                3 a;
            }

            public void actionPerformed(ActionEvent a) {
                3 a2;
                a2.ThreeOneOneDisplayController.this.k.closeCarriersService();
                a2.ThreeOneOneDisplayController.this.b = true;
                a2.ThreeOneOneDisplayController.this.booklet.loadPreviousView();
            }
        });
        a3.setCloseButtonLabel(a2.getString("311.button.label.cancel.dnt"));
        a3.initGUI();
        return a3;
    }

    private class SetCarrierController
    implements Runnable {
        private String B;

        public SetCarrierController(String a) {
            SetCarrierController a2;
            a2.B = a;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block10: {
                SetCarrierController a;
                if (a.ThreeOneOneDisplayController.this.booklet == null) {
                    LogUtils.logBookletIsNull();
                    return;
                }
                BookletContext a2 = a.ThreeOneOneDisplayController.this.booklet.getBookletContext();
                if (a2 == null) {
                    LogUtils.logBookletContextIsNull();
                    return;
                }
                WanCarrierService a3 = ((Wan)a2.getService(B == null ? (B = ThreeOneOneDisplayController.class$("com.amazon.kindle.restricted.net.wan.Wan")) : B)).getCarrierService();
                a3.selectCarrier(a.B);
                Object var6_3 = null;
                try {
                    a3.close();
                }
                catch (CarrierServiceException a4) {
                    c.error("Failed to close the service", (Throwable)a4);
                }
                break block10;
                {
                    catch (CarrierServiceException a5) {
                        c.error("Failed to set the carrier", (Throwable)a5);
                        Object var6_4 = null;
                        try {
                            a3.close();
                        }
                        catch (CarrierServiceException a4) {
                            c.error("Failed to close the service", (Throwable)a4);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    try {
                        a3.close();
                    }
                    catch (CarrierServiceException a4) {
                        c.error("Failed to close the service", (Throwable)a4);
                    }
                    throw throwable;
                }
            }
        }
    }
}

