/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.settings.view.deviceoptions;

import com.amazon.agui.swing.DefaultDetailElementModel;
import com.amazon.agui.swing.DetailElementModel;
import com.amazon.ebook.util.text.StringUtil;
import com.amazon.kindle.apps.util.CommunicationUtils;
import com.amazon.kindle.apps.util.GestureDispatchUtils;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.apps.util.NetworkUtils;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.control.DisplayController;
import com.amazon.kindle.control.widget.DCPagedLandingPanel;
import com.amazon.kindle.identity.Marketplace;
import com.amazon.kindle.settings.SettingsBooklet;
import com.amazon.kindle.settings.dialog.DeviceNameDialog;
import com.amazon.kindle.settings.dialog.DeviceTimeDialog;
import com.amazon.kindle.settings.property.DeviceTimeAction;
import com.amazon.kindle.settings.property.PersonalInfoAction;
import com.amazon.kindle.settings.util.PasscodeUtils;
import com.amazon.kindle.settings.view.passcode.PasscodeDisplayController;
import com.amazon.kindle.settings.view.settings.DefaultSettingsDisplayController;
import com.amazon.kindle.settings.view.settings.SettingsElementView;
import com.amazon.kindle.webservices.registration.AmazonRegistrationService;
import com.amazon.kindle.webservices.registration.RegistrationEvent;
import com.amazon.kindle.webservices.registration.RegistrationListener;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class DeviceOptionsDisplayController
extends DefaultSettingsDisplayController
implements RegistrationListener {
    public static final String F = "DEVICE_OPTIONS";
    private DetailElementModel L;
    private DetailElementModel c;
    private DetailElementModel l;
    private DetailElementModel k;
    private DetailElementModel m;
    private SettingsElementView h;
    private SettingsElementView A;
    private SettingsElementView H;
    private SettingsElementView b;
    private SettingsElementView K;

    public static synchronized DeviceOptionsDisplayController getInstance(SettingsBooklet a) {
        Object a2 = a.getDisplayController(F);
        if (a2 == null) {
            a2 = new DeviceOptionsDisplayController(a);
            a.addDisplayController(F, (DisplayController)a2);
        }
        return (DeviceOptionsDisplayController)((Object)a2);
    }

    private DeviceOptionsDisplayController(SettingsBooklet a) {
        super(a);
        DeviceOptionsDisplayController a2;
    }

    public String getViewKey() {
        return F;
    }

    public void willLoad() {
        DeviceOptionsDisplayController a;
        super.willLoad();
        a.setupDevicePasscode(true);
        a.setupDeviceName(true);
        a.setupDeviceEmail(true);
        a.setupPersonalInfo(true);
    }

    public void load() {
        DeviceOptionsDisplayController a;
        if (a.booklet == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        BookletContext a2 = a.booklet.getBookletContext();
        if (a2 == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        super.load();
        ((AmazonRegistrationService)a2.getService(AmazonRegistrationService.class)).addRegistrationListener((RegistrationListener)a);
    }

    public void unload() {
        DeviceOptionsDisplayController a;
        if (a.booklet == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        BookletContext a2 = a.booklet.getBookletContext();
        if (a2 == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        super.unload();
        ((AmazonRegistrationService)a2.getService(AmazonRegistrationService.class)).removeRegistrationListener((RegistrationListener)a);
    }

    public void onRegistrationInfoChanged(RegistrationEvent a) {
        DeviceOptionsDisplayController a2;
        RegistrationEvent.RegistrationEventType a3 = a.getEventType();
        if (a3.equals((Object)RegistrationEvent.RegistrationEventType.DEVICE_NAME_CHANGED)) {
            SwingUtilities.invokeLater(new Runnable(){
                {
                    1 a;
                }

                public void run() {
                    1 a;
                    a.DeviceOptionsDisplayController.this.setupDeviceName(true);
                    a.DeviceOptionsDisplayController.this.setupDeviceEmail(true);
                }
            });
        } else if (a3.equals((Object)RegistrationEvent.RegistrationEventType.DEREGISTERED)) {
            a2.booklet.loadPreviousView();
        }
    }

    protected void initPanel() {
        DeviceOptionsDisplayController a;
        a.setupDevicePasscode(false);
        a.setupDeviceTime();
        a.setupDeviceName(false);
        a.setupPersonalInfo(false);
        a.setupDeviceEmail(false);
        ArrayList<SettingsElementView> a2 = new ArrayList<SettingsElementView>();
        a2.add(a.h);
        a2.add(a.A);
        a2.add(a.H);
        a2.add(a.b);
        a2.add(a.K);
        a.B = new DCPagedLandingPanel(a.booklet, a2);
        a.B.setHeaderBarEnabled(true);
        a.B.setLayoutParams(true, (int)K, (int)b);
        a.B.initGUI();
    }

    protected String getHeaderBarText() {
        return ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DeviceOptionsResources").getString("header");
    }

    private void setupDevicePasscode(boolean a) {
        DeviceOptionsDisplayController a2;
        String a3;
        ResourceBundle a4 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DeviceOptionsResources");
        String string = a3 = PasscodeUtils.isPasscodeEnabled((Booklet)a2.booklet) ? a4.getString("passcode.property.value.enabled") : a4.getString("passcode.property.value.disabled");
        if (a) {
            a2.L.addProperty("DEVICE_PASSCODE", a4.getString("passcode.property.name"), (Object)a3);
            a2.L.refresh();
        } else {
            AbstractAction a5 = new AbstractAction(){
                {
                    2 a;
                }

                public void actionPerformed(ActionEvent a) {
                    if (GestureDispatchUtils.isReady()) {
                        2 a2;
                        PasscodeDisplayController.getInstance((SettingsBooklet)a2.DeviceOptionsDisplayController.this.booklet).switchTo();
                    }
                }
            };
            a2.L = new DefaultDetailElementModel(a4.getString("passcode.name.label"), a4.getString("passcode.description.label"), (Action)a5);
            a2.L.addProperty("DEVICE_PASSCODE", a4.getString("passcode.property.name"), (Object)a3);
            a2.h = new SettingsElementView(a2.L);
        }
    }

    private void setupDeviceTime() {
        DeviceOptionsDisplayController a;
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DeviceOptionsResources");
        a.c = new DefaultDetailElementModel(a2.getString("devicetime.name.label"), a2.getString("devicetime.description.label"), null);
        if (NetworkUtils.hasWan((Booklet)a.booklet)) {
            DeviceTimeAction a3 = new DeviceTimeAction((SettingsBooklet)a.booklet);
            a.c.setAction((Action)a3);
            a.c.addProperty("DEVICE_TIME", a2.getString("devicetime.property.name"), a3.getActionState());
        } else {
            AbstractAction a4 = new AbstractAction(){
                {
                    3 a;
                }

                public void actionPerformed(ActionEvent a) {
                    if (GestureDispatchUtils.isReady()) {
                        3 a2;
                        new DeviceTimeDialog((Booklet)a2.DeviceOptionsDisplayController.this.booklet).postDialog();
                    }
                }
            };
            a.c.setAction((Action)a4);
        }
        a.A = new SettingsElementView(a.c);
    }

    private void setupPersonalInfo(boolean a) {
        DeviceOptionsDisplayController a2;
        ResourceBundle a3 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DeviceOptionsResources");
        if (a) {
            a2.k.addProperty("PERSONAL_INFO", a3.getString("personalinfo.property.name"), ((PersonalInfoAction)a2.k.getItemAction()).getActionState());
            a2.k.refresh();
        } else {
            PersonalInfoAction a4 = new PersonalInfoAction((SettingsBooklet)a2.booklet);
            a2.k = new DefaultDetailElementModel(a3.getString("personalinfo.name.label"), a3.getString("personalinfo.description.label"), (Action)a4);
            a2.k.addProperty("PERSONAL_INFO", a3.getString("personalinfo.property.name"), a4.getActionState());
            a2.b = new SettingsElementView(a2.k);
        }
    }

    private void setupDeviceName(boolean a) {
        DeviceOptionsDisplayController a2;
        ResourceBundle a3 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DeviceOptionsResources");
        String a4 = a3.getString("devicename.property.name");
        String a5 = CommunicationUtils.getDeviceName((Booklet)a2.booklet);
        if (a) {
            a2.l.addProperty("DEVICE_NAME", a4, (Object)a5);
            a2.l.refresh();
        } else {
            AbstractAction a6 = new AbstractAction(){
                {
                    4 a;
                }

                public void actionPerformed(ActionEvent a) {
                    if (GestureDispatchUtils.isReady()) {
                        4 a2;
                        new DeviceNameDialog((SettingsBooklet)a2.DeviceOptionsDisplayController.this.booklet).postDialog();
                    }
                }
            };
            a2.l = new DefaultDetailElementModel(a3.getString("devicename.name.label"), a3.getString("devicename.description.label"), (Action)a6);
            a2.l.addProperty("DEVICE_NAME", a4, (Object)a5);
            a2.H = new SettingsElementView(a2.l);
        }
    }

    private void setupDeviceEmail(boolean a) {
        String a2;
        DeviceOptionsDisplayController a3;
        ResourceBundle a4 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DeviceOptionsResources");
        String a5 = CommunicationUtils.getEmail((Booklet)a3.booklet);
        String string = a2 = a5 != null ? a5 : a4.getString("email.property.value.default");
        if (a) {
            BookletContext a6 = a3.booklet.getBookletContext();
            if (a6 == null) {
                LogUtils.logBookletContextIsNull();
                return;
            }
            Marketplace a7 = (Marketplace)a6.getService(Marketplace.class);
            String a8 = null;
            boolean a9 = false;
            if (a7 != null) {
                a8 = StringUtil.getDisplayFriendlyURL((String)a7.getItem("url.myk"));
                if (!StringUtil.isEmpty((String)a8)) {
                    a3.m = new DefaultDetailElementModel(a4.getString("email.name.label"), MessageFormat.format(a4.getString("email.description.label.myk"), a8), null);
                    a3.m.addProperty("DEVICE_EMAIL", a4.getString("email.property.name"), (Object)a2);
                    a3.K.setModel(a3.m);
                } else {
                    a9 = true;
                }
            } else {
                a9 = true;
            }
            if (a9) {
                a3.m.addProperty("DEVICE_EMAIL", a4.getString("email.property.name"), (Object)a2);
                a3.m.refresh();
            }
        } else {
            a3.m = new DefaultDetailElementModel(a4.getString("email.name.label"), a4.getString("email.description.label"), null);
            a3.m.addProperty("DEVICE_EMAIL", a4.getString("email.property.name"), (Object)a2);
            a3.K = new SettingsElementView(a3.m);
        }
    }
}

