/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.settings.util;

import com.amazon.ebook.util.log.Log;
import com.amazon.kindle.apps.util.CommunicationUtils;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.identity.KindleIdentity;
import com.amazon.kindle.identity.VersionInfo;
import com.amazon.kindle.restricted.runtime.Const;
import com.amazon.kindle.settings.SettingsBooklet;
import java.io.File;
import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;

public class DiagnosticUtils {
    private static final Log H = Log.getInstance((String)"DiagnosticUtils");
    private static final String b = "certs/client.p12";
    private static final DateFormat K = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.US);

    private DiagnosticUtils() {
        DiagnosticUtils a;
    }

    public static String getDeviceInfoString(SettingsBooklet a) {
        return DiagnosticUtils.getDeviceInfoString(a, false);
    }

    public static String getDeviceInfoString(SettingsBooklet a, boolean a2) {
        ResourceBundle a3 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.UtilResources");
        if (a == null) {
            LogUtils.logBookletIsNull();
            return a2 ? a3.getString("text.611.pattern.empty.dnt") : a3.getString("text.pattern.empty.dnt");
        }
        BookletContext a4 = a.getBookletContext();
        if (a4 == null) {
            LogUtils.logBookletContextIsNull();
            return a2 ? a3.getString("text.611.pattern.empty.dnt") : a3.getString("text.pattern.empty.dnt");
        }
        MessageFormat a5 = new MessageFormat(a2 ? a3.getString("text.611.pattern.dnt") : a3.getString("text.pattern.dnt"));
        ChoiceFormat a6 = new ChoiceFormat(a3.getString("yes.no.format.dnt"));
        int a7 = CommunicationUtils.isRegistered((Booklet)a) ? 1 : 0;
        int a8 = DiagnosticUtils.hasCertificate() ? 1 : 0;
        K.setTimeZone(TimeZone.getDefault());
        KindleIdentity a9 = (KindleIdentity)a4.getService(KindleIdentity.class);
        String a10 = "";
        try {
            a10 = a9.getDeviceSerialID();
        }
        catch (Exception a11) {
            H.error(Log.CATCHALL_EX, null, "error getting device serial id", (Throwable)a11);
        }
        VersionInfo a12 = (VersionInfo)a4.getService(VersionInfo.class);
        Object[] a13 = new Object[]{a10, a12.getPrettyVersionString(), a6.format(a7), a6.format(a8), K.format(new Date())};
        return a5.format(a13);
    }

    private static boolean hasCertificate() {
        StringBuffer a = new StringBuffer();
        a.append(Const.getInstance().getWritablePreferencesDirectory());
        a.append(File.separator);
        a.append(b);
        try {
            File a2 = new File(a.toString());
            if (a2.isFile()) {
                return true;
            }
        }
        catch (Exception a3) {
            H.error("Unable to check for certificate file", (Throwable)a3);
        }
        return false;
    }
}

