/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.settings.dialog;

import com.amazon.agui.swing.CommandBar;
import com.amazon.agui.swing.ConfirmationDialog;
import com.amazon.agui.swing.KDialog;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import com.amazon.ebook.util.thread.ThreadPool;
import com.amazon.kindle.apps.util.ComponentUtils;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.booklet.ChromeException;
import com.amazon.kindle.booklet.ChromeHeaderBar;
import com.amazon.kindle.control.behavior.event.WirelessCancelEvent;
import com.amazon.kindle.control.util.DialogUtils;
import com.amazon.kindle.keyboard.KeyboardUtils;
import com.amazon.kindle.net.BrowserLoginRequiredException;
import com.amazon.kindle.net.NoConnectionException;
import com.amazon.kindle.net.ServerException;
import com.amazon.kindle.net.Wireless;
import com.amazon.kindle.settings.util.RegistrationUtils;
import com.amazon.kindle.webservices.registration.AmazonRegistrationService;
import com.amazon.kindle.webservices.registration.AuthenticationFailedException;
import com.amazon.kindle.webservices.registration.CustomerNotFoundException;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class RegistrationDialog
extends KDialog {
    private static final Log LOG = Log.getInstance((String)"RegistrationDialog");
    private static final LogMessage REG_EX = new LogMessage("RegistrationFailed", new String[]{"reason"});
    private static final LogMessage CHROME_EX = new LogMessage("ActivityIndicatorFailed", new String[]{"reason", "action"});
    private static final LogMessage AWT_EX = new LogMessage("AWTInvokeAndWaitFailed", new String[]{"action"});
    private static final String REG_SCAN_CLIENT_ID = "REG_SCAN_CLIENT_ID";
    private static final int SPINNER_TIMEOUT = 100000;
    private static final int SPINNER_DELAY = 0;
    private volatile JTextField mEmailField;
    private volatile JPasswordField mPasswordField;
    private volatile Booklet mBooklet;
    private volatile JButton mRegisterButton;
    private volatile JButton mCancelButton;
    private String mEmailAddress;
    private RegistrationKeyAdapter mKeyAdapter;
    private RegistrationDocumentListener mDocListener;
    static /* synthetic */ Class class$com$amazon$kindle$net$Wireless;
    static /* synthetic */ Class class$com$amazon$kindle$webservices$registration$AmazonRegistrationService;
    static /* synthetic */ Class class$com$amazon$kindle$booklet$ChromeHeaderBar;

    public RegistrationDialog(Booklet a) {
        a2(a, null);
        RegistrationDialog a2;
    }

    private RegistrationDialog(Booklet a, String a2) {
        super(a.getBookletContext().getName(), true, "web");
        RegistrationDialog a3;
        a3.mBooklet = a;
        a3.mEmailAddress = a2;
        a3.mKeyAdapter = a3.new RegistrationKeyAdapter();
        a3.mDocListener = a3.new RegistrationDocumentListener();
        a3.initGUI();
    }

    private void initGUI() {
        RegistrationDialog a;
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DialogResources");
        a.setCloseIconButtonEnabled(false);
        a.setTitleBarEnabled(true);
        a.setTitle(a2.getString("register.title.label"));
        Container a3 = a.getContentPane();
        a3.setLayout(new GridBagLayout());
        JTextArea a4 = ComponentUtils.getDefaultTextArea((String)a2.getString("register.message.label"), null, null, null);
        a.mEmailField = new JTextField();
        KeyboardUtils.configure((JComponent)a.mEmailField, (String)":web:");
        JPanel a5 = ComponentUtils.LabeledTextField.getInstance((String)a2.getString("register.email.label"), (JTextField)a.mEmailField, (int)1);
        a.mEmailField.setDocument((Document)DialogUtils.getLimitedCharacterDocument((int)254));
        if (a.mEmailAddress != null) {
            a.mEmailField.setText(a.mEmailAddress);
        }
        a.mEmailField.addKeyListener(a.mKeyAdapter);
        a.mEmailField.getDocument().addDocumentListener(a.mDocListener);
        a.mPasswordField = new JPasswordField();
        a.mPasswordField.setDocument((Document)DialogUtils.getLimitedCharacterDocument((int)254));
        JPanel a6 = ComponentUtils.LabeledTextField.getInstance((String)a2.getString("register.password.label"), (JTextField)a.mPasswordField, (int)1);
        a.mPasswordField.addKeyListener(a.mKeyAdapter);
        a.mPasswordField.getDocument().addDocumentListener(a.mDocListener);
        a3.add((Component)a4, (GridBagConstraints)a2.getObject("register.message.constraints"));
        a3.add((Component)a5, (GridBagConstraints)a2.getObject("register.email.constraints"));
        a3.add((Component)a6, (GridBagConstraints)a2.getObject("register.password.constraints"));
        SwingUtilities.invokeLater(new Runnable(){
            {
                1 a;
            }

            public void run() {
                1 a;
                a.RegistrationDialog.this.mEmailField.requestFocus();
                a.RegistrationDialog.this.mEmailField.selectAll();
            }
        });
        CommandBar a7 = a.getCommandBar();
        a7.setButtonWidthPreserved(false);
        a.mCancelButton = DialogUtils.getCancelButton((KDialog)a);
        a7.add((Component)a.mCancelButton);
        a.mRegisterButton = new JButton(new AbstractAction(){
            {
                2 a;
            }

            public void actionPerformed(ActionEvent a) {
                2 a2;
                a2.RegistrationDialog.this.doRegistration();
            }
        });
        a.mRegisterButton.setText(a2.getString("register.button.register.label"));
        a.mRegisterButton.setEnabled(false);
        a7.add((Component)a.mRegisterButton);
        Rectangle a8 = a.getDialogBounds();
        a.getDialogBounds().height = (Integer)a2.getObject("register.dialog.height");
        a.setDialogBounds(a8);
    }

    private void setDialogEnabled(boolean a) {
        RegistrationDialog a2;
        a2.mEmailField.setEnabled(a);
        a2.mPasswordField.setEnabled(a);
        a2.mCancelButton.setEnabled(a);
        a2.mRegisterButton.setEnabled(a);
    }

    private void doRegistration() {
        RegistrationDialog a;
        ThreadPool.getInstance().runIt((Runnable)a.new RegistrationController(), "Registration", 10);
    }

    private class RegistrationDocumentListener
    implements DocumentListener {
        private RegistrationDocumentListener() {
            RegistrationDocumentListener a;
        }

        public void insertUpdate(DocumentEvent a) {
            RegistrationDocumentListener a2;
            a2.validateRegisterButtonState();
        }

        public void removeUpdate(DocumentEvent a) {
            RegistrationDocumentListener a2;
            a2.validateRegisterButtonState();
        }

        private void validateRegisterButtonState() {
            RegistrationDocumentListener a;
            String a2 = a.RegistrationDialog.this.mEmailField.getText().toString().trim();
            char[] a3 = a.RegistrationDialog.this.mPasswordField.getPassword();
            a.RegistrationDialog.this.mRegisterButton.setEnabled(RegistrationUtils.isValidLogin(a2, a3));
        }

        public void changedUpdate(DocumentEvent a) {
        }
    }

    private class RegistrationKeyAdapter
    extends KeyAdapter {
        private RegistrationKeyAdapter() {
            RegistrationKeyAdapter a;
        }

        public void keyReleased(KeyEvent a) {
            if (a.getKeyCode() == 10) {
                RegistrationKeyAdapter a2;
                a.consume();
                if (a2.RegistrationDialog.this.mRegisterButton.isEnabled()) {
                    a2.RegistrationDialog.this.doRegistration();
                } else if (a.getComponent() == a2.RegistrationDialog.this.mEmailField) {
                    SwingUtilities.invokeLater(new Runnable(){
                        {
                            1 a;
                        }

                        public void run() {
                            1 a;
                            RegistrationDialog.this.mPasswordField.requestFocus();
                        }
                    });
                }
            }
        }
    }

    private class RegistrationController
    implements Runnable {
        private RegistrationController() {
            RegistrationController a;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block28: {
                block27: {
                    RegistrationController a;
                    if (a.RegistrationDialog.this.mBooklet == null) {
                        LogUtils.logBookletIsNull();
                        return;
                    }
                    BookletContext a2 = a.RegistrationDialog.this.mBooklet.getBookletContext();
                    if (a2 == null) {
                        LogUtils.logBookletContextIsNull();
                        return;
                    }
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){
                            {
                                1 a;
                            }

                            public void run() {
                                1 a;
                                RegistrationDialog.this.setDialogEnabled(false);
                            }
                        });
                    }
                    catch (Exception a3) {
                        LOG.error(AWT_EX, new String[]{"Disabling Registration Dialog"}, "");
                    }
                    boolean a4 = false;
                    Wireless a5 = (Wireless)a2.getService(class$com$amazon$kindle$net$Wireless == null ? (class$com$amazon$kindle$net$Wireless = RegistrationDialog.class$("com.amazon.kindle.net.Wireless")) : class$com$amazon$kindle$net$Wireless);
                    try {
                        a5.ensureConnection(false, 1);
                        a4 = true;
                    }
                    catch (BrowserLoginRequiredException a6) {
                        LOG.error(REG_EX, new String[]{((Object)((Object)a6)).getClass().getName()}, "RegistrationRequestCanceled");
                        return;
                    }
                    catch (NoConnectionException a7) {
                        LOG.error(REG_EX, new String[]{((Object)((Object)a7)).getClass().getName()}, "reasonCode:" + a7.getReason());
                    }
                    catch (Exception a8) {
                        LOG.error(REG_EX, new String[]{a8.getClass().getName()}, "");
                    }
                    if (!a4) break block27;
                    AmazonRegistrationService a9 = (AmazonRegistrationService)a2.getService(class$com$amazon$kindle$webservices$registration$AmazonRegistrationService == null ? (class$com$amazon$kindle$webservices$registration$AmazonRegistrationService = RegistrationDialog.class$("com.amazon.kindle.webservices.registration.AmazonRegistrationService")) : class$com$amazon$kindle$webservices$registration$AmazonRegistrationService);
                    ChromeHeaderBar a10 = (ChromeHeaderBar)a2.getService(class$com$amazon$kindle$booklet$ChromeHeaderBar == null ? (class$com$amazon$kindle$booklet$ChromeHeaderBar = RegistrationDialog.class$("com.amazon.kindle.booklet.ChromeHeaderBar")) : class$com$amazon$kindle$booklet$ChromeHeaderBar);
                    try {
                        String a11 = a.RegistrationDialog.this.mEmailField.getText().trim().toString();
                        ResourceBundle a12 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DialogResources");
                        try {
                            a10.enableActivityIndicator(RegistrationDialog.REG_SCAN_CLIENT_ID, 100000, 0, a12.getString("register.activity.label"));
                        }
                        catch (ChromeException a13) {
                            LOG.error(CHROME_EX, new String[]{"ChromeExpection", "Enabling Registration Activity Indicator"}, "", (Throwable)a13);
                        }
                        try {
                            a9.registerUser(a11, a.RegistrationDialog.this.mPasswordField.getPassword());
                        }
                        catch (CustomerNotFoundException a14) {
                            LOG.error(REG_EX, new String[]{"CustomerNotFoundException"}, "", (Throwable)a14);
                            a.RegistrationDialog.this.closeDialog();
                            a.showRegistrationErrorDialog(a11);
                        }
                        catch (AuthenticationFailedException a15) {
                            LOG.error(REG_EX, new String[]{"AuthenticationFailedException"}, "", (Throwable)a15);
                            a.RegistrationDialog.this.closeDialog();
                            a.showRegistrationErrorDialog(a11);
                        }
                        catch (ServerException a16) {
                            LOG.error(REG_EX, new String[]{"ServerException"}, "", (Throwable)a16);
                            a.RegistrationDialog.this.closeDialog();
                            a.showServerErrorDialog();
                        }
                        catch (IOException a17) {
                            LOG.error(REG_EX, new String[]{"IOException"}, "", (Throwable)a17);
                            a.RegistrationDialog.this.closeDialog();
                            a.showServerErrorDialog();
                        }
                        catch (Exception a18) {
                            LOG.error(Log.CATCHALL_EX, null, "", (Throwable)a18);
                        }
                        Object var10_18 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_19 = null;
                        try {
                            a10.disableActivityIndicator(RegistrationDialog.REG_SCAN_CLIENT_ID);
                        }
                        catch (ChromeException a19) {
                            LOG.error(CHROME_EX, new String[]{"ChromeExpection", "Disabling Registration Activity Indicator"}, "", a19);
                        }
                        if (a.RegistrationDialog.this.isShowing() && !a9.isRegistered()) {
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(){
                                    {
                                        2 a;
                                    }

                                    public void run() {
                                        2 a;
                                        RegistrationDialog.this.setDialogEnabled(true);
                                    }
                                });
                            }
                            catch (Exception a19) {
                                LOG.error(AWT_EX, new String[]{"Re-enabling Registration Dialog"}, "");
                            }
                        }
                        throw throwable;
                    }
                    try {
                        a10.disableActivityIndicator(RegistrationDialog.REG_SCAN_CLIENT_ID);
                    }
                    catch (ChromeException a19) {
                        LOG.error(CHROME_EX, new String[]{"ChromeExpection", "Disabling Registration Activity Indicator"}, "", a19);
                    }
                    if (a.RegistrationDialog.this.isShowing() && !a9.isRegistered()) {
                        try {
                            SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                        }
                        catch (Exception a19) {
                            LOG.error(AWT_EX, new String[]{"Re-enabling Registration Dialog"}, "");
                        }
                    }
                    break block28;
                }
                WirelessCancelEvent.getInstance().fireEvent();
            }
        }

        private void showRegistrationErrorDialog(final String a) {
            RegistrationController a2;
            SwingUtilities.invokeLater(new Runnable(){
                {
                    3 a2;
                }

                public void run() {
                    3 a4;
                    ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DialogResources");
                    int a3 = (Integer)a2.getObject("register.error.button.again.index");
                    if (ConfirmationDialog.showDialog((String)RegistrationDialog.this.mBooklet.getBookletContext().getName(), (String)a2.getString("register.error.message.label"), (String)a2.getString("register.error.title.label"), (String[])a2.getStringArray("register.error.button.labels"), (int[])new int[]{(Integer)a2.getObject("register.error.button.cancel.index"), a3}) == a3) {
                        new RegistrationDialog(RegistrationDialog.this.mBooklet, a4.a).postDialog(true);
                    }
                }
            });
        }

        private void showServerErrorDialog() {
            try {
                RegistrationController a;
                SwingUtilities.invokeAndWait(new Runnable(){
                    {
                        4 a;
                    }

                    public void run() {
                        4 a;
                        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DialogResources");
                        ConfirmationDialog.showDialog((String)RegistrationDialog.this.mBooklet.getBookletContext().getName(), (String)a2.getString("register.server.error.message.label"), (String)a2.getString("register.server.error.title.label"), (int)0);
                    }
                });
            }
            catch (Exception a) {
                LOG.error(AWT_EX, new String[]{"Posting Server Error Dialog"}, "");
            }
        }
    }
}

