/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.settings.dialog;

import com.amazon.agui.swing.CommandBar;
import com.amazon.agui.swing.ConfirmationDialog;
import com.amazon.agui.swing.InputDialog;
import com.amazon.agui.swing.KDialog;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import com.amazon.ebook.util.thread.ThreadPool;
import com.amazon.kindle.apps.util.CommunicationUtils;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.booklet.ChromeException;
import com.amazon.kindle.booklet.ChromeHeaderBar;
import com.amazon.kindle.control.util.DialogUtils;
import com.amazon.kindle.net.BrowserLoginRequiredException;
import com.amazon.kindle.net.NoConnectionException;
import com.amazon.kindle.net.ServerException;
import com.amazon.kindle.net.Wireless;
import com.amazon.kindle.settings.SettingsBooklet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;

public class DeviceNameDialog
extends InputDialog {
    private static final Log LOG = Log.getInstance((String)"DeviceNameDialog");
    private static final LogMessage AWT_EX = new LogMessage("AWTInvokeAndWaitFailed", new String[]{"action"});
    private static final LogMessage CHROME_EX = new LogMessage("ActivityIndicatorFailed", new String[]{"reason", "action"});
    private static final LogMessage DEV_NAME_EX = new LogMessage("SetDeviceNameFailed", new String[]{"reason"});
    private static final String DEV_NAME_SCAN_CLIENT_ID = "DEV_NAME_SCAN_CLIENT_ID";
    private static final int SPINNER_TIMEOUT = 100000;
    private static final int SPINNER_DELAY = 0;
    private volatile SettingsBooklet mBooklet;
    private JButton mSaveButton;
    private KeyAdapter mKeyListener;
    static /* synthetic */ Class class$com$amazon$kindle$net$Wireless;
    static /* synthetic */ Class class$com$amazon$kindle$booklet$ChromeHeaderBar;

    public DeviceNameDialog(SettingsBooklet a) {
        DeviceNameDialog a2;
        if (a == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        a2.mBooklet = a;
        a2.setAppId(a2.mBooklet.getName());
        a2.initGUI();
    }

    public String getInputText() {
        DeviceNameDialog a;
        return super.getInputText().trim();
    }

    private void initGUI() {
        DeviceNameDialog a;
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DialogResources");
        a.setTitleBarEnabled(true);
        a.setTitle(a2.getString("devicename.title.label"));
        a.setDescription(a2.getString("devicename.description.label"));
        a.mKeyListener = new KeyAdapter(){
            {
                1 a;
            }

            public void keyReleased(KeyEvent a) {
                if (a.getKeyCode() == 10) {
                    1 a2;
                    a.consume();
                    a2.DeviceNameDialog.this.setDeviceName(a2.DeviceNameDialog.this.getInputText().trim());
                }
            }
        };
        JTextArea a3 = a.getTextArea();
        a3.addKeyListener(a.mKeyListener);
        a3.setDocument((Document)DialogUtils.getLimitedCharacterDocument((int)((Integer)a2.getObject("devicename.max.chars"))));
        AbstractAction a4 = new AbstractAction(){
            {
                2 a;
            }

            public void actionPerformed(ActionEvent a) {
                2 a2;
                a2.DeviceNameDialog.this.setDeviceName(a2.DeviceNameDialog.this.getInputText().trim());
            }
        };
        a.mSaveButton = DialogUtils.getActionButton((AbstractAction)a4, (String)a2.getString("devicename.button.save.label"));
        a.mSaveButton.setEnabled(false);
        CommandBar a5 = a.getCommandBar();
        a5.add((Component)DialogUtils.getCancelButton((KDialog)a));
        a5.add((Component)a.mSaveButton);
        a5.setButtonWidthPreserved(false);
        a5.setButtonPreferredSize(null);
        a.setInputText(CommunicationUtils.getDeviceName((Booklet)a.mBooklet));
        a.setButtonDisablePolicy(3);
    }

    private void setDeviceName(String a) {
        DeviceNameDialog a2;
        if (a2.mSaveButton.isEnabled()) {
            a2.closeDialog();
            ThreadPool.getInstance().runIt((Runnable)a2.new DeviceNameController(a), "SetDeviceName");
        }
    }

    private class DeviceNameController
    implements Runnable {
        private String B;

        public DeviceNameController(String a) {
            DeviceNameController a2;
            a2.B = a;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DeviceNameController a;
            BookletContext a2 = a.DeviceNameDialog.this.mBooklet.getBookletContext();
            if (a2 == null) {
                LogUtils.logBookletContextIsNull();
                return;
            }
            boolean a3 = false;
            Wireless a4 = (Wireless)a2.getService(class$com$amazon$kindle$net$Wireless == null ? (class$com$amazon$kindle$net$Wireless = DeviceNameDialog.class$("com.amazon.kindle.net.Wireless")) : class$com$amazon$kindle$net$Wireless);
            try {
                a4.ensureConnection(false, 1);
                a3 = true;
            }
            catch (BrowserLoginRequiredException a5) {
                LOG.error(DEV_NAME_EX, new String[]{((Object)((Object)a5)).getClass().getName()}, "DeviceNameRequestCanceled");
                return;
            }
            catch (NoConnectionException a6) {
                LOG.error(DEV_NAME_EX, new String[]{((Object)((Object)a6)).getClass().getName()}, "reasonCode:" + a6.getReason());
            }
            catch (Exception a7) {
                LOG.error(DEV_NAME_EX, new String[]{a7.getClass().getName()}, "");
            }
            if (a3) {
                try {
                    a.setIndicatorEnabled(true);
                    CommunicationUtils.setUserDeviceName((Booklet)a.DeviceNameDialog.this.mBooklet, (String)a.B);
                }
                catch (ServerException a8) {
                    LOG.error(DEV_NAME_EX, new String[]{"ServerException"}, "", (Throwable)a8);
                    a.showCannotConnectDialog();
                }
                catch (IOException a9) {
                    LOG.error(DEV_NAME_EX, new String[]{"IOException"}, "", (Throwable)a9);
                    a.showCannotConnectDialog();
                }
                finally {
                    a.setIndicatorEnabled(false);
                }
            } else {
                a.showCannotConnectDialog();
            }
        }

        private void setIndicatorEnabled(boolean a) {
            DeviceNameController a2;
            BookletContext a3 = a2.DeviceNameDialog.this.mBooklet.getBookletContext();
            if (a3 == null) {
                LogUtils.logBookletContextIsNull();
                return;
            }
            ChromeHeaderBar a4 = (ChromeHeaderBar)a3.getService(class$com$amazon$kindle$booklet$ChromeHeaderBar == null ? (class$com$amazon$kindle$booklet$ChromeHeaderBar = DeviceNameDialog.class$("com.amazon.kindle.booklet.ChromeHeaderBar")) : class$com$amazon$kindle$booklet$ChromeHeaderBar);
            try {
                if (a) {
                    a4.enableActivityIndicator(DeviceNameDialog.DEV_NAME_SCAN_CLIENT_ID, 100000, 0);
                } else {
                    a4.disableActivityIndicator(DeviceNameDialog.DEV_NAME_SCAN_CLIENT_ID);
                }
            }
            catch (ChromeException a5) {
                LOG.error(CHROME_EX, new String[]{"ChromeExpection", a ? "Enabling SetDeviceName Activity Indicator" : "Disabling SetDeviceName Activity Indicator"}, "", (Throwable)a5);
            }
        }

        private void showCannotConnectDialog() {
            try {
                DeviceNameController a;
                SwingUtilities.invokeAndWait(new Runnable(){
                    {
                        1 a;
                    }

                    public void run() {
                        1 a;
                        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DialogResources");
                        ConfirmationDialog.showDialog((String)DeviceNameDialog.this.mBooklet.getName(), (String)a2.getString("devicename.cant.connect.message.label"), (String)a2.getString("devicename.cant.connect.title.label"), (int)0);
                    }
                });
            }
            catch (Exception a) {
                LOG.error(AWT_EX, new String[]{"Posting Unable to Connect Dialog"}, "");
            }
        }
    }
}

