/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.settings.dialog;

import com.amazon.agui.swing.KDialog;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.ui.html.MiddleClassTextView;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.text.StringUtil;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.apps.util.NetworkUtils;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.device.UserStoreService;
import com.amazon.kindle.identity.KindleIdentity;
import com.amazon.kindle.identity.VersionInfo;
import com.amazon.kindle.restricted.net.wifi.WiFi;
import com.amazon.kindle.settings.SettingsBooklet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class DeviceInfoDialog
extends KDialog {
    private static final Log LOG = Log.getInstance((String)"DeviceInfoDialog");
    private static final long BYTES_IN_A_MEGABYTE = 0x100000L;
    private static final long UNKNOWN_AVAILABLE_MEMORY = -1L;
    private static final int SERIAL_NUMBER_CHAR_BLOCK_SIZE = 4;
    private static final String SERIAL_NUMBER_SEPARATOR = " ";
    private SettingsBooklet mBooklet;
    private ReaderSDK mReaderSDK;

    public DeviceInfoDialog(SettingsBooklet a) {
        DeviceInfoDialog a2;
        if (a == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        BookletContext a3 = a.getBookletContext();
        if (a3 == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        a2.mBooklet = a;
        a2.mReaderSDK = (ReaderSDK)a3.getService(ReaderSDK.class);
        a2.setAppId(a.getName());
        a2.initGUI();
    }

    private void initGUI() {
        DeviceInfoDialog a;
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DialogResources");
        a.setTitleBarEnabled(true);
        a.setTitle(a2.getString("deviceinfo.title.label"));
        Container a3 = a.getContentPane();
        a3.setLayout(new BorderLayout());
        String a4 = MessageFormat.format(a2.getString("deviceinfo.html.template"), new Long(a.getAvailableMemory()), a.getWifiMacAddress(), a.getSerialNumber(), a.getNetworkCapability(), a.getFirmwareVersion());
        MiddleClassTextView a5 = new MiddleClassTextView(a.mReaderSDK);
        a5.setText(a4);
        a3.add((Component)a5, "Center");
        a.setCommandBarPosition(-1);
        Rectangle a6 = a.getDialogBounds();
        a.getDialogBounds().height = (Integer)a2.getObject("deviceinfo.dialog.height");
        a.setDialogBounds(a6);
    }

    private String getFirmwareVersion() {
        DeviceInfoDialog a;
        String a2 = null;
        try {
            if (a.mBooklet == null) {
                LogUtils.logBookletIsNull();
                return a.getUnavailableDisplayString();
            }
            BookletContext a3 = a.mBooklet.getBookletContext();
            if (a3 == null) {
                LogUtils.logBookletContextIsNull();
                return a.getUnavailableDisplayString();
            }
            a2 = ((VersionInfo)a3.getService(VersionInfo.class)).getPrettyVersionString();
        }
        catch (Exception a4) {
            LOG.error(a4.getMessage());
        }
        return a2 != null ? a2 : a.getUnavailableDisplayString();
    }

    private String getNetworkCapability() {
        DeviceInfoDialog a;
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DialogResources");
        if (NetworkUtils.isWifiOnly((Booklet)a.mBooklet)) {
            return a2.getString("deviceinfo.network.wifionly.label");
        }
        if (NetworkUtils.isWifiWan((Booklet)a.mBooklet)) {
            return a2.getString("deviceinfo.network.wanwifi.label");
        }
        if (NetworkUtils.hasWan((Booklet)a.mBooklet) && !NetworkUtils.hasWifi((Booklet)a.mBooklet)) {
            return a2.getString("deviceinfo.network.wanonly.label");
        }
        return a.getUnavailableDisplayString();
    }

    private String getSerialNumber() {
        DeviceInfoDialog a;
        String a2 = null;
        try {
            if (a.mBooklet == null) {
                LogUtils.logBookletIsNull();
                return a.getUnavailableDisplayString();
            }
            BookletContext a3 = a.mBooklet.getBookletContext();
            if (a3 == null) {
                LogUtils.logBookletContextIsNull();
                return a.getUnavailableDisplayString();
            }
            a2 = StringUtil.stringSpacer((String)((KindleIdentity)a3.getService(KindleIdentity.class)).getDeviceSerialID(), (int)4, (String)SERIAL_NUMBER_SEPARATOR, (boolean)false);
        }
        catch (Exception a4) {
            LOG.error(a4.getMessage());
        }
        return a2 != null ? a2 : a.getUnavailableDisplayString();
    }

    private String getWifiMacAddress() {
        DeviceInfoDialog a;
        String a2 = null;
        try {
            if (NetworkUtils.hasWifi((Booklet)a.mBooklet)) {
                if (a.mBooklet == null) {
                    LogUtils.logBookletIsNull();
                    return a.getUnavailableDisplayString();
                }
                BookletContext a3 = a.mBooklet.getBookletContext();
                if (a3 == null) {
                    LogUtils.logBookletContextIsNull();
                    return a.getUnavailableDisplayString();
                }
                a2 = ((WiFi)a3.getService(WiFi.class)).getMacAddress();
            }
        }
        catch (Exception a4) {
            LOG.error(a4.getMessage());
        }
        return a2 != null ? a2 : a.getUnavailableDisplayString();
    }

    private long getAvailableMemory() {
        DeviceInfoDialog a;
        if (a.mBooklet == null) {
            LogUtils.logBookletIsNull();
            return -1L;
        }
        BookletContext a2 = a.mBooklet.getBookletContext();
        if (a2 == null) {
            LogUtils.logBookletContextIsNull();
            return -1L;
        }
        UserStoreService a3 = (UserStoreService)a2.getService(UserStoreService.class);
        if (a3 != null) {
            return a3.getFreeSpace() / 0x100000L;
        }
        return -1L;
    }

    private String getUnavailableDisplayString() {
        return ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DialogResources").getString("deviceinfo.default.label");
    }
}

