/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.settings.dialog;

import com.amazon.agui.swing.CommandBar;
import com.amazon.agui.swing.ConfirmationDialog;
import com.amazon.agui.swing.KDialog;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import com.amazon.ebook.util.thread.ThreadPool;
import com.amazon.kindle.apps.util.CommunicationUtils;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.booklet.ChromeException;
import com.amazon.kindle.booklet.ChromeHeaderBar;
import com.amazon.kindle.control.util.DialogUtils;
import com.amazon.kindle.net.BrowserLoginRequiredException;
import com.amazon.kindle.net.NoConnectionException;
import com.amazon.kindle.net.ServerException;
import com.amazon.kindle.net.Wireless;
import com.amazon.kindle.settings.util.SettingsPreferences;
import com.amazon.kindle.webservices.registration.AmazonRegistrationService;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class DeregistrationDialog
extends ConfirmationDialog {
    private static final Log LOG = Log.getInstance((String)"DeregistrationDialog");
    private static final LogMessage DEREG_EX = new LogMessage("DeregistrationFailed", new String[]{"reason"});
    private static final LogMessage CHROME_EX = new LogMessage("ActivityIndicatorFailed", new String[]{"reason", "action"});
    private static final LogMessage AWT_EX = new LogMessage("AWTInvokeAndWaitFailed", new String[]{"action"});
    private static final String DEREG_SCAN_CLIENT_ID = "DEREG_SCAN_CLIENT_ID";
    private static final int SPINNER_TIMEOUT = 100000;
    private static final int SPINNER_DELAY = 0;
    private Booklet mBooklet;
    private JButton mCancelButton;
    private JButton mDeregisterButton;
    static /* synthetic */ Class class$com$amazon$kindle$webservices$registration$AmazonRegistrationService;
    static /* synthetic */ Class class$com$amazon$kindle$booklet$ChromeHeaderBar;
    static /* synthetic */ Class class$com$amazon$kindle$net$Wireless;

    public DeregistrationDialog(Booklet a) {
        super(a.getBookletContext().getName());
        DeregistrationDialog a2;
        a2.mBooklet = a;
        a2.initGUI();
    }

    private void initGUI() {
        DeregistrationDialog a;
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DialogResources");
        a.setTitleBarEnabled(true);
        a.setTitle(a2.getString("deregister.title.label"));
        a.setMessage(a2.getString("deregister.message.label"));
        CommandBar a3 = a.getCommandBar();
        a3.setButtonWidthPreserved(false);
        a3.setButtonPreferredSize(null);
        a.mCancelButton = DialogUtils.getCancelButton((KDialog)a);
        a.mDeregisterButton = DialogUtils.getActionButton((AbstractAction)new AbstractAction(){
            {
                1 a;
            }

            public void actionPerformed(ActionEvent a) {
                1 a2;
                a2.DeregistrationDialog.this.doDeregistration();
            }
        }, (String)a2.getString("deregister.button.deregister.label"));
        a3.add((Component)a.mCancelButton);
        a3.add((Component)a.mDeregisterButton);
        a.setDialogBounds(a.getPreferredDialogBounds());
    }

    private void setDialogEnabled(final boolean a) {
        DeregistrationDialog a2;
        if (a2.isShowing()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){
                    {
                        2 a2;
                    }

                    public void run() {
                        2 a2;
                        if (a2.DeregistrationDialog.this.mCancelButton != null && a2.DeregistrationDialog.this.mCancelButton.isEnabled() != a2.a) {
                            a2.DeregistrationDialog.this.mCancelButton.setEnabled(a2.a);
                        }
                        if (a2.DeregistrationDialog.this.mDeregisterButton != null && a2.DeregistrationDialog.this.mDeregisterButton.isEnabled() != a2.a) {
                            a2.DeregistrationDialog.this.mDeregisterButton.setEnabled(a2.a);
                        }
                    }
                });
            }
            catch (Exception a3) {
                LOG.error(AWT_EX, new String[]{a ? "setDialogEnabled=true" : "setDialogEnabled=false"}, "");
            }
        }
    }

    private void doDeregistration() {
        DeregistrationDialog a;
        ThreadPool.getInstance().runIt((Runnable)a.new DeregistrationController(), "Deregistration", 10);
    }

    private class DeregistrationController
    implements Runnable {
        private DeregistrationController() {
            DeregistrationController a;
        }

        public void run() {
            DeregistrationController a;
            a.DeregistrationDialog.this.setDialogEnabled(false);
            a.deregister();
        }

        private void deregister() {
            DeregistrationController a;
            BookletContext a2 = a.DeregistrationDialog.this.mBooklet.getBookletContext();
            if (a2 == null) {
                LogUtils.logBookletContextIsNull();
                return;
            }
            AmazonRegistrationService a3 = (AmazonRegistrationService)a2.getService(class$com$amazon$kindle$webservices$registration$AmazonRegistrationService == null ? (class$com$amazon$kindle$webservices$registration$AmazonRegistrationService = DeregistrationDialog.class$("com.amazon.kindle.webservices.registration.AmazonRegistrationService")) : class$com$amazon$kindle$webservices$registration$AmazonRegistrationService);
            try {
                a.setIndicatorEnabled(true);
                if (a3.unregisterUser()) {
                    a.setIndicatorEnabled(false);
                    SettingsPreferences.clearPersonalInfo();
                } else {
                    LOG.error(DEREG_EX, new String[]{"unregisterUser:false, expected:true"}, "Re-enabling Deregistration Dialog");
                    a.setIndicatorEnabled(false);
                    a.DeregistrationDialog.this.setDialogEnabled(true);
                }
            }
            catch (IOException a4) {
                LOG.error(DEREG_EX, new String[]{"IOException"}, "", (Throwable)a4);
                a.setIndicatorEnabled(false);
                a.DeregistrationDialog.this.closeDialog();
                a.handleIOException();
            }
            catch (ServerException a5) {
                LOG.error(DEREG_EX, new String[]{"ServerException"}, "", (Throwable)a5);
                a.setIndicatorEnabled(false);
                a.DeregistrationDialog.this.closeDialog();
                a.showServerErrorDialog();
            }
        }

        private void setIndicatorEnabled(boolean a) {
            DeregistrationController a2;
            BookletContext a3 = a2.DeregistrationDialog.this.mBooklet.getBookletContext();
            if (a3 == null) {
                LogUtils.logBookletContextIsNull();
                return;
            }
            ChromeHeaderBar a4 = (ChromeHeaderBar)a3.getService(class$com$amazon$kindle$booklet$ChromeHeaderBar == null ? (class$com$amazon$kindle$booklet$ChromeHeaderBar = DeregistrationDialog.class$("com.amazon.kindle.booklet.ChromeHeaderBar")) : class$com$amazon$kindle$booklet$ChromeHeaderBar);
            try {
                if (a) {
                    ResourceBundle a5 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DialogResources");
                    a4.enableActivityIndicator(DeregistrationDialog.DEREG_SCAN_CLIENT_ID, 100000, 0, a5.getString("deregister.activity.label"));
                } else {
                    a4.disableActivityIndicator(DeregistrationDialog.DEREG_SCAN_CLIENT_ID);
                }
            }
            catch (ChromeException a6) {
                LOG.error(CHROME_EX, new String[]{"ChromeExpection", a ? "Enabling Deregistration Activity Indicator" : "Disabling Deregistration Activity Indicator"}, "", (Throwable)a6);
            }
        }

        private void showServerErrorDialog() {
            try {
                DeregistrationController a;
                SwingUtilities.invokeAndWait(new Runnable(){
                    {
                        1 a;
                    }

                    public void run() {
                        1 a;
                        BookletContext a2 = DeregistrationDialog.this.mBooklet.getBookletContext();
                        if (a2 == null) {
                            LogUtils.logBookletContextIsNull();
                            return;
                        }
                        ResourceBundle a3 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.DialogResources");
                        ConfirmationDialog.showDialog((String)a2.getName(), (String)a3.getString("deregister.server.error.message.label"), (String)a3.getString("deregister.server.error.title.label"), (int)0);
                    }
                });
            }
            catch (Exception a) {
                LOG.error(AWT_EX, new String[]{"Posting Server Error Dialog"}, "");
            }
        }

        private void handleIOException() {
            DeregistrationController a;
            BookletContext a2 = a.DeregistrationDialog.this.mBooklet.getBookletContext();
            if (a2 == null) {
                LogUtils.logBookletContextIsNull();
                return;
            }
            boolean a3 = CommunicationUtils.isConnected((Booklet)a.DeregistrationDialog.this.mBooklet);
            boolean a4 = false;
            Wireless a5 = (Wireless)a2.getService(class$com$amazon$kindle$net$Wireless == null ? (class$com$amazon$kindle$net$Wireless = DeregistrationDialog.class$("com.amazon.kindle.net.Wireless")) : class$com$amazon$kindle$net$Wireless);
            try {
                a5.ensureConnection(false, 1);
                a4 = true;
            }
            catch (BrowserLoginRequiredException a6) {
                LOG.error(DEREG_EX, new String[]{((Object)((Object)a6)).getClass().getName()}, "DeregistrationRequestCanceled");
                return;
            }
            catch (NoConnectionException a7) {
                LOG.error(DEREG_EX, new String[]{((Object)((Object)a7)).getClass().getName()}, "reasonCode:" + a7.getReason());
            }
            catch (Exception a8) {
                LOG.error(DEREG_EX, new String[]{a8.getClass().getName()}, "");
            }
            if (a4 && !a3) {
                a.deregister();
            } else {
                a.showServerErrorDialog();
            }
        }
    }
}

