/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.kindlet.internal.util;

import com.amazon.kindle.kindlet.internal.log.Logger;
import com.amazon.kindle.kindlet.internal.log.LoggerFactory;
import com.amazon.kindle.kindlet.util.Store;
import com.amazon.kindle.util.lipc.LipcException;
import com.amazon.kindle.util.lipc.LipcService;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import sun.awt.AppContext;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class KindletBookletStore
extends Store {
    static final String m = "store.detail.uri";
    static final String h = "store.search.uri";
    static final String A = "store.open.uri";
    static final String H = "store.open.failure";
    private static final String b = "UTF-8";
    private static final String K = "@itemdetails ";
    private final Logger B = LoggerFactory.getLogger((String)"KindletBookletStore");
    private final LipcService D;

    public static void initialize(AppContext a) {
        if (a == null || a.isDisposed()) {
            throw new IllegalStateException("AppContext not initialized");
        }
        a.put(Store.class, (Object)new KindletBookletStore(LipcService.getInstance()));
    }

    KindletBookletStore(LipcService a) {
        KindletBookletStore a2;
        if (a == null) {
            throw new IllegalArgumentException("Lipc service cannot be null");
        }
        a2.D = a;
    }

    public void openStore(String a) {
        KindletBookletStore a2;
        a2.search(a);
    }

    public void search(String a) {
        KindletBookletStore a2;
        if (a != null && a.toLowerCase(Locale.US).startsWith(K)) {
            a2.showProductPage(a.substring(K.length()));
        } else if (a != null) {
            a2.openStoreBooklet(a, h);
        } else {
            a2.openStoreBooklet(a, A);
        }
    }

    public void showProductPage(String a) {
        KindletBookletStore a2;
        a2.openStoreBooklet(a, m);
    }

    private void openStoreBooklet(String a, String a2) {
        KindletBookletStore a3;
        String a4;
        ResourceBundle a5 = ResourceBundle.getBundle("com.amazon.kindle.kindlet.internal.resources.KindletBookletResources");
        if (a != null) {
            try {
                a4 = URLEncoder.encode(a, b);
            }
            catch (UnsupportedEncodingException a6) {
                a3.B.error("Caught unsupported encoding exception", (Throwable)a6);
                a4 = "";
            }
        } else {
            a4 = "";
        }
        String a7 = MessageFormat.format(a5.getString(a2), a4);
        try {
            a3.sendLipcCommand(a7);
        }
        catch (LipcException a8) {
            a3.B.error("StoreBookletSwitchFailed", "Error while switching to store booklet", new String[]{"errorCode", "lipcURI"}, new Object[]{Integer.toString(a8.getErrorCode()), a7});
            throw new IllegalStateException(a5.getString(H));
        }
    }

    void sendLipcCommand(String a) throws LipcException {
        KindletBookletStore a2;
        ResourceBundle a3 = ResourceBundle.getBundle("com.amazon.kindle.kindlet.internal.resources.KindletBookletResources");
        a2.D.getDefaultSource().getTarget(a3.getString("appmgrd.path")).setProperty(a3.getString("appmgrd.start.cmd"), a);
    }
}

