/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.kindlet.internal.ui;

import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.booklet.ChromeException;
import com.amazon.kindle.booklet.ChromeHeaderBar;
import com.amazon.kindle.kindlet.internal.KindletContainer;
import com.amazon.kindle.kindlet.internal.KindletContainerException;
import com.amazon.kindle.kindlet.internal.KindletExecutionException;
import com.amazon.kindle.kindlet.internal.lifecycle.KindletLifeCycle;
import com.amazon.kindle.kindlet.internal.lifecycle.StateChange;
import com.amazon.kindle.kindlet.internal.lifecycle.StateChangeHandler;
import com.amazon.kindle.kindlet.internal.log.Logger;
import com.amazon.kindle.kindlet.internal.log.LoggerFactory;
import com.amazon.kindle.kindlet.internal.ui.TitleBar;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class TitleBarImpl
implements TitleBar {
    private static final String m = "kindlet.title.subtitle.format";
    private final Logger h;
    private final ChromeHeaderBar A;
    private final BookletContext H;
    private String b;
    final AtomicBoolean K;

    public TitleBarImpl(BookletContext a, KindletContainer a2) {
        TitleBarImpl a3;
        if (a == null) {
            throw new IllegalArgumentException("bookletContext cannot be null");
        }
        a3.H = a;
        a3.A = (ChromeHeaderBar)a.getService(ChromeHeaderBar.class);
        if (a3.A == null) {
            throw new IllegalStateException("No ChromeHeaderBar found");
        }
        if (a2 == null) {
            throw new IllegalArgumentException("application sandbox cannot be null");
        }
        a3.h = LoggerFactory.getLogger((Class)TitleBarImpl.class);
        a3.b = "";
        a3.K = new AtomicBoolean(false);
        a2.getLifeCycle().addTrustedPrerequisiteStateChangeHandler(new StateChangeHandler(){
            {
                1 a;
            }

            public void handleStateChange(StateChange a) throws KindletExecutionException, KindletContainerException {
                1 a2;
                if (KindletLifeCycle.l.equals((Object)a) || KindletLifeCycle.m.equals((Object)a)) {
                    if (a2.TitleBarImpl.this.h.isLoggable(1024)) {
                        a2.TitleBarImpl.this.h.debug("Allow setting kindlet title as part of " + a);
                    }
                    a2.TitleBarImpl.this.K.set(true);
                } else if (KindletLifeCycle.h.equals((Object)a)) {
                    if (a2.TitleBarImpl.this.h.isLoggable(1024)) {
                        a2.TitleBarImpl.this.h.debug("Not allow setting kindlet title as part of stop().");
                    }
                    a2.TitleBarImpl.this.K.set(false);
                }
            }
        });
    }

    public void setSubTitle(String a) {
        TitleBarImpl a2;
        if (a2.K.get()) {
            if (a2.notEmpty(a)) {
                ResourceBundle a3 = ResourceBundle.getBundle("com.amazon.kindle.kindlet.internal.resources.KindletBookletResources");
                try {
                    String a4 = MessageFormat.format(a3.getString(m), a2.b, a);
                    if (a2.h.isLoggable(1024)) {
                        a2.h.debug("Setting kindlet's subtitle as " + a4);
                    }
                    a2.A.setTitlebarSecondaryText(a2.H, a4, true);
                }
                catch (ChromeException a5) {
                    a2.h.error("Failed to set application subtitle.", (Throwable)a5);
                }
            } else {
                a2.setTitle(a2.b);
            }
        } else {
            a2.h.warn("Cannot set the subtitle when the kindlet is not active.");
        }
    }

    public void setTitle(String a) {
        TitleBarImpl a2;
        if (a2.K.get()) {
            a2.b = a2.notEmpty(a) ? a : "";
            try {
                a2.A.setTitlebarSecondaryText(a2.H, a2.b, true);
            }
            catch (ChromeException a3) {
                a2.h.error("Failed to set application title.", (Throwable)a3);
            }
        } else {
            a2.h.warn("Cannot set the title when the kindlet is not active.");
        }
    }

    private boolean notEmpty(String a) {
        return a != null && a.trim().length() > 0;
    }
}

