/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.kindlet.internal.ui;

import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.booklet.ChromeHeaderBar;
import com.amazon.kindle.booklet.ChromeHeaderRequest;
import com.amazon.kindle.kindlet.internal.KindletProcess;
import com.amazon.kindle.kindlet.internal.log.Logger;
import com.amazon.kindle.kindlet.internal.log.LoggerFactory;
import com.amazon.kindle.kindlet.internal.ui.KindleToolbar;
import com.amazon.kindle.kindlet.internal.ui.KindletKMenuDispatcher;
import com.amazon.kindle.kindlet.ui.KMenu;
import com.amazon.kindle.kindlet.ui.ToolbarStyle;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.JFrame;

public class KindletToolbarImpl
implements KindleToolbar {
    private final Logger c;
    private final ChromeHeaderBar l;
    private final BookletContext k;
    private final ChromeHeaderRequest m;
    private KindletKMenuDispatcher h;
    private KindleToolbarDispatcher A;
    public static final int H = 30;
    public Rectangle b;
    private final WeakReference K;

    public KindletToolbarImpl(BookletContext a, ChromeHeaderRequest a2, KindletProcess a3) {
        a4(a, a2, a3, new KindletKMenuDispatcher(a, a3));
        KindletToolbarImpl a4;
    }

    KindletToolbarImpl(BookletContext a, ChromeHeaderRequest a2, KindletProcess a3, KindletKMenuDispatcher a4) {
        KindletToolbarImpl a5;
        if (a == null) {
            throw new IllegalArgumentException("bookletContext cannot be null");
        }
        a5.k = a;
        if (a2 == null) {
            throw new IllegalArgumentException("chromeHeaderRequest cannot be null");
        }
        a5.m = a2;
        if (a3 == null) {
            throw new IllegalArgumentException("kindletProcess cannot be null");
        }
        a5.l = (ChromeHeaderBar)a.getService(ChromeHeaderBar.class);
        if (a5.l == null) {
            throw new IllegalStateException("No ChromeHeaderBar found");
        }
        if (a4 == null) {
            throw new IllegalStateException("No menudispatcher found");
        }
        JFrame a6 = a3.getFrame("", "application");
        if (a6 == null) {
            throw new IllegalStateException("No frame created yet for the application.");
        }
        a5.c = LoggerFactory.getLogger((Class)KindletToolbarImpl.class);
        a5.h = a4;
        a5.K = new WeakReference<JFrame>(a6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setToolbarStyle(ToolbarStyle a) {
        KindletToolbarImpl a2;
        if (a2.k.getUIContainer() != null) {
            if (ToolbarStyle.TOOLBAR_NONE.equals((Object)a)) {
                a2.l.setStyle(a2.k, ChromeHeaderBar.Style.TITLE_ONLY);
                a2.l.setTransientChromeVisible(false);
                return;
            } else if (ToolbarStyle.TOOLBAR_TRANSIENT.equals((Object)a)) {
                a2.l.setStyle(a2.k, ChromeHeaderBar.Style.TITLE_ONLY);
                a2.m.getSearchRequest().setProfile("hidden", a2.m.getSearchRequest().getButtons());
                a2.l.setTransientChromeVisible(false);
                if (a2.A != null) return;
                a2.A = a2.new KindleToolbarDispatcher(a2, a2.l);
                a2.addAWTEventListener();
                return;
            } else {
                if (!ToolbarStyle.TOOLBAR_PERSISTENT.equals((Object)a)) throw new IllegalArgumentException("Unsupported ToolbarStyle");
                a2.l.setStyle(a2.k, ChromeHeaderBar.Style.TITLE_AND_SEARCH);
                a2.m.getSearchRequest().setProfile("hidden", a2.m.getSearchRequest().getButtons());
            }
            return;
        } else {
            a2.c.error("UI Container must be created first before creating an Toolbar");
        }
    }

    private void addAWTEventListener() {
        KindletToolbarImpl a;
        AccessController.doPrivileged(new PrivilegedAction(){
            {
                1 a;
            }

            public Object run() {
                1 a;
                if (a.KindletToolbarImpl.this.K.get() != null) {
                    if (a.KindletToolbarImpl.this.c.isLoggable(1024)) {
                        a.KindletToolbarImpl.this.c.debug("Adding AWTEventListener to top level frame");
                    }
                    ((JFrame)a.KindletToolbarImpl.this.K.get()).getToolkit().addAWTEventListener(a.KindletToolbarImpl.this.A, 16L);
                }
                return null;
            }
        });
    }

    public void setMenu(KMenu a) {
        KindletToolbarImpl a2;
        a2.h.setMenu(a);
    }

    KindleToolbarDispatcher getToolbarDispatcher() {
        KindletToolbarImpl a;
        return a.A;
    }

    KindletKMenuDispatcher getKMenuDispatcher() {
        KindletToolbarImpl a;
        return a.h;
    }

    public int getGesture() {
        return 1;
    }

    public Rectangle getGestureRegion() {
        KindletToolbarImpl a;
        if (a.b == null) {
            Dimension a2 = ((JFrame)a.K.get()).getToolkit().getScreenSize();
            a.b = new Rectangle(Math.round((float)((double)a2.width / 3.0)), 30, Math.round((float)((double)a2.width / 3.0)), a2.height - 30);
        }
        return a.b;
    }

    public int canInvokeToolbar(MouseEvent a) {
        KindletToolbarImpl a2;
        int a3 = -1;
        if (a != null && !a.isConsumed() && a.getButton() == a2.getGesture() && a.getID() == 500 && a.getClickCount() == 1) {
            Component a4 = a.getComponent();
            Rectangle a5 = a2.getGestureRegion();
            int a6 = a.getX();
            int a7 = a.getY();
            Component component = a4;
            while (component != null) {
                a6 += a4.getX();
                a7 += a4.getY();
                component = a4.getParent();
            }
            if (a2.c.isLoggable(1024)) {
                a2.c.debug("absolute Point for mouse event " + new Point(a6, a7) + " chrome region =" + a5);
            }
            a3 = a6 >= a5.x && a6 <= a5.x + a5.width && a7 >= a5.y && a7 <= a5.y + a5.height ? 0 : 1;
        }
        return a3;
    }

    public void cleanup() {
        KindletToolbarImpl a;
        AccessController.doPrivileged(new PrivilegedAction(){
            {
                2 a;
            }

            public Object run() {
                2 a;
                if (a.KindletToolbarImpl.this.c.isLoggable(1024)) {
                    a.KindletToolbarImpl.this.c.debug("Removing AWTEventListener from top level frame");
                }
                if (a.KindletToolbarImpl.this.A != null && a.KindletToolbarImpl.this.K.get() != null) {
                    ((JFrame)a.KindletToolbarImpl.this.K.get()).getToolkit().removeAWTEventListener(a.KindletToolbarImpl.this.A);
                    a.KindletToolbarImpl.this.A = null;
                }
                return null;
            }
        });
        a.h.cleanup();
        a.h = null;
    }

    class KindleToolbarDispatcher
    implements AWTEventListener {
        final KindleToolbar K;
        final ChromeHeaderBar B;

        public KindleToolbarDispatcher(KindleToolbar a, ChromeHeaderBar a2) {
            KindleToolbarDispatcher a3;
            a3.K = a;
            a3.B = a2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void eventDispatched(AWTEvent a) {
            KindleToolbarDispatcher a2;
            if (!(a instanceof MouseEvent)) return;
            MouseEvent a3 = (MouseEvent)a;
            switch (a2.K.canInvokeToolbar(a3)) {
                case 0: {
                    if (a2.B == null) return;
                    if (a2.B.isTransientChromeVisible()) return;
                    if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() != (Window)a2.KindletToolbarImpl.this.K.get()) return;
                    if (a2.KindletToolbarImpl.this.c.isLoggable(1024)) {
                        a2.KindletToolbarImpl.this.c.debug("Setting the chrome to be transient for event " + a);
                    }
                    a2.B.setTransientChromeVisible(true);
                    a3.consume();
                    return;
                }
            }
        }
    }
}

