/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.kindlet.internal.subscription;

import com.amazon.ebook.pl.SystemServices;
import com.amazon.ebook.pl.service.DynamicConfigService;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.kindlet.internal.install.Application;
import com.amazon.kindle.kindlet.internal.log.Logger;
import com.amazon.kindle.kindlet.internal.log.LoggerFactory;
import com.amazon.kindle.kindlet.internal.portability.net.NetworkAdapter;
import com.amazon.kindle.kindlet.internal.portability.net.NetworkCommunicationException;
import com.amazon.kindle.kindlet.internal.portability.net.NetworkTypeUnsupportedException;
import com.amazon.kindle.kindlet.internal.portability.net.NetworkWirelessSwitchOffException;
import com.amazon.kindle.kindlet.internal.subscription.SubscriptionClient;
import com.amazon.kindle.kindlet.internal.subscription.SubscriptionDetails;
import com.amazon.kindle.kindlet.internal.subscription.SubscriptionDetailsJSONParser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.HashMap;

public class WebServiceSubscriptionClient
implements SubscriptionClient {
    private static final String h = "cmd.kdk.subs.status";
    private static final String A = "cmd.kdk.subs.status.params";
    private static final String H = "appId";
    private final NetworkAdapter b;
    private final DynamicConfigService K;
    private final Logger B;

    public WebServiceSubscriptionClient(NetworkAdapter a, BookletContext a2) {
        WebServiceSubscriptionClient a3;
        if (a == null) {
            throw new IllegalArgumentException("networkAdapter can't be null.");
        }
        a3.b = a;
        SystemServices a4 = (SystemServices)a2.getService(SystemServices.class);
        if (a4 == null) {
            throw new IllegalStateException("SystemServices cannot be null");
        }
        a3.K = a4.getDynamicConfigService();
        if (a3.K == null) {
            throw new IllegalStateException("DynamicConfigService cannot be null");
        }
        a3.B = LoggerFactory.getLogger((String)"WebServiceSubscriptionClient");
    }

    public SubscriptionDetails getDetails(Application a) throws IOException {
        WebServiceSubscriptionClient a2;
        HashMap<String, String> a3 = new HashMap<String, String>();
        a3.put(H, a.getId());
        String a4 = "";
        try {
            a4 = a2.b.submitAmazonGetRequest(h, a3, true, false);
        }
        catch (NetworkWirelessSwitchOffException a5) {
            a2.B.debug("Wireless switch is off.", (Throwable)a5);
            throw new IOException("User has disabled the wireless network.");
        }
        catch (NetworkTypeUnsupportedException a6) {
            a2.B.error("Service unavailable due to missing hardware.");
            throw new IOException("This device does not have network support.");
        }
        catch (MalformedURLException a7) {
            a2.B.error("KDKSubscriptionURLBad", "Subscription URL is malformed.", (Throwable)a7);
            throw new IOException("Configuration error for subscription URL.");
        }
        catch (NetworkCommunicationException a8) {
            a2.B.debug("Communication exception connecting to subscription service.", (Throwable)a8);
            throw new IOException("An error occured while transfering data.");
        }
        try {
            SubscriptionDetailsJSONParser a9 = new SubscriptionDetailsJSONParser();
            return a9.parse(a4);
        }
        catch (ParseException a10) {
            a2.B.error("KDKSubscriptionServerResponseInvalid", "Could not parse subscription status from server.", (Throwable)a10);
            throw new IOException("Could not parse server response.");
        }
    }
}

