/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.kindlet.internal.security;

import com.amazon.kindle.kindlet.internal.KindletExecutionException;
import com.amazon.kindle.kindlet.internal.log.Logger;
import com.amazon.kindle.kindlet.internal.log.LoggerFactory;
import com.amazon.kindle.kindlet.internal.security.DRMJarFile;
import com.amazon.kindle.kindlet.internal.security.KindletDRMException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;

public class KindletFile
extends DRMJarFile {
    private static final String K = "KINDLET.SF";
    private final File B;
    private final Logger D = LoggerFactory.getLogger((String)"KindletFile");

    /*
     * Enabled aggressive block sorting
     */
    public KindletFile(File a, String a2, boolean a3) throws IOException, KindletDRMException, KindletExecutionException {
        super(a, a2);
        KindletFile a4;
        a4.B = a;
        if (!a4.containsVoucher()) {
            if (a3) return;
            a4.D.error("KindletFileFail", "Production applications should contain the Kindlet meta file. Un-DRMed production applications are not allowed to run.");
            throw new KindletDRMException("Production application should be signed with production signature.");
        }
        if (!a3) {
            a4.validateManifestSignature(K);
            a4.D.debug("Found Kindlet meta file; constructing cipher.");
            return;
        }
        a4.D.error("KindletFileFail", "Developer application is signed with production signature.");
        throw new KindletDRMException("Developer application should not be signed with production signature.");
    }

    public InputStream getInputStream(ZipEntry a) throws IOException {
        KindletFile a2;
        if (a.getName().endsWith(".class")) {
            return a2.decryptInputStream(a);
        }
        return super.getInputStream(a);
    }
}

