/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.kindlet.internal.metadata;

import com.amazon.kindle.kindlet.internal.install.Application;
import com.amazon.kindle.kindlet.internal.log.Logger;
import com.amazon.kindle.kindlet.internal.log.LoggerFactory;
import com.amazon.kindle.kindlet.internal.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class RuntimeMetaData {
    private final Logger h = LoggerFactory.getLogger((String)"RuntimeMetaData");
    private final Properties A;
    private final Application H;
    private final File b;
    private Boolean K;
    private static final String B = "kindlet.version";
    private static final String D = "kindlet.lastRanAt";

    public RuntimeMetaData(Application a, File a2) throws IOException {
        RuntimeMetaData a3;
        if (a == null) {
            throw new IllegalArgumentException("application is null.");
        }
        if (a2 == null) {
            throw new IllegalArgumentException("meta data file does not exist");
        }
        a3.H = a;
        a3.b = a2;
        a3.K = Boolean.TRUE;
        a3.A = new Properties();
        a3.load();
        a3.updateMetadata();
    }

    public Long getLastAccessTime() {
        RuntimeMetaData a;
        String a2 = a.A.getProperty(D);
        try {
            if (null != a2) {
                return Long.valueOf(a2);
            }
        }
        catch (NumberFormatException a3) {
            a.h.warn("getLastAccessTimeFail", "kindlet.lastRanAt key in Kindlet's metadata is not a valid Long!", new String[]{D}, new Object[]{a2});
        }
        File a4 = a.H.getFile();
        if (null != a4 && a4.exists()) {
            return new Long(a4.lastModified());
        }
        return new Long(0L);
    }

    public Boolean isNew() {
        RuntimeMetaData a;
        return a.K;
    }

    private void updateMetadata() {
        RuntimeMetaData a;
        String a2 = a.A.getProperty(B, String.valueOf(Integer.MIN_VALUE));
        int a3 = 0;
        int a4 = 0;
        try {
            a4 = Integer.parseInt(a2);
            if (a.H.getMetadata().getApplicationVersion() != null) {
                a3 = a.H.getMetadata().getApplicationVersion();
            }
        }
        catch (NumberFormatException a5) {
            a.h.warn("updateMetadataFail", "kindlet.version is not an integer.", new String[]{"application", B}, new Object[]{a.H, a2});
        }
        if (a3 > a4) {
            a.A.put(B, String.valueOf(a3));
        }
        a.K = a3 > a4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        RuntimeMetaData a;
        if (a.A != null && a.b != null && a.b.exists()) {
            FileInputStream a2 = null;
            try {
                a2 = new FileInputStream(a.b);
                a.A.load(a2);
            }
            finally {
                if (a2 != null) {
                    FileUtils.reallyClose((InputStream)a2);
                }
            }
        }
    }

    public void updateAndSave() throws IOException {
        RuntimeMetaData a;
        a.A.put(D, String.valueOf(System.currentTimeMillis()));
        a.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() throws IOException {
        RuntimeMetaData a;
        FileOutputStream a2 = null;
        try {
            a2 = new FileOutputStream(a.b);
            a.A.store(a2, "Kindlet MetaData Values");
        }
        finally {
            if (a2 != null) {
                FileUtils.reallyClose((OutputStream)a2);
            }
        }
        a.K = Boolean.FALSE;
        a.h.debug("Saving to application data directory.", new String[]{"file"}, new Object[]{a.b});
    }

    public String toString() {
        RuntimeMetaData a;
        return " lastAccessTime=" + a.getLastAccessTime() + " isNew=" + a.isNew() + " Current Version=" + a.A.getProperty(B);
    }
}

