/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.kindlet.internal.input.keyboard;

import com.amazon.ebook.util.input.KindleInputMethod;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.keyboard.KeyboardEvent;
import com.amazon.kindle.keyboard.KeyboardListener;
import com.amazon.kindle.kindlet.input.keyboard.OnscreenKeyboardEvent;
import com.amazon.kindle.kindlet.input.keyboard.OnscreenKeyboardListener;
import com.amazon.kindle.kindlet.input.keyboard.OnscreenKeyboardManager;
import com.amazon.kindle.kindlet.internal.KindletProcess;
import com.amazon.kindle.kindlet.internal.log.Logger;
import com.amazon.kindle.kindlet.internal.log.LoggerFactory;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.im.InputContext;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class KindletOnscreenKeyboardManager
implements OnscreenKeyboardManager {
    private final Logger A = LoggerFactory.getLogger((Class)KindletOnscreenKeyboardManager.class);
    private final Set H;
    protected final KeyboardListener b;
    private final BookletContext K;
    private final KindletProcess B;

    KindletOnscreenKeyboardManager(BookletContext a, KindletProcess a2) {
        KindletOnscreenKeyboardManager a3;
        if (a == null) {
            throw new IllegalArgumentException("Cannot handle null booklet context");
        }
        if (a2 == null) {
            throw new IllegalArgumentException("Application sandbox cannot be null.");
        }
        a3.B = a2;
        a3.K = a;
        a3.b = new KeyboardListener(){
            {
                1 a;
            }

            public void onKeyboardEvent(KeyboardEvent a) {
                1 a2;
                a2.KindletOnscreenKeyboardManager.this.notify(a2.KindletOnscreenKeyboardManager.this.getOnscreenKeyboardEvent(a));
            }
        };
        a3.H = new LinkedHashSet();
    }

    public static KindletOnscreenKeyboardManager newInstance(BookletContext a, KindletProcess a2) {
        KindletOnscreenKeyboardManager a3 = new KindletOnscreenKeyboardManager(a, a2);
        a.addKeyboardListener(a3.b);
        return a3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        KindletOnscreenKeyboardManager a;
        Set set = a.H;
        synchronized (set) {
            a.H.clear();
        }
    }

    KeyboardListener getFrameworkKeyboardListener() {
        KindletOnscreenKeyboardManager a;
        return a.b;
    }

    public void setVisible(boolean a) {
        KindletOnscreenKeyboardManager a2;
        if (a) {
            a2.K.showKeyboard();
        } else {
            a2.K.hideKeyboard();
        }
    }

    public boolean isVisible() {
        KindletOnscreenKeyboardManager a;
        return a.K.isKeyboardVisible();
    }

    public Rectangle getBounds() {
        KindletOnscreenKeyboardManager a;
        InputContext a2 = a.K.getUIContainer().getInputContext();
        return a.getBounds(a2);
    }

    Rectangle getBounds(InputContext a) {
        if (a == null) {
            KindletOnscreenKeyboardManager a2;
            if (a2.A.isLoggable(1024)) {
                a2.A.debug("input context currently null");
            }
            return null;
        }
        Object a3 = a.getInputMethodControlObject();
        if (a3 instanceof KindleInputMethod) {
            KindleInputMethod a4 = (KindleInputMethod)a3;
            return new Rectangle(a4.getKeyboardBounds());
        }
        return null;
    }

    public Dimension getSize() {
        KindletOnscreenKeyboardManager a;
        Rectangle a2 = a.getBounds();
        return a2 == null ? null : a2.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeyboardListener(OnscreenKeyboardListener a) {
        if (a != null) {
            KindletOnscreenKeyboardManager a2;
            Set set = a2.H;
            synchronized (set) {
                a2.H.add(a);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeyboardListener(OnscreenKeyboardListener a) {
        if (a != null) {
            KindletOnscreenKeyboardManager a2;
            Set set = a2.H;
            synchronized (set) {
                a2.H.remove(a);
            }
        }
    }

    public OnscreenKeyboardListener[] getKeyboardListeners() {
        KindletOnscreenKeyboardManager a;
        return a.H.toArray(new OnscreenKeyboardListener[0]);
    }

    OnscreenKeyboardEvent getOnscreenKeyboardEvent(KeyboardEvent a) {
        if (a != null) {
            KindletOnscreenKeyboardManager a2;
            switch (a.getType()) {
                case 1: {
                    return new OnscreenKeyboardEvent(a.getBounds(), "KEYBOARD_SHOWN", a.getTimestamp());
                }
                case 2: {
                    while (false) {
                    }
                    return new OnscreenKeyboardEvent(a.getBounds(), "KEYBOARD_HIDDEN", a.getTimestamp());
                }
            }
            a2.A.warn("keyboard event not recognized. " + a);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notify(final OnscreenKeyboardEvent a) {
        KindletOnscreenKeyboardManager a2;
        Set set = a2.H;
        synchronized (set) {
            Iterator a3 = a2.H.iterator();
            final OnscreenKeyboardListener[] a4 = a2.H.toArray(new OnscreenKeyboardListener[a2.H.size()]);
            if (a4.length > 0) {
                a2.B.invokeLater(new Runnable(){
                    {
                        2 a2;
                    }

                    public void run() {
                        2 a2;
                        if (a2.KindletOnscreenKeyboardManager.this.A.isLoggable(1024)) {
                            a2.KindletOnscreenKeyboardManager.this.A.debug("Notifying onscreen keyboard listeners about " + a2.a);
                        }
                        a2.KindletOnscreenKeyboardManager.this.notifyListeners(a2.a, a2.a4);
                    }
                }, true);
            }
        }
    }

    void notifyListeners(OnscreenKeyboardEvent a, OnscreenKeyboardListener[] a2) {
        int a3;
        int n = a3 = 0;
        while (n < a2.length) {
            KindletOnscreenKeyboardManager a4;
            try {
                if ("KEYBOARD_SHOWN".equals(a.getType())) {
                    a2[a3].keyboardShown(a);
                } else if ("KEYBOARD_HIDDEN".equals(a.getType())) {
                    a2[a3].keyboardHidden(a);
                } else if ("KEYBOARD_MOVED".equals(a.getType())) {
                    a2[a3].keyboardMoved(a);
                } else if ("KEYBOARD_RESIZED".equals(a.getType())) {
                    a2[a3].keyboardResized(a);
                } else {
                    a4.A.warn("Unrecognized onscreen keyboard event " + a);
                }
            }
            catch (Exception a5) {
                a4.A.warn("Unable to dispatch the onscreen keyboard event to listener");
            }
            n = ++a3;
        }
    }
}

