/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.kindlet.internal;

import com.amazon.ebook.util.thread.ThreadPool;
import com.amazon.kindle.kindlet.internal.KindletBooklet;
import com.amazon.kindle.kindlet.internal.event.BookletLifecycleEvent;
import com.amazon.kindle.kindlet.internal.event.BookletStartEvent;
import com.amazon.kindle.kindlet.internal.event.BookletStopEvent;
import com.amazon.kindle.kindlet.internal.log.Logger;
import com.amazon.kindle.kindlet.internal.log.LoggerFactory;
import com.amazon.kindle.kindlet.internal.portability.device.KindletPowerEvent;
import com.amazon.kindle.kindlet.internal.portability.device.KindletPowerStateChangeListener;
import com.amazon.kindle.kindlet.internal.portability.device.KindletStorage;
import com.amazon.kindle.kindlet.internal.portability.device.KindletStorageEvent;
import com.amazon.kindle.kindlet.internal.portability.device.KindletStorageListener;
import com.amazon.kindle.kindlet.internal.portability.device.PowerNotificationAdapter;

public class KindletBookletLifecycleHandler {
    private final KindletBooklet A;
    private final KindletStorage H;
    private final PowerNotificationAdapter b;
    final KindletStorageListener K;
    final KindletPowerStateChangeListener B;
    private final Logger D;

    KindletBookletLifecycleHandler(KindletBooklet a, KindletStorage a2, PowerNotificationAdapter a3) {
        KindletBookletLifecycleHandler a4;
        if (a == null) {
            throw new IllegalArgumentException("Cannot handle null booklet instance");
        }
        if (a2 == null) {
            throw new IllegalArgumentException("Storage adapter is not initialized.");
        }
        if (a3 == null) {
            throw new IllegalArgumentException("Power notification adapter is not initialized.");
        }
        a4.A = a;
        a4.H = a2;
        a4.b = a3;
        a4.D = LoggerFactory.getLogger((String)"KindletBookletLifecycleHandler");
        a4.B = new KindletPowerStateChangeListener(){
            {
                1 a;
            }

            public void powerStateChanged(final KindletPowerEvent a) {
                1 a2;
                ThreadPool.getInstance().runIt(new Runnable(){
                    {
                        1 a2;
                    }

                    public void run() {
                        1 a2;
                        if (KindletPowerEvent.H.equals(a2.a)) {
                            if (KindletBookletLifecycleHandler.this.D.isLoggable(1024)) {
                                KindletBookletLifecycleHandler.this.D.debug("Device is going to screensaver, Booklet stop event sent");
                            }
                            KindletBookletLifecycleHandler.this.handleEvent(new BookletStopEvent("enter-ss"));
                        } else if (KindletPowerEvent.b.equals(a2.a)) {
                            if (KindletBookletLifecycleHandler.this.D.isLoggable(1024)) {
                                KindletBookletLifecycleHandler.this.D.debug("Device is coming out of screensaver, Booklet start event sent");
                            }
                            KindletBookletLifecycleHandler.this.handleEvent(new BookletStartEvent("exit-ss"));
                        } else if (KindletPowerEvent.K.equals(a2.a)) {
                            if (KindletBookletLifecycleHandler.this.D.isLoggable(1024)) {
                                KindletBookletLifecycleHandler.this.D.debug("User shutdown has been initiated. Booklet stop event sent");
                            }
                            KindletBookletLifecycleHandler.this.handleEvent(new BookletStopEvent("enter-usershutdown"));
                        } else if (KindletPowerEvent.B.equals(a2.a)) {
                            if (KindletBookletLifecycleHandler.this.D.isLoggable(1024)) {
                                KindletBookletLifecycleHandler.this.D.debug("Device is coming out of a user shutdown suspend. Booklet start event sent");
                            }
                            KindletBookletLifecycleHandler.this.handleEvent(new BookletStartEvent("exit-user-shutdown"));
                        } else if (KindletBookletLifecycleHandler.this.D.isLoggable(1024)) {
                            KindletBookletLifecycleHandler.this.D.debug("Unknown KindletPowerEvent encountered ", a2.a.getEvent());
                        }
                    }
                }, "KindletPowerStateChangeListener");
            }
        };
        a4.K = new KindletStorageListener(){
            {
                2 a;
            }

            public void onAvailabilityChange(final KindletStorageEvent a) {
                2 a2;
                ThreadPool.getInstance().runIt(new Runnable(){
                    {
                        1 a2;
                    }

                    public void run() {
                        1 a2;
                        if (KindletStorageEvent.B.equals((Object)a2.a)) {
                            if (KindletBookletLifecycleHandler.this.D.isLoggable(1024)) {
                                KindletBookletLifecycleHandler.this.D.debug("USB mounted, starting current application");
                            }
                            KindletBookletLifecycleHandler.this.handleEvent(new BookletStartEvent("exit-usb"));
                        } else if (KindletStorageEvent.H.equals((Object)a2.a)) {
                            if (KindletBookletLifecycleHandler.this.D.isLoggable(1024)) {
                                KindletBookletLifecycleHandler.this.D.debug("about to unmount USB, stopping current application");
                            }
                            KindletBookletLifecycleHandler.this.handleEvent(new BookletStopEvent("enter-usb"));
                        } else if (KindletBookletLifecycleHandler.this.D.isLoggable(1024)) {
                            KindletBookletLifecycleHandler.this.D.debug("Unhandled Kindlet USB event. " + a2.a);
                        }
                    }
                }, "KindletStorageListener");
            }
        };
    }

    public static KindletBookletLifecycleHandler newInstance(KindletBooklet a, KindletStorage a2, PowerNotificationAdapter a3) {
        KindletBookletLifecycleHandler a4 = new KindletBookletLifecycleHandler(a, a2, a3);
        a2.addKindletStoreListener(a4.K);
        a3.addPowerStateChangeListener(a4.B);
        return a4;
    }

    public void handleEvent(BookletLifecycleEvent a) {
        if (a != null) {
            KindletBookletLifecycleHandler a2;
            if (a instanceof BookletStartEvent) {
                a2.A.doStart((BookletStartEvent)a);
            } else if (a instanceof BookletStopEvent) {
                a2.A.doStop((BookletStopEvent)a);
            } else {
                a2.D.error("Unhandled booklet lifecycle event: " + a);
                throw new IllegalStateException("KindletBooklet Unhandled lifecycle event : " + a);
            }
        }
    }

    public void shutdown() {
        KindletBookletLifecycleHandler a;
        a.H.removeKindletStoreListener(a.K);
        a.b.removePowerStateChangeListener(a.B);
    }
}

