/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.kindlet.internal;

import com.amazon.ebook.util.file.UserPreferences;
import com.amazon.ebook.util.log.DeviceEventScope;
import com.amazon.ebook.util.thread.ThreadPool;
import com.amazon.kindle.booklet.AbstractBooklet;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.booklet.BookletException;
import com.amazon.kindle.booklet.BookletServices;
import com.amazon.kindle.booklet.LifecycleException;
import com.amazon.kindle.content.catalog.CatalogEntry;
import com.amazon.kindle.content.catalog.CatalogService;
import com.amazon.kindle.content.catalog.MutableItem;
import com.amazon.kindle.device.time.SystemDateTimeEvent;
import com.amazon.kindle.device.time.SystemDateTimeListener;
import com.amazon.kindle.device.time.TimeService;
import com.amazon.kindle.kindlet.device.Device;
import com.amazon.kindle.kindlet.internal.BookletSandboxKindletProcessFactory;
import com.amazon.kindle.kindlet.internal.IllegalKindletStateException;
import com.amazon.kindle.kindlet.internal.KindletBookletAppContextFactory;
import com.amazon.kindle.kindlet.internal.KindletBookletLifecycleHandler;
import com.amazon.kindle.kindlet.internal.KindletContainerException;
import com.amazon.kindle.kindlet.internal.KindletExecutionException;
import com.amazon.kindle.kindlet.internal.KindletLoadException;
import com.amazon.kindle.kindlet.internal.KindletProcess;
import com.amazon.kindle.kindlet.internal.KindletProcessFactory;
import com.amazon.kindle.kindlet.internal.KindletProcessManager;
import com.amazon.kindle.kindlet.internal.MessagableKindletLoadException;
import com.amazon.kindle.kindlet.internal.capability.DeviceImpl;
import com.amazon.kindle.kindlet.internal.det.DETEventStreamFactory;
import com.amazon.kindle.kindlet.internal.det.Event;
import com.amazon.kindle.kindlet.internal.det.EventStream;
import com.amazon.kindle.kindlet.internal.det.SimpleErrorEvent;
import com.amazon.kindle.kindlet.internal.det.SimpleEvent;
import com.amazon.kindle.kindlet.internal.event.BookletLifecycleEvent;
import com.amazon.kindle.kindlet.internal.event.BookletStartEvent;
import com.amazon.kindle.kindlet.internal.event.BookletStopEvent;
import com.amazon.kindle.kindlet.internal.event.ViewContentEvent;
import com.amazon.kindle.kindlet.internal.history.KindletBookmark;
import com.amazon.kindle.kindlet.internal.history.KindletHistoryServiceAdapter;
import com.amazon.kindle.kindlet.internal.install.Application;
import com.amazon.kindle.kindlet.internal.install.InstallException;
import com.amazon.kindle.kindlet.internal.install.InstallFactory;
import com.amazon.kindle.kindlet.internal.install.MissingExtensionException;
import com.amazon.kindle.kindlet.internal.log.Logger;
import com.amazon.kindle.kindlet.internal.log.LoggerFactory;
import com.amazon.kindle.kindlet.internal.net.NetworkAccessRequesterFactory;
import com.amazon.kindle.kindlet.internal.net.NetworkManager;
import com.amazon.kindle.kindlet.internal.portability.DeviceServicesAccessor;
import com.amazon.kindle.kindlet.internal.portability.DeviceServicesAccessorImpl;
import com.amazon.kindle.kindlet.internal.portability.device.KindletHeapMemoryEvent;
import com.amazon.kindle.kindlet.internal.portability.device.KindletMemoryEventListener;
import com.amazon.kindle.kindlet.internal.portability.device.KindletProcessMemoryEvent;
import com.amazon.kindle.kindlet.internal.portability.device.KindletStorage;
import com.amazon.kindle.kindlet.internal.portability.device.MemoryNotificationAdapter;
import com.amazon.kindle.kindlet.internal.portability.device.PowerNotificationAdapter;
import com.amazon.kindle.kindlet.internal.portability.security.KindletCertificateManager;
import com.amazon.kindle.kindlet.internal.portability.service.MarketplaceServiceHelper;
import com.amazon.kindle.kindlet.internal.portability.ui.KindletSystemAlert;
import com.amazon.kindle.kindlet.internal.subscription.SubscriptionClient;
import com.amazon.kindle.kindlet.internal.subscription.SubscriptionManager;
import com.amazon.kindle.kindlet.internal.subscription.WebServiceSubscriptionClient;
import com.amazon.kindle.kindlet.internal.util.ContentCatalogUtil;
import com.amazon.kindle.kindlet.internal.util.FrameworkRestart;
import com.amazon.kindle.kindlet.internal.util.GarbageMonitor;
import com.amazon.kindle.restricted.booklet.BookletExtension;
import com.amazon.kindle.restricted.booklet.impl.BookletImplementation;
import com.amazon.kindle.restricted.device.KindleSystemServices;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class KindletBooklet
extends AbstractBooklet
implements BookletExtension {
    private static final String o = "Error when resuming application: Deleted while resuming application";
    public static final String RESOURCE_BUNDLE_NAME = "com.amazon.kindle.kindlet.internal.resources.KindletBookletResources";
    private static final String t = "com.lab126.booklet.home";
    static final String Q = "kindlet.crash.startup.message.pattern";
    private static final String V = "kindlet.crash.shutdown.message.pattern";
    private static final String u = "kindlet.remove.message";
    private static final String y = "kindlet.upgrade.required.pattern";
    static final String O = "kindlet.capability.fail.pattern";
    public static final String BOOKLET_NAME = "com.lab126.booklet.kindlet";
    public static final String DET_EVENT_NAME = "KindletBooklet";
    private final Logger x;
    private final Object f = new Object();
    private final EventStream M;
    private KindletProcessManager J;
    private KindletCertificateManager G;
    private NetworkManager a;
    private SubscriptionManager i;
    DeviceServicesAccessor E;
    private UserPreferences C;
    private NetworkAccessRequesterFactory d;
    private BookletServices j;
    private KindletStorage g;
    private PowerNotificationAdapter e;
    private KindletMemoryEventListener I;
    private MemoryNotificationAdapter F;
    private KindletBookletLifecycleHandler L;
    private KindletHistoryServiceAdapter c;
    private CatalogService l;
    private SystemDateTimeListener k;
    private Device m;
    private final String h = "ACTIVE";
    private final String A = "NEW";
    private final String H = "DEV";

    public KindletBooklet() {
        this.x = LoggerFactory.getLogger((String)DET_EVENT_NAME);
        this.M = DETEventStreamFactory.getEventStream((String)DET_EVENT_NAME);
    }

    public void create(BookletContext bookletContext) {
        URL a;
        super.create(bookletContext);
        if (null == this.E) {
            this.E = DeviceServicesAccessorImpl.getInstance();
            ((DeviceServicesAccessorImpl)this.E).setBookletContext(bookletContext);
        }
        this.g = this.E.getStorageAdapter();
        this.e = this.E.getPowerNotificationAdapter();
        this.F = this.E.getMemoryNotificationAdapter();
        this.F.addMemoryEventListener(this.createMemoryListener());
        this.G = this.E.getKindletCertificateManager();
        if (this.m == null) {
            a = this.E.getDeviceCapabilityAdapter().getFile();
            this.m = new DeviceImpl(a);
        }
        if (!GarbageMonitor.currentMonitor().isAlive()) {
            GarbageMonitor.currentMonitor().start();
        }
        this.C = bookletContext.getPreferences("system");
        this.a = new NetworkManager(bookletContext, this.E.getNetworkAdapter(), this.C);
        this.L = KindletBookletLifecycleHandler.newInstance(this, this.g, this.e);
        this.d = new NetworkAccessRequesterFactory(this.a, this.E.getNetworkAdapter());
        this.i = new SubscriptionManager(Executors.newSingleThreadExecutor(), (SubscriptionClient)new WebServiceSubscriptionClient(this.E.getNetworkAdapter(), bookletContext));
        this.k = new SystemDateTimeListener(){
            {
                1 a;
            }

            public void onSystemDateTimeChange(SystemDateTimeEvent a) {
                1 a2;
                a2.KindletBooklet.this.i.adjustTime(a.getDelta());
            }
        };
        a = (TimeService)bookletContext.getService(TimeService.class);
        a.addSystemDateTimeListener(this.k);
        this.c = KindletHistoryServiceAdapter.newInstance((Booklet)this);
        this.l = (CatalogService)bookletContext.getService(CatalogService.class);
        this.j = (BookletServices)bookletContext.getService(BookletServices.class);
        if (null == this.j) {
            throw new IllegalArgumentException("booklet services cannot be null");
        }
    }

    public void start(URI contentURI) {
        this.x.debug("Starting KindletBooklet...");
        super.start(contentURI);
        this.L.handleEvent(new ViewContentEvent("new-content", contentURI));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void doStart(BookletStartEvent a) {
        block16: {
            KindletBooklet a2;
            AtomicBoolean a3 = new AtomicBoolean(true);
            DeviceEventScope a4 = a2.M.startScope((Event)new SimpleEvent("start"));
            a2.annotateMetricsWithEventType(a4, a);
            a2.annotateMetricsWithHeapInfo(a4);
            a2.x.debug("KindletBooklet#doStart() " + a);
            if (a2.J == null) {
                try {
                    a2.J = a2.createProcessManager();
                }
                catch (KindletContainerException a5) {
                    a2.M.record((Event)new SimpleErrorEvent("KindletContainerExceptionOnStart"));
                    a2.requestRestartKindleFramework();
                    a2.unloadAndThrowException(a, (Exception)((Object)a5), null);
                }
            }
            try {
                if ("new-content".equals(a.getId())) {
                    ViewContentEvent a6 = (ViewContentEvent)a;
                    KindletBookmark a7 = KindletBookmark.newInstance((Booklet)a2, a6.getContentURI());
                    Application a8 = a2.getApplication(new File(a7.getFilename()).toURI(), a);
                    if (a8 != null) {
                        a2.killProcess(null, a);
                        FrameworkRestart.initialize();
                        a2.runProcess(a8, Q, a);
                        a2.updateContentCatalog(a8);
                    }
                    break block16;
                }
                if ("exit-user-shutdown".equals(a.getId())) {
                    a2.resumeProcess(Q, a, a3);
                    break block16;
                }
                if ("exit-usb".equals(a.getId())) {
                    a2.resumeProcess(Q, a, a3);
                    break block16;
                }
                if ("exit-ss".equals(a.getId())) {
                    a2.resumeProcess(Q, a, a3);
                    break block16;
                }
                a2.x.warn("doStartUnknown", "Unknown BookletStartEvent.", new String[]{"event"}, new Object[]{a});
                throw new IllegalStateException("Unknown booklet event to start Kindlet. ");
            }
            catch (KindletContainerException a9) {
                a2.x.error("startFail", "Failed to start Kindlet due to internal error.", (Throwable)a9);
                a2.M.record((Event)new SimpleErrorEvent("KindletContainerExceptionOnStart"));
                a2.requestRestartKindleFramework();
                a2.unloadAndThrowException(a, (Exception)((Object)a9), null);
            }
            catch (IllegalKindletStateException a10) {
                a2.x.error("startFail", "Failed to start Kindlet due to misbehaving threads.", (Throwable)a10);
                DETEventStreamFactory.getEventStream((Application)a2.getProcessManager().getActiveProcess().getApplication()).record((Event)new SimpleEvent("IllegalKindletStateOnStart"));
                a2.requestRestartKindleFramework();
                a2.unloadAndThrowException(a, (Exception)((Object)a10), null);
            }
            finally {
                if (a3.get() && null != a4) {
                    a2.annotateMetricsWithApplicationInfo(a4);
                    a2.annotateMetricsWithHeapInfo(a4);
                    a4.end();
                }
            }
        }
    }

    public void stop() {
        this.x.debug("Stopping KindletBooklet...");
        super.stop();
        this.L.handleEvent(new BookletStopEvent("switch-out"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void doStop(BookletStopEvent a) {
        block18: {
            KindletBooklet a2;
            AtomicBoolean a3 = new AtomicBoolean(true);
            DeviceEventScope a4 = a2.M.startScope((Event)new SimpleEvent("stop"));
            a2.annotateMetricsWithEventType(a4, a);
            try {
                a2.x.debug("KindletBooklet#doStop() " + a);
                if ("switch-out".equals(a.getId()) || "unload".equals(a.getId())) {
                    try {
                        if (a2.getProcessManager().isRunning()) {
                            Application a5 = a2.getProcessManager().getActiveProcess().getApplication();
                            a2.getHistoryServiceAdapter().addToHistory(a5);
                        }
                        a2.killProcess(V, a);
                        super.stop();
                    }
                    catch (KindletContainerException a6) {
                        a2.x.error("stopFail", "Failed to shutdown Kindlet due to internal error.", (Throwable)a6);
                        a2.M.record((Event)new SimpleErrorEvent("KindletContainerExceptionOnStop"));
                        a2.requestRestartKindleFramework();
                        a2.unloadAndThrowException(a, (Exception)((Object)a6), null);
                    }
                    catch (IllegalKindletStateException a7) {
                        a2.x.error("stopFail", "Failed to shutdown Kindlet due to misbehaving threads. No active process.", (Throwable)a7);
                        if (null != a2.getProcessManager() && null != a2.getProcessManager().getActiveProcess() && null != a2.getProcessManager().getActiveProcess().getApplication()) {
                            DETEventStreamFactory.getEventStream((Application)a2.getProcessManager().getActiveProcess().getApplication()).record((Event)new SimpleEvent("IllegalKindletStateOnStop"));
                        } else {
                            a2.M.record((Event)new SimpleEvent("IllegalKindletStateOnStop"));
                        }
                        a2.requestRestartKindleFramework();
                        a2.unloadAndThrowException(a, (Exception)((Object)a7), null);
                    }
                    return;
                }
                try {
                    if ("enter-usershutdown".equals(a.getId())) {
                        a2.pauseProcess(a, a3);
                        break block18;
                    }
                    if ("enter-usb".equals(a.getId())) {
                        a2.pauseProcess(a, a3);
                        break block18;
                    }
                    if ("enter-ss".equals(a.getId())) {
                        a2.pauseProcess(a, a3);
                        break block18;
                    }
                    a2.x.warn("doStopUnknown", "Unknown BookletStopEvent.", new String[]{"event"}, new Object[]{a});
                }
                catch (KindletExecutionException a8) {
                    a2.x.error("stopFail", "Failed to pause Kindlet due to error in Kindlet code.", (Throwable)a8);
                    a2.getProcessManager().getActiveProcess().setPendingException((Exception)((Object)a8));
                }
                catch (KindletContainerException a9) {
                    a2.x.error("stopFail", "Failed to pause Kindlet due to internal error.", (Throwable)a9);
                    a2.M.record((Event)new SimpleErrorEvent("KindletContainerExceptionOnStop"));
                    a2.getProcessManager().getActiveProcess().setPendingException((Exception)((Object)a9));
                }
            }
            finally {
                if (a3.get() && null != a4) {
                    a2.annotateMetricsWithApplicationInfo(a4);
                    a2.annotateMetricsWithHeapInfo(a4);
                    a4.end();
                }
            }
        }
    }

    private void addToCrashLog(String a) {
        KindletBooklet a2;
        if (a2.J != null && a2.J.getActiveProcess() != null) {
            a2.J.getActiveProcess().appendToCrashLog(a);
        }
    }

    private KindletMemoryEventListener createMemoryListener() {
        KindletBooklet a;
        a.I = new KindletMemoryEventListener(){
            {
                2 a;
            }

            public void processMemoryLow(KindletProcessMemoryEvent a) {
                2 a2;
                a2.KindletBooklet.this.addToCrashLog("Memory usage is in a critical state. " + a.getNonReclaimable());
            }

            public void heapMemoryLow(KindletHeapMemoryEvent a) {
                if (a.getPercentFree() <= 2) {
                    2 a2;
                    a2.KindletBooklet.this.addToCrashLog("Heap memory is very low " + a.getPercentFree());
                }
            }
        };
        return a.I;
    }

    private void unloadAndThrowException(BookletLifecycleEvent a, Exception a2, String a3) throws LifecycleException {
        KindletBooklet a4;
        if ("new-content".equals(a.getId())) {
            a4.unloadAndThrowException(true, "Failed to start Kindlet due to internal error: " + a2.getMessage(), a3);
        } else if ("switch-out".equals(a.getId()) || "unload".equals(a.getId())) {
            a4.unloadAndThrowException(true, "Failed to stop Kindlet due to internal error: " + a2.getMessage(), a3);
        } else {
            a4.unloadAndThrowException(false, "An error has occurred: " + a2.getMessage(), a3);
        }
    }

    public void unloadAndThrowException(boolean inAppmgrLifecycleMethod, String logMessage) throws LifecycleException {
        this.unloadAndThrowException(inAppmgrLifecycleMethod, logMessage, null);
    }

    public void unloadAndThrowException(boolean inAppmgrLifecycleMethod, String logMessage, String messageKey, String resourceBundle) throws LifecycleException {
        this.unloadAndThrowException(inAppmgrLifecycleMethod, logMessage, this.getMessage(messageKey, resourceBundle));
    }

    public void unloadAndThrowException(boolean inAppmgrLifecycleMethod, String logMessage, String displayableMessage) throws LifecycleException {
        this.x.error("Unloading Kindlet, error = " + logMessage + ", msg = " + displayableMessage);
        if (null != this.getProcessManager() && null != this.getProcessManager().getActiveProcess()) {
            this.getProcessManager().getActiveProcess().prepareForShutdown();
        }
        if (!inAppmgrLifecycleMethod) {
            if (this.getBookletContext() instanceof BookletImplementation) {
                ThreadPool.getInstance().runIt(new Runnable(){
                    {
                        3 a;
                    }

                    public void run() {
                        3 a;
                        ((BookletImplementation)a.KindletBooklet.this.getBookletContext()).unloadAndExit();
                    }
                }, "UnloadingKindletBookletThread");
            } else {
                this.x.error("goHowAndUnloadOnException(): Unexpected error = " + logMessage);
                this.postGoHomeSilently();
            }
        }
        if (displayableMessage != null) {
            this.E.getKindletSystemAlert().showAlertString(displayableMessage);
        }
        throw new LifecycleException(100, true, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        DeviceEventScope a = this.M.startScope((Event)new SimpleEvent("destroy"));
        try {
            if (null != this.J && this.J.hasActiveProcess() && null != this.L) {
                try {
                    this.x.warn("destroy() while there is still an active process. stop() should be called first.");
                    this.L.handleEvent(new BookletStopEvent("unload"));
                }
                catch (Exception a2) {
                    this.x.warn("Unexpected exception caught while calling doStop during destroy. Ignoring and continuing with destroy");
                }
            }
            if (null != this.a) {
                this.a.destroy();
                this.a = null;
            }
            if (null != this.d) {
                this.d.destroy();
                this.d = null;
            }
            if (null != this.L) {
                this.L.shutdown();
            }
            if (null != this.k) {
                TimeService a3 = (TimeService)this.getBookletContext().getService(TimeService.class);
                if (null != a3) {
                    a3.removeSystemDateTimeListener(this.k);
                }
                this.k = null;
            }
            if (this.F != null) {
                this.F.removeMemoryEventListener(this.I);
                this.I = null;
                this.F = null;
            }
            this.j = null;
            this.G = null;
            this.c = null;
            this.L = null;
            this.J = null;
            this.g = null;
            this.C = null;
            this.l = null;
            this.i = null;
            if (null != this.E) {
                ((DeviceServicesAccessorImpl)this.E).clearBookletContext();
                this.E = null;
            }
        }
        finally {
            a.end();
        }
        super.destroy();
    }

    protected KindletProcessManager getProcessManager() {
        KindletBooklet a;
        return a.J;
    }

    protected Application getApplication(URI a, BookletLifecycleEvent a2) {
        KindletBooklet a3;
        if (a == null) {
            a3.x.warn("getApplicationFail", "Framework provided null for content URI in a ViewContentEvent: ");
            return null;
        }
        File a4 = new File(a);
        try {
            Application a5 = InstallFactory.getInstallService().getApplication(a4);
            try {
                InstallFactory.getInstallService().checkExtensions(a5);
            }
            catch (MissingExtensionException a6) {
                DETEventStreamFactory.getEventStream((Application)a5).record((Event)new SimpleEvent("SDKUpgradeRequired"));
                a3.unloadAndThrowException(a2, (Exception)((Object)a6), MarketplaceServiceHelper.getURLMessage((String)RESOURCE_BUNDLE_NAME, (String)y));
                return null;
            }
            return a5;
        }
        catch (InstallException a7) {
            a3.x.error("getApplicationFail", "Could not load an application from " + a + " due to " + a7.getMessage());
            a3.unloadAndThrowException(a2, (Exception)((Object)a7), MarketplaceServiceHelper.getURLMessage((String)RESOURCE_BUNDLE_NAME, (String)Q));
            return null;
        }
    }

    protected Application getApplication(File a) throws InstallException {
        return InstallFactory.getInstallService().getApplication(a);
    }

    protected NetworkManager getNetworkManager() {
        KindletBooklet a;
        return a.a;
    }

    protected KindletHistoryServiceAdapter getHistoryServiceAdapter() {
        KindletBooklet a;
        return a.c;
    }

    protected void updateContentCatalog(Application a) {
        KindletBooklet a2;
        long a3 = System.currentTimeMillis();
        try {
            CatalogEntry a4 = ContentCatalogUtil.getCatalogEntry((CatalogService)a2.l, (File)a.getFile());
            if (a4 != null) {
                ArrayList<String> a5 = new ArrayList<String>();
                MutableItem a6 = a2.l.createMutableItem(a4.getUUID());
                a6.setLastAccessDate(new Date(a3));
                String[] a7 = a4.getDisplayTags();
                if (a7 != null) {
                    int a8;
                    int n = a8 = 0;
                    while (n < a7.length) {
                        String a9 = a7[a8];
                        if (a9.length() > 0 && !a9.equals("NEW")) {
                            a5.add(a9);
                        }
                        n = ++a8;
                    }
                    if (a5.size() == 0) {
                        if (a.isDeveloper()) {
                            a5.add("DEV");
                        } else {
                            a5.add("ACTIVE");
                        }
                    }
                    a6.setDisplayTags(a5.toArray(new String[0]));
                }
                ContentCatalogUtil.setCatalogItem((CatalogService)a2.l, (MutableItem)a6, (boolean)true);
                if (a2.x.isLoggable(1024)) {
                    a2.x.debug("Updating application metadata took " + (System.currentTimeMillis() - a3));
                }
            } else if (a2.x.isLoggable(0x800000)) {
                a2.x.info("Tried to update metadata for " + a.getFile().toURI().toString() + ", but could not find catalog entry.");
            }
        }
        catch (Exception a10) {
            a2.M.record((Event)new SimpleErrorEvent("ContentCatalogUpdateFailed"));
            a2.x.warn("ContentCatalogUpdateFailed", "Failed to update the ContentCatalog on Kindlet shutdown. Home may display incorrect data about this Kindlet.", (Throwable)a10);
        }
    }

    protected void runProcess(Application a, String a2, BookletLifecycleEvent a3) throws KindletContainerException {
        KindletBooklet a4;
        try {
            if (a != null) {
                a4.getProcessManager().run(a);
            }
        }
        catch (KindletExecutionException a5) {
            String a6 = null;
            if (a5.getLocalizedMessage() != null && a5.getBundleName() != null) {
                a6 = a4.getMessage(a5.getMessageKey(), a5.getBundleName());
            } else if (a5.isLocalizedUserFacingMessage()) {
                a6 = a5.getKindletMessage();
            } else if (a2 != null) {
                a6 = a4.getMessage(a2, RESOURCE_BUNDLE_NAME);
            }
            DETEventStreamFactory.getEventStream((Application)a).record((Event)new SimpleEvent("KindletExecutionExceptionOnRun"));
            a4.unloadAndThrowException(a3, (Exception)((Object)a5), a6);
        }
        catch (KindletLoadException a7) {
            MessagableKindletLoadException a8;
            String a9 = a7 instanceof MessagableKindletLoadException ? ((a8 = (MessagableKindletLoadException)a7).getMessageKey() != null && a8.getBundleName() != null ? a4.getMessage(a8.getMessageKey(), a8.getBundleName()) : a4.getMessage(a2, RESOURCE_BUNDLE_NAME)) : a4.getMessage(a2, RESOURCE_BUNDLE_NAME);
            DETEventStreamFactory.getEventStream((Application)a).record((Event)new SimpleEvent("KindletLoadExceptionOnRun"));
            a4.unloadAndThrowException(a3, (Exception)((Object)a7), a9);
        }
    }

    protected void pauseProcess(BookletLifecycleEvent a, AtomicBoolean a2) throws KindletContainerException, KindletExecutionException {
        KindletBooklet a3;
        if (a3.getProcessManager() == null || a3.getProcessManager().getActiveProcess() == null) {
            a2.set(false);
            return;
        }
        if ("enter-usb".equals(a.getId()) && a3.E.getUSBStatusProvider().willUserstoreRemainAvailable()) {
            if (a3.x.isLoggable(1024)) {
                a3.x.debug("Skipping pause since userstore is still mounted");
            }
            a2.set(false);
            return;
        }
        try {
            a3.getProcessManager().pause();
            a2.set(true);
        }
        catch (KindletExecutionException a4) {
            if (a3.getProcessManager() != null && a3.getProcessManager().hasActiveProcess() && null != a3.getProcessManager().getActiveProcess().getApplication()) {
                DETEventStreamFactory.getEventStream((Application)a3.getProcessManager().getActiveProcess().getApplication()).record((Event)new SimpleEvent("KindletExecutionExceptionOnPause"));
            }
            throw a4;
        }
    }

    protected void resumeProcess(String a, BookletLifecycleEvent a2, AtomicBoolean a3) throws KindletContainerException, IllegalKindletStateException {
        KindletBooklet a4;
        KindletProcess a5 = a4.getProcessManager().getActiveProcess();
        if (a5 == null) {
            a3.set(false);
            return;
        }
        Application a6 = a5.getApplication();
        if ("exit-ss".equals(a2.getId()) && !a4.E.getUSBStatusProvider().willUserstoreRemainAvailable()) {
            if (a4.x.isLoggable(1024)) {
                a4.x.debug("Skipping resume event since the userstore is unmounted.");
            }
            a3.set(false);
            return;
        }
        if (!a6.isInstalled()) {
            a4.killProcess(V, a2);
            a4.unloadAndThrowException(a2, new IllegalStateException(o), a4.getMessage(u, RESOURCE_BUNDLE_NAME));
        } else if (a6.isModified()) {
            if (!a4.checkAndThrowPendingException(a5, a, a2)) {
                a4.killProcess(V, a2);
                try {
                    Application a7 = a4.getApplication(a6.getFile());
                    a4.runProcess(a7, Q, a2);
                    a3.set(true);
                    return;
                }
                catch (InstallException a8) {
                    a4.x.debug("caught InstallException because the application has been modified");
                    a4.unloadAndThrowException(a2, (Exception)((Object)a8), a4.getMessage(a, RESOURCE_BUNDLE_NAME));
                }
            }
        } else if (!a4.checkAndThrowPendingException(a5, a, a2)) {
            try {
                a4.getProcessManager().resume();
                a3.set(true);
                return;
            }
            catch (KindletExecutionException a9) {
                String a10 = null;
                if (a != null) {
                    a10 = a4.getMessage(a, RESOURCE_BUNDLE_NAME);
                }
                DETEventStreamFactory.getEventStream((Application)a6).record((Event)new SimpleEvent("KindletExecutionExceptionOnResume"));
                a4.unloadAndThrowException(a2, (Exception)((Object)a9), a10);
            }
        }
        a3.set(false);
    }

    private boolean checkAndThrowPendingException(KindletProcess a, String a2, BookletLifecycleEvent a3) throws KindletContainerException, IllegalKindletStateException {
        if (a.hasPendingException()) {
            try {
                a.throwPendingException();
            }
            catch (KindletExecutionException a4) {
                if (a2 != null) {
                    KindletBooklet a5;
                    a5.unloadAndThrowException(a3, (Exception)((Object)a4), a5.getMessage(a2, RESOURCE_BUNDLE_NAME));
                }
                return true;
            }
        }
        return false;
    }

    protected void killProcess(String a, BookletLifecycleEvent a2) throws KindletContainerException, IllegalKindletStateException {
        KindletBooklet a3;
        KindletProcess a4 = a3.getProcessManager().getActiveProcess();
        try {
            a3.getProcessManager().kill();
        }
        catch (KindletExecutionException a5) {
            String a6 = null;
            if (a != null && a2 != null && !"unload".equals(a2.getId())) {
                a6 = a3.getMessage(a, RESOURCE_BUNDLE_NAME);
            }
            if (a4 != null) {
                DETEventStreamFactory.getEventStream((Application)a4.getApplication()).record((Event)new SimpleEvent("KindletExecutionExceptionOnKill"));
            }
            a3.unloadAndThrowException(a2, (Exception)((Object)a5), a6);
        }
    }

    private BookletServices.SwitchStatus getDefaultStatusCallback() {
        KindletBooklet a;
        return new BookletServices.SwitchStatus(){
            {
                4 a;
            }

            public void onStatus(int a) {
                if (a != 0) {
                    4 a2;
                    if (a2.KindletBooklet.this.x.isLoggable(1024)) {
                        a2.KindletBooklet.this.x.debug("Default status callback", "Switching to home failed with status = " + a + " requesting a restart");
                    }
                    a2.KindletBooklet.this.requestRestartKindleFramework();
                }
            }
        };
    }

    void postGoHomeSilently() {
        KindletBooklet a;
        a.postGoHome(a.getDefaultStatusCallback());
    }

    void postGoHome(final BookletServices.SwitchStatus a) {
        KindletBooklet a2;
        if (FrameworkRestart.hasRestartFrameworkRequestBeenMade()) {
            a2.x.warn("postGoHomeFail", "Did not post event to go Home. A framework restart request is pending.");
            return;
        }
        ThreadPool.getInstance().runIt(new Runnable(){
            {
                5 a2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                5 a3;
                KindletBooklet kindletBooklet = a3.KindletBooklet.this;
                synchronized (kindletBooklet) {
                    try {
                        a3.KindletBooklet.this.x.debug("Requesting to be switched to = com.lab126.booklet.home");
                        a3.KindletBooklet.this.j.switchToBooklet((Booklet)a3.KindletBooklet.this, KindletBooklet.t, a3.a);
                    }
                    catch (BookletException a2) {
                        a3.KindletBooklet.this.x.error("error while switching back to home", (Throwable)a2);
                    }
                }
            }
        }, "GoHomeFromKindlet");
    }

    String getMessage(String a, String a2) {
        if (V.equals(a) || Q.equals(a)) {
            return MarketplaceServiceHelper.getURLMessage((String)a2, (String)a);
        }
        return ResourceBundle.getBundle(a2).getString(a);
    }

    protected void requestRestartKindleFramework() {
        KindletBooklet a;
        final KindletSystemAlert a2 = a.E.getKindletSystemAlert();
        final KindleSystemServices a3 = (KindleSystemServices)a.getBookletContext().getService(KindleSystemServices.class);
        ThreadPool.getInstance().runIt(new Runnable(){
            {
                6 a;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                6 a;
                Object object = a.KindletBooklet.this.f;
                synchronized (object) {
                    FrameworkRestart.requestRestartKindleFramework(new Runnable(){
                        {
                            1 a;
                        }

                        public void run() {
                            1 a;
                            if (KindletBooklet.this.getProcessManager() != null) {
                                if (KindletBooklet.this.getProcessManager().hasActiveProcess()) {
                                    DETEventStreamFactory.getEventStream((Application)KindletBooklet.this.getProcessManager().getActiveProcess().getApplication()).record((Event)new SimpleEvent("CustomerIgnoredRestartRequest"));
                                }
                                KindletBooklet.this.getProcessManager().orphan();
                            }
                        }
                    }, a.a2, a.a3);
                }
            }
        }, "KindletBooklet-requestFrameworkRestart");
    }

    protected KindletProcessManager createProcessManager() throws KindletContainerException {
        KindletBooklet a;
        return new KindletProcessManager((KindletProcessFactory)new BookletSandboxKindletProcessFactory(a, a.E, a.g, a.G, new KindletBookletAppContextFactory(), a.d, a.i, a.m));
    }

    private void annotateMetricsWithHeapInfo(DeviceEventScope a) {
        a.insertMetadata("freeMemory", (Object)Long.toString(Runtime.getRuntime().freeMemory()));
    }

    private void annotateMetricsWithApplicationInfo(DeviceEventScope a) {
        KindletBooklet a2;
        if (null != a2.J && a2.J.hasActiveProcess()) {
            Application a3 = a2.J.getActiveProcess().getApplication();
            a.insertMetadata("implementationId", (Object)a3.getId());
            if (a3.isDeveloper()) {
                a.insertMetadata("implementationTitle", (Object)a3.getMetadata().getName());
                a.insertMetadata("isDeveloper", (Object)Boolean.TRUE.toString());
            }
        }
    }

    private void annotateMetricsWithEventType(DeviceEventScope a, BookletLifecycleEvent a2) {
        a.insertMetadata("lifecycleEventType", (Object)a2.getId());
    }

    public String toString() {
        return DET_EVENT_NAME;
    }

    public JFrame createFrame(String layer, String role) {
        if (this.getProcessManager() != null && this.getProcessManager().getActiveProcess() != null) {
            if (this.x.isLoggable(1024)) {
                this.x.debug("BookletExtension#createFrame() invoked on KindletBooklet. ", new String[]{"layer", "role"}, new Object[]{layer, role});
            }
            JFrame a = this.getProcessManager().getActiveProcess().getFrame(layer, role);
            if (this.x.isLoggable(1024)) {
                this.x.debug("return result = " + a);
            }
            return a;
        }
        this.x.warn("no active process found. returning a null JFrame");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable r, String runnableName, boolean inEventQueue) {
        if (inEventQueue) {
            KindletBooklet kindletBooklet = this;
            synchronized (kindletBooklet) {
                this.eventQueueInvokeLater(r, runnableName, inEventQueue);
            }
        } else {
            if (this.x.isLoggable(1024)) {
                this.x.debug("BookletExtension#invokeLater() invoked on default Framework threadpool for " + runnableName);
            }
            ThreadPool.getInstance().runIt(r, runnableName);
        }
    }

    private void eventQueueInvokeLater(Runnable a, String a2, boolean a3) {
        KindletBooklet a4;
        if (a4.getProcessManager() != null && a4.getProcessManager().getActiveProcess() != null) {
            if (a4.x.isLoggable(1024)) {
                a4.x.debug("BookletExtension#invokeLater() invoked on sandbox event queue for " + a2);
            }
            a4.getProcessManager().getActiveProcess().invokeLater(a, a3);
        } else {
            if (a4.x.isLoggable(1024)) {
                a4.x.debug("Sandbox process not created yet to execute UI runnables. Using SwingUtilities.invokeLater()");
            }
            SwingUtilities.invokeLater(a);
        }
    }
}

